/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.types.stream.lazy;

import com.aol.cyclops.control.Eval;
import com.aol.cyclops.types.stream.HasStream;
import com.aol.cyclops.types.stream.lazy.IntOperators;
import java.util.IntSummaryStatistics;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.ToIntFunction;
import java.util.stream.IntStream;

public interface IntOperatorsMixin<T>
extends IntOperators<T>,
HasStream<T> {
    @Override
    default public Eval<Integer> sumInt(ToIntFunction<? super T> fn) {
        return Eval.later(() -> this.getStream().flatMapToInt(t -> IntStream.of(fn.applyAsInt(t))).sum());
    }

    @Override
    default public Eval<OptionalInt> maxInt(ToIntFunction<? super T> fn) {
        return Eval.later(() -> this.getStream().flatMapToInt(t -> IntStream.of(fn.applyAsInt(t))).max());
    }

    @Override
    default public Eval<OptionalInt> minInt(ToIntFunction<? super T> fn) {
        return Eval.later(() -> this.getStream().flatMapToInt(t -> IntStream.of(fn.applyAsInt(t))).min());
    }

    @Override
    default public Eval<OptionalDouble> averageInt(ToIntFunction<? super T> fn) {
        return Eval.later(() -> this.getStream().flatMapToInt(t -> IntStream.of(fn.applyAsInt(t))).average());
    }

    @Override
    default public Eval<IntSummaryStatistics> summaryStatisticsInt(ToIntFunction<? super T> fn) {
        return Eval.later(() -> this.getStream().flatMapToInt(t -> IntStream.of(fn.applyAsInt(t))).summaryStatistics());
    }
}

