/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.types.stream.future;

import com.aol.cyclops.types.stream.HasExec;
import com.aol.cyclops.types.stream.HasStream;
import com.aol.cyclops.types.stream.future.DoubleOperators;
import java.util.DoubleSummaryStatistics;
import java.util.OptionalDouble;
import java.util.concurrent.CompletableFuture;
import java.util.function.ToDoubleFunction;
import java.util.stream.DoubleStream;

public interface DoubleOperatorsMixin<T>
extends DoubleOperators<T>,
HasStream<T>,
HasExec {
    @Override
    default public CompletableFuture<Double> sumDouble(ToDoubleFunction<? super T> fn) {
        return CompletableFuture.supplyAsync(() -> this.getStream().flatMapToDouble(t -> DoubleStream.of(fn.applyAsDouble(t))).sum(), this.getExec());
    }

    @Override
    default public CompletableFuture<OptionalDouble> maxDouble(ToDoubleFunction<? super T> fn) {
        return CompletableFuture.supplyAsync(() -> this.getStream().flatMapToDouble(t -> DoubleStream.of(fn.applyAsDouble(t))).max(), this.getExec());
    }

    @Override
    default public CompletableFuture<OptionalDouble> minDouble(ToDoubleFunction<? super T> fn) {
        return CompletableFuture.supplyAsync(() -> this.getStream().flatMapToDouble(t -> DoubleStream.of(fn.applyAsDouble(t))).min(), this.getExec());
    }

    @Override
    default public CompletableFuture<OptionalDouble> averageDouble(ToDoubleFunction<? super T> fn) {
        return CompletableFuture.supplyAsync(() -> this.getStream().flatMapToDouble(t -> DoubleStream.of(fn.applyAsDouble(t))).average(), this.getExec());
    }

    @Override
    default public CompletableFuture<DoubleSummaryStatistics> summaryStatisticsDouble(ToDoubleFunction<? super T> fn) {
        return CompletableFuture.supplyAsync(() -> this.getStream().flatMapToDouble(t -> DoubleStream.of(fn.applyAsDouble(t))).summaryStatistics(), this.getExec());
    }
}

