/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.types.stream;

import com.aol.cyclops.Reducers;
import com.aol.cyclops.control.Eval;
import com.aol.cyclops.control.FutureW;
import com.aol.cyclops.control.Ior;
import com.aol.cyclops.control.LazyReact;
import com.aol.cyclops.control.Maybe;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.SimpleReact;
import com.aol.cyclops.control.Try;
import com.aol.cyclops.control.Xor;
import com.aol.cyclops.data.collections.extensions.persistent.PBagX;
import com.aol.cyclops.data.collections.extensions.persistent.PMapX;
import com.aol.cyclops.data.collections.extensions.persistent.POrderedSetX;
import com.aol.cyclops.data.collections.extensions.persistent.PQueueX;
import com.aol.cyclops.data.collections.extensions.persistent.PSetX;
import com.aol.cyclops.data.collections.extensions.persistent.PStackX;
import com.aol.cyclops.data.collections.extensions.persistent.PVectorX;
import com.aol.cyclops.data.collections.extensions.standard.DequeX;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.data.collections.extensions.standard.MapX;
import com.aol.cyclops.data.collections.extensions.standard.QueueX;
import com.aol.cyclops.data.collections.extensions.standard.SetX;
import com.aol.cyclops.data.collections.extensions.standard.SortedSetX;
import com.aol.cyclops.types.Value;
import com.aol.cyclops.types.futurestream.LazyFutureStream;
import com.aol.cyclops.types.futurestream.SimpleReactStream;
import com.aol.cyclops.util.stream.StreamUtils;
import com.aol.cyclops.util.stream.Streamable;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple;

public interface ConvertableSequence<T>
extends Iterable<T> {
    default public ReactiveSeq<T> stream() {
        return ReactiveSeq.fromIterable(this);
    }

    default public Seq<T> seq() {
        return Seq.seq((Iterable)this);
    }

    default public LazyFutureStream<T> toFutureStream(LazyReact reactor) {
        return reactor.fromIterable(this);
    }

    default public LazyFutureStream<T> toFutureStream() {
        return new LazyReact().fromIterable(this);
    }

    default public SimpleReactStream<T> toSimpleReact(SimpleReact reactor) {
        return reactor.fromIterable(this);
    }

    default public SimpleReactStream<T> toSimpleReact() {
        return new SimpleReact().fromIterable(this);
    }

    default public Streamable<T> toStreamable() {
        return this.stream().toStreamable();
    }

    default public DequeX<T> toDequeX() {
        return DequeX.fromIterable(this);
    }

    default public QueueX<T> toQueueX() {
        return QueueX.fromIterable(this);
    }

    default public SetX<T> toSetX() {
        return SetX.fromIterable(this);
    }

    default public SortedSetX<T> toSortedSetX() {
        return SortedSetX.fromIterable(this);
    }

    default public ListX<T> toListX() {
        return ListX.fromIterable(this);
    }

    default public <K, V> PMapX<K, V> toPMapX(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        Stream stream = this.stream().map(t -> Tuple.tuple(keyMapper.apply(t), valueMapper.apply(t)));
        return stream.mapReduce(Reducers.toPMapX());
    }

    default public <K, V> MapX<K, V> toMapX(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return MapX.fromMap(this.stream().toMap(keyMapper, valueMapper));
    }

    default public PStackX<T> toPStackX() {
        return PStackX.fromIterable(this);
    }

    default public PVectorX<T> toPVectorX() {
        return PVectorX.fromIterable(this);
    }

    default public PQueueX<T> toPQueueX() {
        return PQueueX.fromIterable(this);
    }

    default public PBagX<T> toPBagX() {
        return PBagX.fromIterable(this);
    }

    default public PSetX<T> toPSetX() {
        return PSetX.fromIterable(this);
    }

    default public POrderedSetX<T> toPOrderedSetX() {
        return POrderedSetX.fromIterable(this);
    }

    default public Optional<ListX<T>> toOptional() {
        ListX<T> list = this.toListX();
        if (list.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(list);
    }

    default public Value<ListX<T>> toValue() {
        return Eval.later(() -> ListX.fromIterable(StreamUtils.stream(this).collect(Collectors.toList())));
    }

    default public Value<SetX<T>> toValueSet() {
        return () -> SetX.fromIterable(StreamUtils.stream(this).collect(Collectors.toSet()));
    }

    default public <K, V> Value<MapX<K, V>> toValueMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return () -> MapX.fromMap(StreamUtils.stream(this).collect(Collectors.toMap(keyMapper, valueMapper)));
    }

    default public Maybe<ListX<T>> toMaybe() {
        return Maybe.fromOptional(this.toOptional());
    }

    default public Xor<?, ListX<T>> toXor() {
        return this.toValue().toXor();
    }

    default public Xor<ListX<T>, ?> toXorSecondary() {
        return this.toValue().toXor().swap();
    }

    default public Try<ListX<T>, Throwable> toTry() {
        return this.toValue().toTry();
    }

    default public Ior<?, ListX<T>> toIor() {
        return this.toValue().toIor();
    }

    default public Ior<ListX<T>, ?> toIorSecondary() {
        return this.toValue().toIor().swap();
    }

    default public Eval<ListX<T>> toEvalNow() {
        return this.toValue().toEvalNow();
    }

    default public Eval<ListX<T>> toEvalLater() {
        return this.toValue().toEvalLater();
    }

    default public Eval<ListX<T>> toEvalAlways() {
        return this.toValue().toEvalAlways();
    }

    default public CompletableFuture<ListX<T>> toCompletableFuture() {
        return this.toValue().toCompletableFuture();
    }

    default public FutureW<ListX<T>> toFutureW() {
        return FutureW.of(this.toCompletableFuture());
    }
}

