/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.types.futurestream;

import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.data.async.Queue;
import com.aol.cyclops.types.futurestream.BaseSimpleReactStream;
import com.aol.cyclops.types.futurestream.SimpleReactStream;
import com.aol.cyclops.types.futurestream.Val;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple;
import org.jooq.lambda.tuple.Tuple2;

public class EagerFutureStreamFunctions {
    static void closeOthers(Queue active, List<Queue> all) {
        all.stream().filter(next -> next != active).forEach(Queue::closeAndClear);
    }

    static void closeOthers(SimpleReactStream active, List<SimpleReactStream> all) {
        all.stream().filter(next -> next != active).filter(s -> s instanceof BaseSimpleReactStream).forEach(SimpleReactStream::cancel);
    }

    static <T1, T2> Seq<Tuple2<T1, T2>> combineLatest(SimpleReactStream<T1> left, SimpleReactStream<T2> right) {
        return EagerFutureStreamFunctions.combineLatest(left, right, Tuple::tuple);
    }

    @SafeVarargs
    public static <U> SimpleReactStream<U> firstOf(SimpleReactStream<U> ... futureStreams) {
        List racers = Stream.of(futureStreams).map(s -> Tuple.tuple((Object)s, new Queue.QueueReader<Object>(s.toQueue(), null))).collect(Collectors.toList());
        while (true) {
            for (Tuple2 q : racers) {
                if (!((Queue.QueueReader)q.v2).notEmpty()) continue;
                EagerFutureStreamFunctions.closeOthers(((Queue.QueueReader)q.v2).getQueue(), racers.stream().map(t -> ((Queue.QueueReader)t.v2).getQueue()).collect(Collectors.toList()));
                EagerFutureStreamFunctions.closeOthers((SimpleReactStream)q.v1, racers.stream().map(t -> (SimpleReactStream)t.v1).collect(Collectors.toList()));
                return ((SimpleReactStream)q.v1).fromStream((Stream)((Queue.QueueReader)q.v2).getQueue().stream(((SimpleReactStream)q.v1).getSubscription()));
            }
            LockSupport.parkNanos(1L);
        }
    }

    static <T1, T2, R> Seq<R> combineLatest(SimpleReactStream<T1> left, SimpleReactStream<T2> right, final BiFunction<T1, T2, R> zipper) {
        Queue q = left.then(it -> new Val<Object>(Val.Pos.left, it)).merge(new SimpleReactStream[]{right.then(it -> new Val<Object>(Val.Pos.right, it))}).toQueue();
        final Iterator it2 = q.stream(left.getSubscription()).iterator();
        class Zip
        implements Iterator<R> {
            T1 lastLeft = null;
            T2 lastRight = null;

            Zip() {
            }

            @Override
            public boolean hasNext() {
                return it2.hasNext();
            }

            @Override
            public R next() {
                Val v = (Val)it2.next();
                if (v.pos == Val.Pos.left) {
                    this.lastLeft = v.val;
                } else {
                    this.lastRight = v.val;
                }
                return zipper.apply(this.lastLeft, this.lastRight);
            }
        }
        return Seq.seq((Iterator)new Zip());
    }

    static <T1, T2> Seq<Tuple2<T1, T2>> withLatest(SimpleReactStream<T1> left, SimpleReactStream<T2> right) {
        return EagerFutureStreamFunctions.withLatest(left, right, Tuple::tuple);
    }

    static <T1, T2, R> Seq<R> withLatest(SimpleReactStream<T1> left, SimpleReactStream<T2> right, final BiFunction<T1, T2, R> zipper) {
        Queue q = left.then(it -> new Val<Object>(Val.Pos.left, it)).merge(new SimpleReactStream[]{right.then(it -> new Val<Object>(Val.Pos.right, it))}).toQueue();
        final Iterator it2 = q.stream(left.getSubscription()).iterator();
        class Zip
        implements Iterator<R> {
            T1 lastLeft = null;
            T2 lastRight = null;

            Zip() {
            }

            @Override
            public boolean hasNext() {
                return it2.hasNext();
            }

            @Override
            public R next() {
                Val v = (Val)it2.next();
                if (v.pos == Val.Pos.left) {
                    this.lastLeft = v.val;
                    return zipper.apply(this.lastLeft, this.lastRight);
                }
                this.lastRight = v.val;
                return Optional.empty();
            }
        }
        return Seq.seq((Iterator)new Zip()).filter(next -> !(next instanceof Optional));
    }

    static <T1, T2> ReactiveSeq<T1> skipUntil(SimpleReactStream<T1> left, SimpleReactStream<T2> right) {
        Queue q = left.then(it -> new Val<Object>(Val.Pos.left, it)).merge(new SimpleReactStream[]{right.then(it -> new Val<Object>(Val.Pos.right, it))}).toQueue();
        Iterator it2 = q.stream(left.getSubscription()).iterator();
        Object missingValue = new Object();
        return ReactiveSeq.fromIterable(() -> {
            class Zip
            implements Iterator<T1> {
                Optional<T1> lastLeft = Optional.empty();
                Optional<T2> lastRight = Optional.empty();
                final /* synthetic */ Iterator val$it;

                Zip(Iterator iterator) {
                    this.val$it = iterator;
                }

                @Override
                public boolean hasNext() {
                    return this.val$it.hasNext();
                }

                @Override
                public T1 next() {
                    Val v = (Val)this.val$it.next();
                    if (v.pos == Val.Pos.left) {
                        if (this.lastRight.isPresent()) {
                            this.lastLeft = Optional.of(v.val);
                        }
                    } else {
                        this.lastRight = Optional.of(v.val);
                    }
                    if (!this.lastRight.isPresent()) {
                        return Optional.empty();
                    }
                    if (this.lastLeft.isPresent()) {
                        return this.lastLeft.get();
                    }
                    return Optional.empty();
                }
            }
            return new Zip(it2);
        }).filter(next -> !(next instanceof Optional));
    }

    static <T1, T2> ReactiveSeq<T1> takeUntil(SimpleReactStream<T1> left, SimpleReactStream<T2> right) {
        Queue q = left.then(it -> new Val<Object>(Val.Pos.left, it)).merge(new SimpleReactStream[]{right.then(it -> new Val<Object>(Val.Pos.right, it))}).toQueue();
        Iterator it2 = q.stream(left.getSubscription()).iterator();
        Object missingValue = new Object();
        return ReactiveSeq.fromIterable(() -> {
            class Zip
            implements Iterator<T1> {
                Optional<T1> lastLeft = Optional.empty();
                Optional<T2> lastRight = Optional.empty();
                boolean closed = false;
                final /* synthetic */ Iterator val$it;

                Zip(Iterator iterator) {
                    this.val$it = iterator;
                }

                @Override
                public boolean hasNext() {
                    return !this.closed && this.val$it.hasNext();
                }

                @Override
                public T1 next() {
                    Val v = (Val)this.val$it.next();
                    if (v.pos == Val.Pos.left) {
                        this.lastLeft = Optional.of(v.val);
                    } else {
                        this.lastRight = Optional.of(v.val);
                    }
                    if (!this.lastRight.isPresent() && this.lastLeft.isPresent()) {
                        return this.lastLeft.get();
                    }
                    this.closed = true;
                    return Optional.empty();
                }
            }
            return new Zip(it2);
        }).filter(next -> !(next instanceof Optional));
    }
}

