/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.types;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.Reducer;
import com.aol.cyclops.control.Ior;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.Validator;
import com.aol.cyclops.control.Xor;
import com.aol.cyclops.data.collections.extensions.CollectionX;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.data.collections.extensions.standard.MapX;
import com.aol.cyclops.types.stream.HotStream;
import com.aol.cyclops.util.stream.Streamable;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jooq.lambda.tuple.Tuple2;

public interface Foldable<T> {
    public ReactiveSeq<T> stream();

    default public Foldable<T> foldable() {
        return this.stream();
    }

    default public <R> R mapReduce(Reducer<R> reducer) {
        return this.foldable().mapReduce(reducer);
    }

    default public <R> R mapReduce(Function<? super T, ? extends R> mapper, Monoid<R> reducer) {
        return this.foldable().mapReduce(mapper, reducer);
    }

    default public T reduce(Monoid<T> reducer) {
        return this.foldable().reduce(reducer);
    }

    default public Optional<T> reduce(BinaryOperator<T> accumulator) {
        return this.foldable().reduce(accumulator);
    }

    default public T reduce(T identity, BinaryOperator<T> accumulator) {
        return this.foldable().reduce(identity, accumulator);
    }

    default public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator) {
        Foldable<? super T> foldable = this.foldable();
        return foldable.reduce(identity, accumulator);
    }

    default public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        return this.foldable().reduce(identity, accumulator, combiner);
    }

    default public ListX<T> reduce(Stream<? extends Monoid<T>> reducers) {
        return this.foldable().reduce(reducers);
    }

    default public ListX<T> reduce(Iterable<? extends Monoid<T>> reducers) {
        return this.foldable().reduce(reducers);
    }

    default public T foldRight(Monoid<T> reducer) {
        return this.foldable().foldRight(reducer);
    }

    default public T foldRight(T identity, BinaryOperator<T> accumulator) {
        return this.foldable().foldRight(identity, accumulator);
    }

    default public <U> U foldRight(U identity, BiFunction<? super T, ? super U, ? extends U> accumulator) {
        return this.foldable().foldRight(identity, accumulator);
    }

    default public <T> T foldRightMapToType(Reducer<T> reducer) {
        return this.foldable().foldRightMapToType(reducer);
    }

    default public String join() {
        return this.foldable().join();
    }

    default public String join(String sep) {
        return this.foldable().join(sep);
    }

    default public String join(String sep, String start, String end) {
        return this.foldable().join(sep, start, end);
    }

    default public void print(PrintStream str) {
        this.foldable().print(str);
    }

    default public void print(PrintWriter writer) {
        this.foldable().print(writer);
    }

    default public void printOut() {
        this.foldable().printOut();
    }

    default public void printErr() {
        this.foldable().printErr();
    }

    default public <K> MapX<K, List<T>> groupBy(Function<? super T, ? extends K> classifier) {
        return this.foldable().groupBy(classifier);
    }

    default public Optional<T> findFirst() {
        return this.foldable().findFirst();
    }

    default public Optional<T> findAny() {
        return this.foldable().findAny();
    }

    default public boolean startsWithIterable(Iterable<T> iterable) {
        return this.foldable().startsWithIterable(iterable);
    }

    default public boolean startsWith(Stream<T> stream) {
        return this.foldable().startsWith(stream);
    }

    default public boolean endsWithIterable(Iterable<T> iterable) {
        return this.foldable().endsWithIterable(iterable);
    }

    default public boolean endsWith(Stream<T> stream) {
        return this.foldable().endsWith(stream);
    }

    default public CollectionX<T> toLazyCollection() {
        return this.foldable().toLazyCollection();
    }

    default public CollectionX<T> toConcurrentLazyCollection() {
        return this.foldable().toConcurrentLazyCollection();
    }

    default public Streamable<T> toConcurrentLazyStreamable() {
        return this.foldable().toConcurrentLazyStreamable();
    }

    default public T firstValue() {
        return this.foldable().firstValue();
    }

    default public T single() {
        return this.foldable().single();
    }

    default public T single(Predicate<? super T> predicate) {
        return this.foldable().single(predicate);
    }

    default public Optional<T> singleOptional() {
        return this.foldable().singleOptional();
    }

    default public Optional<T> get(long index) {
        return this.foldable().get(index);
    }

    default public HotStream<T> schedule(String cron, ScheduledExecutorService ex) {
        return this.foldable().schedule(cron, ex);
    }

    default public HotStream<T> scheduleFixedDelay(long delay, ScheduledExecutorService ex) {
        return this.foldable().scheduleFixedDelay(delay, ex);
    }

    default public HotStream<T> scheduleFixedRate(long rate, ScheduledExecutorService ex) {
        return this.foldable().scheduleFixedRate(rate, ex);
    }

    default public <S, F> Ior<ReactiveSeq<F>, ReactiveSeq<S>> validate(Validator<T, S, F> validator) {
        Tuple2 xors = this.stream().flatMap(s -> validator.accumulate(s).toXors().stream()).duplicateSequence();
        Predicate<Xor> primaryPredicate = e -> e.isPrimary();
        return Ior.both(((ReactiveSeq)xors.v1).filter(primaryPredicate.negate()).map(x -> x.secondaryGet()), ((ReactiveSeq)xors.v2).filter(primaryPredicate).map(x -> x.get()));
    }

    default public boolean xMatch(int num, Predicate<? super T> c) {
        return this.foldable().xMatch(num, c);
    }
}

