/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.react.collectors.lazy;

import com.aol.cyclops.internal.react.async.future.FastFuture;
import com.aol.cyclops.react.collectors.lazy.LazyResultConsumer;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.function.Function;

public class SamplingCollector<T>
implements LazyResultConsumer<T> {
    private final int sampleRate;
    private long count = 0L;
    private final LazyResultConsumer<T> consumer;

    public SamplingCollector(int sampleRate, LazyResultConsumer<T> consumer) {
        this.sampleRate = sampleRate;
        this.consumer = consumer;
    }

    @Override
    public void accept(FastFuture<T> t) {
        if (this.count++ % (long)this.sampleRate == 0L) {
            this.consumer.accept(t);
        }
    }

    @Override
    public void block(Function<FastFuture<T>, T> safeJoin) {
        this.consumer.block(safeJoin);
    }

    @Override
    public LazyResultConsumer<T> withResults(Collection<FastFuture<T>> t) {
        return this.withConsumer(this.consumer.withResults(t));
    }

    @Override
    public Collection<FastFuture<T>> getResults() {
        return this.consumer.getResults();
    }

    @Override
    public Collection<FastFuture<T>> getAllResults() {
        return this.consumer.getResults();
    }

    public static <T> SamplingCollectorBuilder<T> builder() {
        return new SamplingCollectorBuilder();
    }

    @ConstructorProperties(value={"sampleRate", "count", "consumer"})
    public SamplingCollector(int sampleRate, long count, LazyResultConsumer<T> consumer) {
        this.sampleRate = sampleRate;
        this.count = count;
        this.consumer = consumer;
    }

    public SamplingCollector<T> withSampleRate(int sampleRate) {
        return this.sampleRate == sampleRate ? this : new SamplingCollector<T>(sampleRate, this.count, this.consumer);
    }

    public SamplingCollector<T> withCount(long count) {
        return this.count == count ? this : new SamplingCollector<T>(this.sampleRate, count, this.consumer);
    }

    public SamplingCollector<T> withConsumer(LazyResultConsumer<T> consumer) {
        return this.consumer == consumer ? this : new SamplingCollector<T>(this.sampleRate, this.count, consumer);
    }

    public static class SamplingCollectorBuilder<T> {
        private int sampleRate;
        private long count;
        private LazyResultConsumer<T> consumer;

        SamplingCollectorBuilder() {
        }

        public SamplingCollectorBuilder<T> sampleRate(int sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public SamplingCollectorBuilder<T> count(long count) {
            this.count = count;
            return this;
        }

        public SamplingCollectorBuilder<T> consumer(LazyResultConsumer<T> consumer) {
            this.consumer = consumer;
            return this;
        }

        public SamplingCollector<T> build() {
            return new SamplingCollector<T>(this.sampleRate, this.count, this.consumer);
        }

        public String toString() {
            return "SamplingCollector.SamplingCollectorBuilder(sampleRate=" + this.sampleRate + ", count=" + this.count + ", consumer=" + this.consumer + ")";
        }
    }
}

