/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.react.async.subscription;

import com.aol.cyclops.data.async.Queue;
import com.aol.cyclops.react.async.subscription.Continueable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jooq.lambda.Seq;

public class Subscription
implements Continueable {
    private final Map<Queue, AtomicLong> limits = new HashMap<Queue, AtomicLong>();
    private final Map<Queue, AtomicBoolean> unlimited = new HashMap<Queue, AtomicBoolean>();
    private final Map<Queue, AtomicLong> count = new HashMap<Queue, AtomicLong>();
    private final List<Queue> queues = new LinkedList<Queue>();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicLong timeLimitNanos = new AtomicLong(-1L);

    @Override
    public long timeLimit() {
        return this.timeLimitNanos.get();
    }

    @Override
    public void registerSkip(long skip) {
        if (this.queues.size() > 0) {
            this.limits.get(this.currentQueue()).addAndGet(skip);
        }
    }

    @Override
    public void registerTimeLimit(long nanos) {
        if (this.timeLimitNanos.get() == -1L || this.timeLimitNanos.get() > nanos) {
            this.timeLimitNanos.set(nanos);
        }
    }

    @Override
    public void registerLimit(long limit) {
        if (this.queues.size() > 0) {
            if (this.unlimited.get(this.currentQueue()).get()) {
                this.limits.get(this.currentQueue()).set(0L);
            }
            this.limits.get(this.currentQueue()).addAndGet(limit);
            this.unlimited.get(this.currentQueue()).set(false);
            this.queues.stream().forEach(this::closeQueueIfFinishedStateless);
        }
    }

    private Queue currentQueue() {
        return this.queues.get(this.queues.size() - 1);
    }

    @Override
    public void addQueue(Queue q) {
        this.queues.add(q);
        this.limits.put(q, new AtomicLong(0x7FFFFFFFFFFFFFFEL));
        this.unlimited.put(q, new AtomicBoolean(true));
        this.count.put(q, new AtomicLong(0L));
    }

    @Override
    public void closeQueueIfFinished(Queue queue) {
        this.closeQueueIfFinished(queue, AtomicLong::incrementAndGet);
    }

    private void closeQueueIfFinished(Queue queue, Function<AtomicLong, Long> fn) {
        long limit;
        if (this.queues.size() == 0) {
            return;
        }
        long queueCount = fn.apply(this.count.get(queue));
        if (queueCount >= (limit = ((Long)this.valuesToRight(queue).stream().reduce((acc, next) -> Math.min(acc, next)).get()).longValue())) {
            queue.closeAndClear();
            this.closed.set(true);
        }
    }

    @Override
    public void closeQueueIfFinishedStateless(Queue queue) {
        this.closeQueueIfFinished(queue, AtomicLong::get);
    }

    private List<Long> valuesToRight(Queue queue) {
        return (List)((Seq)Seq.seq(this.queues.stream()).splitAt((long)((long)this.findQueue((Queue)queue))).v2).map(this.limits::get).map(AtomicLong::get).collect(Collectors.toList());
    }

    private Seq<Queue> queuesToLeft(Queue queue) {
        return (Seq)Seq.seq(this.queues.stream()).splitAt((long)((long)this.findQueue((Queue)queue))).v1;
    }

    private int findQueue(Queue queue) {
        for (int i = 0; i < this.queues.size(); ++i) {
            if (this.queues.get(i) != queue) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void closeAll(Queue queue) {
        this.closed.set(true);
        if (queue != null) {
            queue.closeAndClear();
            this.queuesToLeft(queue).forEach(Queue::closeAndClear);
        }
    }

    @Override
    public void closeAll() {
        this.closed.set(true);
        this.queues.stream().forEach(Queue::closeAndClear);
    }

    @Override
    public boolean closed() {
        return this.closed.get();
    }

    public Map<Queue, AtomicLong> getLimits() {
        return this.limits;
    }

    public Map<Queue, AtomicBoolean> getUnlimited() {
        return this.unlimited;
    }

    public Map<Queue, AtomicLong> getCount() {
        return this.count;
    }

    public List<Queue> getQueues() {
        return this.queues;
    }

    public AtomicBoolean getClosed() {
        return this.closed;
    }

    public AtomicLong getTimeLimitNanos() {
        return this.timeLimitNanos;
    }
}

