/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.stream.spliterators;

import com.aol.cyclops.internal.stream.spliterators.ReversableSpliterator;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;

public class ReversingArraySpliterator<T>
implements Spliterator<T>,
ReversableSpliterator {
    private final Object[] array;
    private boolean reverse;
    int index = 0;

    @Override
    public long estimateSize() {
        return this.array.length;
    }

    @Override
    public int characteristics() {
        return 1024;
    }

    @Override
    public ReversingArraySpliterator<T> invert() {
        this.setReverse(!this.isReverse());
        this.index = this.array.length - 1;
        return this;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        if (!this.reverse) {
            if (this.index < this.array.length && this.index > -1) {
                action.accept(this.array[this.index++]);
                return true;
            }
        } else if (this.index > -1 & this.index < this.array.length) {
            action.accept(this.array[this.index--]);
            return true;
        }
        return false;
    }

    @Override
    public Spliterator<T> trySplit() {
        return this;
    }

    @Override
    public ReversableSpliterator copy() {
        return new ReversingArraySpliterator<T>(this.array, this.reverse, this.index);
    }

    @ConstructorProperties(value={"array", "reverse", "index"})
    public ReversingArraySpliterator(Object[] array, boolean reverse, int index) {
        this.array = array;
        this.reverse = reverse;
        this.index = index;
    }

    @Override
    public boolean isReverse() {
        return this.reverse;
    }

    @Override
    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }
}

