/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.stream.operators;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.Reducer;
import com.aol.cyclops.util.stream.StreamUtils;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MultiReduceOperator<R> {
    private final Stream<R> stream;

    public List<R> reduce(final Iterable<? extends Monoid<R>> reducers) {
        Reducer m = new Reducer(){

            @Override
            public List zero() {
                return StreamUtils.stream(reducers).map(r -> r.zero()).collect(Collectors.toList());
            }

            @Override
            public BiFunction<List, List, List> combiner() {
                return (c1, c2) -> {
                    ArrayList l = new ArrayList();
                    int i = 0;
                    for (Monoid next : reducers) {
                        l.add(next.combiner().apply(c1.get(i), c2.get(0)));
                        ++i;
                    }
                    return l;
                };
            }

            public Stream mapToType(Stream stream) {
                return stream.map(value -> Arrays.asList(value));
            }
        };
        return (List)m.mapReduce(this.stream);
    }

    @ConstructorProperties(value={"stream"})
    public MultiReduceOperator(Stream<R> stream) {
        this.stream = stream;
    }
}

