/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.react;

import com.aol.cyclops.control.SimpleReact;
import com.aol.cyclops.data.async.Queue;
import com.aol.cyclops.data.async.QueueFactories;
import com.aol.cyclops.data.async.QueueFactory;
import com.aol.cyclops.internal.react.stream.EagerStreamWrapper;
import com.aol.cyclops.react.async.subscription.AlwaysContinue;
import com.aol.cyclops.react.async.subscription.Continueable;
import com.aol.cyclops.types.futurestream.EagerToQueue;
import com.aol.cyclops.types.futurestream.SimpleReactStream;
import com.nurkiewicz.asyncretry.RetryExecutor;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleReactStreamImpl<U>
implements SimpleReactStream<U>,
EagerToQueue<U> {
    private static final Logger log = LoggerFactory.getLogger(SimpleReactStreamImpl.class);
    private final Optional<Consumer<Throwable>> errorHandler;
    private final EagerStreamWrapper lastActive;
    private final QueueFactory<U> queueFactory;
    private final SimpleReact simpleReact;
    private final Continueable subscription;

    public SimpleReactStreamImpl(SimpleReact simpleReact, Stream<CompletableFuture<U>> stream) {
        this.simpleReact = simpleReact;
        Stream<CompletableFuture> s = stream;
        this.errorHandler = Optional.of(e -> log.error(e.getMessage(), e));
        this.lastActive = new EagerStreamWrapper(s, this.errorHandler);
        this.queueFactory = QueueFactories.unboundedQueue();
        this.subscription = new AlwaysContinue();
    }

    @Override
    public SimpleReactStream<U> withAsync(boolean b) {
        return this.withSimpleReact(this.simpleReact.withAsync(b));
    }

    @Override
    public <R> SimpleReactStream<R> thenSync(Function<? super U, ? extends R> fn) {
        return SimpleReactStream.super.thenSync((Function)fn);
    }

    @Override
    public <R1, R2> SimpleReactStream<R2> allOf(Collector<? super U, ?, R1> collector, Function<? super R1, ? extends R2> fn) {
        return SimpleReactStream.super.allOf(collector, fn);
    }

    @Override
    public Executor getTaskExecutor() {
        return this.simpleReact.getExecutor();
    }

    @Override
    public RetryExecutor getRetrier() {
        return this.simpleReact.getRetrier();
    }

    @Override
    public boolean isAsync() {
        return this.simpleReact.isAsync();
    }

    @Override
    public Queue<U> toQueue() {
        return EagerToQueue.super.toQueue();
    }

    @Override
    public SimpleReactStream<U> withTaskExecutor(Executor e) {
        return this.withSimpleReact(this.simpleReact.withExecutor(e));
    }

    @Override
    public SimpleReactStream<U> withRetrier(RetryExecutor retry) {
        return this.withSimpleReact(this.simpleReact.withRetrier(retry));
    }

    @Override
    public SimpleReactStreamImpl<U> withErrorHandler(Optional<Consumer<Throwable>> errorHandler) {
        return this.errorHandler == errorHandler ? this : new SimpleReactStreamImpl<U>(errorHandler, this.lastActive, this.queueFactory, this.simpleReact, this.subscription);
    }

    @Override
    public SimpleReactStreamImpl<U> withLastActive(EagerStreamWrapper lastActive) {
        return this.lastActive == lastActive ? this : new SimpleReactStreamImpl<U>(this.errorHandler, lastActive, this.queueFactory, this.simpleReact, this.subscription);
    }

    @Override
    public SimpleReactStreamImpl<U> withQueueFactory(QueueFactory<U> queueFactory) {
        return this.queueFactory == queueFactory ? this : new SimpleReactStreamImpl<U>(this.errorHandler, this.lastActive, queueFactory, this.simpleReact, this.subscription);
    }

    public SimpleReactStreamImpl<U> withSimpleReact(SimpleReact simpleReact) {
        return this.simpleReact == simpleReact ? this : new SimpleReactStreamImpl<U>(this.errorHandler, this.lastActive, this.queueFactory, simpleReact, this.subscription);
    }

    @Override
    public SimpleReactStreamImpl<U> withSubscription(Continueable subscription) {
        return this.subscription == subscription ? this : new SimpleReactStreamImpl<U>(this.errorHandler, this.lastActive, this.queueFactory, this.simpleReact, subscription);
    }

    @Override
    public Optional<Consumer<Throwable>> getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public EagerStreamWrapper getLastActive() {
        return this.lastActive;
    }

    @Override
    public QueueFactory<U> getQueueFactory() {
        return this.queueFactory;
    }

    @Override
    public SimpleReact getSimpleReact() {
        return this.simpleReact;
    }

    @Override
    public Continueable getSubscription() {
        return this.subscription;
    }

    @ConstructorProperties(value={"errorHandler", "lastActive", "queueFactory", "simpleReact", "subscription"})
    public SimpleReactStreamImpl(Optional<Consumer<Throwable>> errorHandler, EagerStreamWrapper lastActive, QueueFactory<U> queueFactory, SimpleReact simpleReact, Continueable subscription) {
        this.errorHandler = errorHandler;
        this.lastActive = lastActive;
        this.queueFactory = queueFactory;
        this.simpleReact = simpleReact;
        this.subscription = subscription;
    }
}

