/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.invokedynamic;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;

public class ReflectionCache {
    private static final Map<Class, List<Field>> fields = new ConcurrentHashMap<Class, List<Field>>();
    private static final Map<Class, Optional<Method>> unapplyMethods = new ConcurrentHashMap<Class, Optional<Method>>();

    public static List<Field> getFields(Class class1) {
        return ReflectionCache.getFieldData(class1).stream().collect(Collectors.toList());
    }

    public static Map<String, Field> getFieldMap(Class class1) {
        return ReflectionCache.getFieldData(class1).stream().collect(Collectors.toMap(f -> f.getName(), f -> f));
    }

    private static List<Field> getFieldData(Class class1) {
        return fields.computeIfAbsent(class1, cl -> (List)Seq.iterate((Object)class1, c -> c.getSuperclass()).limitWhile(c -> c != Object.class).reverse().flatMap(c -> Stream.of(c.getDeclaredFields())).filter(f -> !Modifier.isStatic(f.getModifiers())).map(f -> {
            f.setAccessible(true);
            return f;
        }).collect(Collectors.toList()));
    }

    public static Optional<Method> getUnapplyMethod(Class c) {
        return unapplyMethods.computeIfAbsent(c, cl -> {
            try {
                return Optional.of(cl.getMethod("unapply", new Class[0]));
            }
            catch (NoSuchMethodException e) {
                return Optional.empty();
            }
        });
    }
}

