/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.data.collections.extensions.standard;

import com.aol.cyclops.data.collections.extensions.standard.SortedSetX;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SortedSetXImpl<T>
implements SortedSetX<T> {
    private final SortedSet<T> set;
    private final Collector<T, ?, SortedSet<T>> collector;

    public SortedSetXImpl(SortedSet<T> set) {
        this.set = set;
        this.collector = Collectors.toCollection(() -> new TreeSet());
    }

    public SortedSetXImpl() {
        this.collector = SortedSetX.defaultCollector();
        this.set = (SortedSet)this.collector.supplier().get();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.set.forEach(action);
    }

    @Override
    public Iterator<T> iterator() {
        return this.set.iterator();
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean contains(Object e) {
        return this.set.contains(e);
    }

    @Override
    public boolean equals(Object o) {
        return this.set.equals(o);
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public int hashCode() {
        return this.set.hashCode();
    }

    @Override
    public Object[] toArray() {
        return this.set.toArray();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.set.removeAll(c);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.set.toArray(a);
    }

    @Override
    public boolean add(T e) {
        return this.set.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.set.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.set.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.set.addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.set.retainAll(c);
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    public String toString() {
        return this.set.toString();
    }

    @Override
    public <R, A> R collect(Collector<? super T, A, R> collector) {
        return this.stream().collect(collector);
    }

    @Override
    public long count() {
        return this.size();
    }

    @Override
    public Comparator<? super T> comparator() {
        return this.set.comparator();
    }

    @Override
    public SortedSetX<T> subSet(T fromElement, T toElement) {
        return this.from(this.set.subSet(fromElement, toElement));
    }

    @Override
    public SortedSetX<T> headSet(T toElement) {
        return this.from(this.set.headSet(toElement));
    }

    @Override
    public SortedSet<T> tailSet(T fromElement) {
        return this.from(this.set.tailSet(fromElement));
    }

    @Override
    public T first() {
        return this.set.first();
    }

    @Override
    public T last() {
        return this.set.last();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.set.spliterator();
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        return this.set.removeIf(filter);
    }

    @Override
    public Stream<T> parallelStream() {
        return this.set.parallelStream();
    }

    @ConstructorProperties(value={"set", "collector"})
    public SortedSetXImpl(SortedSet<T> set, Collector<T, ?, SortedSet<T>> collector) {
        this.set = set;
        this.collector = collector;
    }

    @Override
    public Collector<T, ?, SortedSet<T>> getCollector() {
        return this.collector;
    }
}

