/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.data.collections.extensions.standard;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.control.Matchable;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.Trampoline;
import com.aol.cyclops.data.collections.extensions.standard.ListXImpl;
import com.aol.cyclops.data.collections.extensions.standard.MutableCollectionX;
import com.aol.cyclops.data.collections.extensions.standard.MutableSequenceX;
import com.aol.cyclops.types.IterableFunctor;
import com.aol.cyclops.types.applicative.zipping.ZippingApplicativable;
import com.aol.cyclops.util.stream.StreamUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple2;
import org.jooq.lambda.tuple.Tuple3;
import org.jooq.lambda.tuple.Tuple4;
import org.reactivestreams.Publisher;

public interface ListX<T>
extends List<T>,
MutableCollectionX<T>,
MutableSequenceX<T>,
Comparable<T>,
IterableFunctor<T>,
ZippingApplicativable<T> {
    public static ListX<Integer> range(int start, int end) {
        return ReactiveSeq.range(start, end).toListX();
    }

    public static ListX<Long> rangeLong(long start, long end) {
        return ReactiveSeq.rangeLong(start, end).toListX();
    }

    public static <U, T> ListX<T> unfold(U seed, Function<? super U, Optional<Tuple2<T, U>>> unfolder) {
        return ReactiveSeq.unfold(seed, unfolder).toListX();
    }

    public static <T> ListX<T> generate(long limit, Supplier<T> s) {
        return ReactiveSeq.generate(s).limit(limit).toListX();
    }

    public static <T> ListX<T> iterate(long limit, T seed, UnaryOperator<T> f) {
        return ReactiveSeq.iterate(seed, f).limit(limit).toListX();
    }

    @Override
    default public ListX<T> toListX() {
        return this;
    }

    public static <T> Collector<T, ?, ListX<T>> listXCollector() {
        return Collectors.toCollection(() -> ListX.of(new Object[0]));
    }

    public static <T> Collector<T, ?, List<T>> defaultCollector() {
        return Collectors.toCollection(() -> new ArrayList());
    }

    public static <T> Collector<T, ?, List<T>> immutableCollector() {
        return Collectors.collectingAndThen(ListX.defaultCollector(), d -> Collections.unmodifiableList(d));
    }

    public static <T> ListX<T> empty() {
        return ListX.fromIterable((List)ListX.defaultCollector().supplier().get());
    }

    @SafeVarargs
    public static <T> ListX<T> of(T ... values) {
        List res = (List)ListX.defaultCollector().supplier().get();
        for (T v : values) {
            res.add(v);
        }
        return ListX.fromIterable(res);
    }

    public static <T> ListX<T> singleton(T value) {
        return ListX.of(new Object[]{value});
    }

    public static <T> ListX<T> fromPublisher(Publisher<? extends T> publisher) {
        return ReactiveSeq.fromPublisher(publisher).toListX();
    }

    public static <T> ListX<T> fromIterable(Iterable<T> it) {
        return ListX.fromIterable(ListX.defaultCollector(), it);
    }

    public static <T> ListX<T> fromIterable(Collector<T, ?, List<T>> collector, Iterable<T> it) {
        if (it instanceof ListX) {
            return (ListX)it;
        }
        if (it instanceof List) {
            return new ListXImpl<T>((List)it, collector);
        }
        return new ListXImpl<T>(StreamUtils.stream(it).collect(collector), collector);
    }

    @Override
    default public <R> ListX<R> unit(Collection<R> col) {
        return ListX.fromIterable(col);
    }

    @Override
    default public <R> ListX<R> unit(R value) {
        return ListX.singleton(value);
    }

    @Override
    default public <R> ListX<R> unitIterator(Iterator<R> it) {
        return ListX.fromIterable(() -> it);
    }

    @Override
    default public <R> ListX<R> patternMatch(Function<Matchable.CheckValue1<T, R>, Matchable.CheckValue1<T, R>> case1, Supplier<? extends R> otherwise) {
        return (ListX)MutableCollectionX.super.patternMatch((Function)case1, (Supplier)otherwise);
    }

    @Override
    default public ReactiveSeq<T> stream() {
        return ReactiveSeq.fromIterable(this);
    }

    public <T> Collector<T, ?, List<T>> getCollector();

    @Override
    default public <T1> ListX<T1> from(Collection<T1> c) {
        return ListX.fromIterable(this.getCollector(), c);
    }

    @Override
    default public <X> ListX<X> fromStream(Stream<X> stream) {
        return new ListXImpl<T>(stream.collect(this.getCollector()), this.getCollector());
    }

    @Override
    default public ListX<T> reverse() {
        return (ListX)MutableCollectionX.super.reverse();
    }

    @Override
    default public ListX<T> combine(BiPredicate<? super T, ? super T> predicate, BinaryOperator<T> op) {
        return (ListX)MutableCollectionX.super.combine((BiPredicate)predicate, (BinaryOperator)op);
    }

    @Override
    default public ListX<T> filter(Predicate<? super T> pred) {
        return (ListX)MutableCollectionX.super.filter((Predicate)pred);
    }

    @Override
    default public <R> ListX<R> map(Function<? super T, ? extends R> mapper) {
        return (ListX)MutableCollectionX.super.map((Function)mapper);
    }

    @Override
    default public <R> ListX<R> flatMap(Function<? super T, ? extends Iterable<? extends R>> mapper) {
        return (ListX)MutableCollectionX.super.flatMap(mapper);
    }

    @Override
    default public ListX<T> limit(long num) {
        return (ListX)MutableCollectionX.super.limit(num);
    }

    @Override
    default public ListX<T> skip(long num) {
        return (ListX)MutableCollectionX.super.skip(num);
    }

    @Override
    default public ListX<T> takeRight(int num) {
        return (ListX)MutableCollectionX.super.takeRight(num);
    }

    @Override
    default public ListX<T> dropRight(int num) {
        return (ListX)MutableCollectionX.super.dropRight(num);
    }

    @Override
    default public ListX<T> takeWhile(Predicate<? super T> p) {
        return (ListX)MutableCollectionX.super.takeWhile((Predicate)p);
    }

    @Override
    default public ListX<T> dropWhile(Predicate<? super T> p) {
        return (ListX)MutableCollectionX.super.dropWhile((Predicate)p);
    }

    @Override
    default public ListX<T> takeUntil(Predicate<? super T> p) {
        return (ListX)MutableCollectionX.super.takeUntil((Predicate)p);
    }

    @Override
    default public ListX<T> dropUntil(Predicate<? super T> p) {
        return (ListX)MutableCollectionX.super.dropUntil((Predicate)p);
    }

    @Override
    default public <R> ListX<R> trampoline(Function<? super T, ? extends Trampoline<? extends R>> mapper) {
        return (ListX)MutableCollectionX.super.trampoline((Function)mapper);
    }

    @Override
    default public ListX<T> slice(long from, long to) {
        return (ListX)MutableCollectionX.super.slice(from, to);
    }

    @Override
    default public <U extends Comparable<? super U>> ListX<T> sorted(Function<? super T, ? extends U> function) {
        return (ListX)MutableCollectionX.super.sorted((Function)function);
    }

    @Override
    default public ListX<ListX<T>> grouped(int groupSize) {
        return (ListX)MutableCollectionX.super.grouped(groupSize);
    }

    @Override
    default public <K, A, D> ListX<Tuple2<K, D>> grouped(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return (ListX)MutableCollectionX.super.grouped((Function)classifier, (Collector)downstream);
    }

    @Override
    default public <K> ListX<Tuple2<K, Seq<T>>> grouped(Function<? super T, ? extends K> classifier) {
        return (ListX)MutableCollectionX.super.grouped((Function)classifier);
    }

    @Override
    default public <U> ListX<Tuple2<T, U>> zip(Iterable<? extends U> other) {
        return (ListX)MutableCollectionX.super.zip((Iterable)other);
    }

    @Override
    default public <U, R> ListX<R> zip(Iterable<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return (ListX)MutableCollectionX.super.zip((Iterable)other, (BiFunction)zipper);
    }

    @Override
    default public <U, R> ListX<R> zip(Seq<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return (ListX)MutableCollectionX.super.zip((Seq)other, (BiFunction)zipper);
    }

    @Override
    default public <U, R> ListX<R> zip(Stream<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return (ListX)MutableCollectionX.super.zip((Stream)other, (BiFunction)zipper);
    }

    @Override
    default public ListX<ListX<T>> sliding(int windowSize) {
        return (ListX)MutableCollectionX.super.sliding(windowSize);
    }

    @Override
    default public ListX<ListX<T>> sliding(int windowSize, int increment) {
        return (ListX)MutableCollectionX.super.sliding(windowSize, increment);
    }

    @Override
    default public ListX<T> scanLeft(Monoid<T> monoid) {
        return (ListX)MutableCollectionX.super.scanLeft((Monoid)monoid);
    }

    @Override
    default public <U> ListX<U> scanLeft(U seed, BiFunction<? super U, ? super T, ? extends U> function) {
        return (ListX)MutableCollectionX.super.scanLeft((Object)seed, (BiFunction)function);
    }

    @Override
    default public ListX<T> scanRight(Monoid<T> monoid) {
        return (ListX)MutableCollectionX.super.scanRight((Monoid)monoid);
    }

    @Override
    default public <U> ListX<U> scanRight(U identity, BiFunction<? super T, ? super U, ? extends U> combiner) {
        return (ListX)MutableCollectionX.super.scanRight((Object)identity, (BiFunction)combiner);
    }

    @Override
    default public ListX<T> with(int i, T element) {
        return this.from(this.stream().deleteBetween(i, i + 1).insertAt(i, element).collect(this.getCollector()));
    }

    @Override
    public ListX<T> subList(int var1, int var2);

    @Override
    default public ListX<T> plus(T e) {
        this.add(e);
        return this;
    }

    @Override
    default public ListX<T> plusAll(Collection<? extends T> list) {
        this.addAll(list);
        return this;
    }

    @Override
    default public ListX<T> minus(int pos) {
        this.remove(pos);
        return this;
    }

    @Override
    default public ListX<T> minus(Object e) {
        this.remove(e);
        return this;
    }

    @Override
    default public ListX<T> minusAll(Collection<?> list) {
        this.removeAll(list);
        return this;
    }

    @Override
    default public ListX<T> plus(int i, T e) {
        this.add(i, e);
        return this;
    }

    @Override
    default public ListX<T> plusAll(int i, Collection<? extends T> list) {
        this.addAll(i, list);
        return this;
    }

    @Override
    public int size();

    @Override
    default public ListX<T> plusInOrder(T e) {
        return (ListX)MutableSequenceX.super.plusInOrder(e);
    }

    @Override
    default public ListX<T> peek(Consumer<? super T> c) {
        return (ListX)MutableCollectionX.super.peek((Consumer)c);
    }

    @Override
    default public ListX<T> cycle(int times) {
        return (ListX)MutableCollectionX.super.cycle(times);
    }

    @Override
    default public ListX<T> cycle(Monoid<T> m, int times) {
        return (ListX)MutableCollectionX.super.cycle((Monoid)m, times);
    }

    @Override
    default public ListX<T> cycleWhile(Predicate<? super T> predicate) {
        return (ListX)MutableCollectionX.super.cycleWhile((Predicate)predicate);
    }

    @Override
    default public ListX<T> cycleUntil(Predicate<? super T> predicate) {
        return (ListX)MutableCollectionX.super.cycleUntil((Predicate)predicate);
    }

    @Override
    default public <U> ListX<Tuple2<T, U>> zip(Stream<? extends U> other) {
        return (ListX)MutableCollectionX.super.zip((Stream)other);
    }

    @Override
    default public <U> ListX<Tuple2<T, U>> zip(Seq<? extends U> other) {
        return (ListX)MutableCollectionX.super.zip((Seq)other);
    }

    @Override
    default public <S, U> ListX<Tuple3<T, S, U>> zip3(Stream<? extends S> second, Stream<? extends U> third) {
        return (ListX)MutableCollectionX.super.zip3((Stream)second, (Stream)third);
    }

    @Override
    default public <T2, T3, T4> ListX<Tuple4<T, T2, T3, T4>> zip4(Stream<? extends T2> second, Stream<? extends T3> third, Stream<? extends T4> fourth) {
        return (ListX)MutableCollectionX.super.zip4((Stream)second, (Stream)third, (Stream)fourth);
    }

    @Override
    default public ListX<Tuple2<T, Long>> zipWithIndex() {
        return (ListX)MutableCollectionX.super.zipWithIndex();
    }

    @Override
    default public ListX<T> sorted() {
        return (ListX)MutableCollectionX.super.sorted();
    }

    @Override
    default public ListX<T> sorted(Comparator<? super T> c) {
        return (ListX)MutableCollectionX.super.sorted((Comparator)c);
    }

    @Override
    default public ListX<T> skipWhile(Predicate<? super T> p) {
        return (ListX)MutableCollectionX.super.skipWhile((Predicate)p);
    }

    @Override
    default public ListX<T> skipUntil(Predicate<? super T> p) {
        return (ListX)MutableCollectionX.super.skipUntil((Predicate)p);
    }

    @Override
    default public ListX<T> shuffle() {
        return (ListX)MutableCollectionX.super.shuffle();
    }

    @Override
    default public ListX<T> skipLast(int num) {
        return (ListX)MutableCollectionX.super.skipLast(num);
    }

    @Override
    default public ListX<T> shuffle(Random random) {
        return (ListX)MutableCollectionX.super.shuffle(random);
    }

    @Override
    default public ListX<ReactiveSeq<T>> permutations() {
        return (ListX)MutableCollectionX.super.permutations();
    }

    @Override
    default public ListX<ReactiveSeq<T>> combinations(int size) {
        return (ListX)MutableCollectionX.super.combinations(size);
    }

    @Override
    default public ListX<ReactiveSeq<T>> combinations() {
        return (ListX)MutableCollectionX.super.combinations();
    }

    @Override
    default public <U> ListX<U> cast(Class<? extends U> type) {
        return (ListX)MutableCollectionX.super.cast((Class)type);
    }

    @Override
    default public ListX<T> distinct() {
        return (ListX)MutableCollectionX.super.distinct();
    }

    @Override
    default public ListX<T> limitWhile(Predicate<? super T> p) {
        return (ListX)MutableCollectionX.super.limitWhile((Predicate)p);
    }

    @Override
    default public ListX<T> limitUntil(Predicate<? super T> p) {
        return (ListX)MutableCollectionX.super.limitUntil((Predicate)p);
    }

    @Override
    default public ListX<T> intersperse(T value) {
        return (ListX)MutableCollectionX.super.intersperse((Object)value);
    }

    @Override
    default public ListX<T> limitLast(int num) {
        return (ListX)MutableCollectionX.super.limitLast(num);
    }

    @Override
    default public ListX<T> onEmpty(T value) {
        return (ListX)MutableCollectionX.super.onEmpty((Object)value);
    }

    @Override
    default public ListX<T> onEmptyGet(Supplier<? extends T> supplier) {
        return (ListX)MutableCollectionX.super.onEmptyGet((Supplier)supplier);
    }

    @Override
    default public <X extends Throwable> ListX<T> onEmptyThrow(Supplier<? extends X> supplier) {
        return (ListX)MutableCollectionX.super.onEmptyThrow((Supplier)supplier);
    }

    @Override
    default public <U> ListX<U> ofType(Class<? extends U> type) {
        return (ListX)MutableCollectionX.super.ofType((Class)type);
    }

    @Override
    default public ListX<T> filterNot(Predicate<? super T> fn) {
        return (ListX)MutableCollectionX.super.filterNot((Predicate)fn);
    }

    @Override
    default public ListX<T> notNull() {
        return (ListX)MutableCollectionX.super.notNull();
    }

    @Override
    default public ListX<T> removeAll(Stream<? extends T> stream) {
        return (ListX)MutableCollectionX.super.removeAll((Stream)stream);
    }

    @Override
    default public ListX<T> removeAll(Iterable<? extends T> it) {
        return (ListX)MutableCollectionX.super.removeAll((Iterable)it);
    }

    @Override
    default public ListX<T> removeAll(T ... values) {
        return (ListX)MutableCollectionX.super.removeAll((Object[])values);
    }

    @Override
    default public ListX<T> retainAll(Iterable<? extends T> it) {
        return (ListX)MutableCollectionX.super.retainAll((Iterable)it);
    }

    @Override
    default public ListX<T> retainAll(Stream<? extends T> seq) {
        return (ListX)MutableCollectionX.super.retainAll((Stream)seq);
    }

    @Override
    default public ListX<T> retainAll(T ... values) {
        return (ListX)MutableCollectionX.super.retainAll((Object[])values);
    }

    @Override
    default public <C extends Collection<? super T>> ListX<C> grouped(int size, Supplier<C> supplier) {
        return (ListX)MutableCollectionX.super.grouped(size, (Supplier)supplier);
    }

    @Override
    default public ListX<ListX<T>> groupedUntil(Predicate<? super T> predicate) {
        return (ListX)MutableCollectionX.super.groupedUntil((Predicate)predicate);
    }

    @Override
    default public ListX<ListX<T>> groupedWhile(Predicate<? super T> predicate) {
        return (ListX)MutableCollectionX.super.groupedWhile((Predicate)predicate);
    }

    @Override
    default public <C extends Collection<? super T>> ListX<C> groupedWhile(Predicate<? super T> predicate, Supplier<C> factory2) {
        return (ListX)MutableCollectionX.super.groupedWhile((Predicate)predicate, (Supplier)factory2);
    }

    @Override
    default public <C extends Collection<? super T>> ListX<C> groupedUntil(Predicate<? super T> predicate, Supplier<C> factory2) {
        return (ListX)MutableCollectionX.super.groupedUntil((Predicate)predicate, (Supplier)factory2);
    }

    @Override
    default public ListX<ListX<T>> groupedStatefullyWhile(BiPredicate<ListX<? super T>, ? super T> predicate) {
        return (ListX)MutableCollectionX.super.groupedStatefullyWhile((BiPredicate)predicate);
    }

    @Override
    default public ListX<T> removeAll(Seq<? extends T> stream) {
        return (ListX)MutableCollectionX.super.removeAll((Seq)stream);
    }

    @Override
    default public ListX<T> retainAll(Seq<? extends T> stream) {
        return (ListX)MutableCollectionX.super.retainAll((Seq)stream);
    }
}

