/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.data.async;

import com.aol.cyclops.data.async.Queue;
import com.aol.cyclops.data.async.QueueFactory;
import com.aol.cyclops.data.async.wait.NoWaitRetry;
import com.aol.cyclops.data.async.wait.WaitStrategy;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import org.agrona.concurrent.ManyToOneConcurrentArrayQueue;
import org.agrona.concurrent.OneToOneConcurrentArrayQueue;

public class QueueFactories {
    public static <T> QueueFactory<T> boundedQueue(int queueSize) {
        return () -> new Queue(new LinkedBlockingQueue(queueSize));
    }

    public static <T> QueueFactory<T> unboundedQueue() {
        return () -> new Queue();
    }

    public static <T> QueueFactory<T> unboundedNonBlockingQueue() {
        return () -> new Queue(new ConcurrentLinkedQueue(), new NoWaitRetry(), new NoWaitRetry());
    }

    public static <T> QueueFactory<T> unboundedNonBlockingQueue(WaitStrategy<T> strategy) {
        return () -> new Queue(new ConcurrentLinkedQueue(), strategy, strategy);
    }

    public static <T> QueueFactory<T> boundedNonBlockingQueue(int queueSize) {
        return () -> new Queue(new ManyToOneConcurrentArrayQueue(queueSize), new NoWaitRetry(), new NoWaitRetry());
    }

    public static <T> QueueFactory<T> boundedNonBlockingQueue(int queueSize, WaitStrategy<T> strategy) {
        return () -> new Queue(new ManyToOneConcurrentArrayQueue(queueSize), strategy, strategy);
    }

    public static <T> QueueFactory<T> singleWriterboundedNonBlockingQueue(int queueSize) {
        return () -> new Queue(new OneToOneConcurrentArrayQueue(queueSize), new NoWaitRetry(), new NoWaitRetry());
    }

    public static <T> QueueFactory<T> singleWriterboundedNonBlockingQueue(int queueSize, WaitStrategy<T> strategy) {
        return () -> new Queue(new OneToOneConcurrentArrayQueue(queueSize), strategy, strategy);
    }

    public static <T> QueueFactory<T> synchronousQueue() {
        return () -> new Queue(new SynchronousQueue());
    }
}

