/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.data;

import com.aol.cyclops.control.Matchable;
import java.beans.ConstructorProperties;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class Mutable<T>
implements Supplier<T>,
Consumer<T>,
Matchable.ValueAndOptionalMatcher<T> {
    private T var;

    public static <T> Mutable<T> of(T var) {
        return new Mutable<T>(var);
    }

    public static <T> Mutable<T> fromExternal(final Supplier<T> s, final Consumer<T> c) {
        return new Mutable<T>(){

            @Override
            public T get() {
                return s.get();
            }

            @Override
            public Mutable<T> set(T value) {
                c.accept(value);
                return this;
            }
        };
    }

    public <R> Mutable<R> mapOutput(final Function<T, R> fn) {
        final Mutable host = this;
        return new Mutable<R>(){

            @Override
            public R get() {
                return fn.apply(host.get());
            }
        };
    }

    public <T1> Mutable<T1> mapInput(final Function<T1, T> fn) {
        final Mutable host = this;
        return new Mutable<T1>(){

            @Override
            public Mutable<T1> set(T1 value) {
                host.set(fn.apply(value));
                return this;
            }
        };
    }

    @Override
    public T get() {
        return this.var;
    }

    public Mutable<T> set(T var) {
        this.var = var;
        return this;
    }

    public Mutable<T> mutate(Function<T, T> varFn) {
        return this.set(varFn.apply(this.get()));
    }

    @Override
    public void accept(T t) {
        this.set(t);
    }

    @Override
    public Mutable<T> toMutable() {
        return this;
    }

    @ConstructorProperties(value={"var"})
    public Mutable(T var) {
        this.var = var;
    }

    public Mutable() {
    }

    public String toString() {
        return "Mutable(var=" + this.var + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Mutable)) {
            return false;
        }
        Mutable other = (Mutable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$var = this.var;
        T other$var = other.var;
        return !(this$var == null ? other$var != null : !this$var.equals(other$var));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Mutable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $var = this.var;
        result = result * 59 + ($var == null ? 0 : $var.hashCode());
        return result;
    }
}

