/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.control.monads.transformers.seq;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.control.AnyM;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.monads.transformers.StreamT;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.types.IterableFoldable;
import com.aol.cyclops.types.Traversable;
import com.aol.cyclops.types.anyM.AnyMSeq;
import com.aol.cyclops.types.stream.CyclopsCollectable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple2;
import org.jooq.lambda.tuple.Tuple3;
import org.jooq.lambda.tuple.Tuple4;

public class StreamTSeq<T>
implements StreamT<T> {
    private final AnyMSeq<ReactiveSeq<T>> run;

    private StreamTSeq(AnyMSeq<? extends Stream<T>> run) {
        this.run = run.map((T s) -> ReactiveSeq.fromStream(s));
    }

    @Override
    public boolean isSeqPresent() {
        return !this.run.isEmpty();
    }

    @Override
    public AnyMSeq<ReactiveSeq<T>> unwrap() {
        return this.run;
    }

    @Override
    public StreamTSeq<T> peek(Consumer<? super T> peek) {
        return this.map((T a) -> {
            peek.accept(a);
            return a;
        });
    }

    @Override
    public StreamTSeq<T> filter(Predicate<? super T> test) {
        return StreamTSeq.of(this.run.map((T stream) -> stream.filter(test)));
    }

    @Override
    public <B> StreamTSeq<B> map(Function<? super T, ? extends B> f) {
        return new StreamTSeq<T>(this.run.map((T o) -> o.map(f)));
    }

    public <B> StreamTSeq<B> flatMapT(Function<? super T, StreamTSeq<? extends B>> f) {
        return StreamTSeq.of(this.run.map((T stream) -> stream.flatMap((T a) -> ((StreamTSeq)f.apply(a)).run.stream()).flatMap((T a) -> a)));
    }

    @Override
    public <B> StreamTSeq<B> flatMap(Function<? super T, ? extends Stream<? extends B>> f) {
        return new StreamTSeq<T>(this.run.map((T o) -> o.flatMap(f)));
    }

    public static <U, R> Function<StreamTSeq<U>, StreamTSeq<R>> lift(Function<? super U, ? extends R> fn) {
        return optTu -> optTu.map((T input) -> fn.apply((Object)input));
    }

    public static <A> StreamTSeq<A> fromAnyM(AnyMSeq<A> anyM) {
        return StreamTSeq.of(anyM.map(Stream::of));
    }

    public static <A> StreamTSeq<A> of(AnyMSeq<? extends Stream<A>> monads) {
        return new StreamTSeq(monads);
    }

    public static <A> StreamTSeq<A> of(Stream<A> monads) {
        return StreamT.fromIterable(ReactiveSeq.of(new Stream[]{monads}));
    }

    public String toString() {
        return String.format("StreamTSeq[%s]", this.run);
    }

    @Override
    public <T> StreamTSeq<T> unit(T unit) {
        return StreamTSeq.of(this.run.unit(Stream.of(unit)));
    }

    @Override
    public ReactiveSeq<T> stream() {
        return this.run.stream().flatMap((T e) -> e);
    }

    @Override
    public Iterator<T> iterator() {
        return this.stream().iterator();
    }

    @Override
    public <R> StreamTSeq<R> unitIterator(Iterator<R> it) {
        return StreamTSeq.of(this.run.unitIterator(it).map((T i) -> Stream.of(i)));
    }

    @Override
    public <R> StreamT<R> empty() {
        return StreamTSeq.of(this.run.empty());
    }

    @Override
    public AnyM<? extends IterableFoldable<T>> nestedFoldables() {
        return this.run;
    }

    @Override
    public AnyM<? extends CyclopsCollectable<T>> nestedCollectables() {
        return this.run;
    }

    @Override
    public <T> StreamTSeq<T> unitAnyM(AnyM<Traversable<T>> traversable) {
        return StreamTSeq.of((AnyMSeq)traversable.map((T t) -> ReactiveSeq.fromIterable(t)));
    }

    public AnyMSeq<? extends Traversable<T>> transformerStream() {
        return this.run;
    }

    public static <T> StreamTSeq<T> emptyStream() {
        return StreamT.fromIterable(ReactiveSeq.empty());
    }

    @Override
    public StreamTSeq<T> combine(BiPredicate<? super T, ? super T> predicate, BinaryOperator<T> op) {
        return (StreamTSeq)StreamT.super.combine((BiPredicate)predicate, (BinaryOperator)op);
    }

    @Override
    public StreamTSeq<T> cycle(int times) {
        return (StreamTSeq)StreamT.super.cycle(times);
    }

    @Override
    public StreamTSeq<T> cycle(Monoid<T> m, int times) {
        return (StreamTSeq)StreamT.super.cycle((Monoid)m, times);
    }

    @Override
    public StreamTSeq<T> cycleWhile(Predicate<? super T> predicate) {
        return (StreamTSeq)StreamT.super.cycleWhile((Predicate)predicate);
    }

    @Override
    public StreamTSeq<T> cycleUntil(Predicate<? super T> predicate) {
        return (StreamTSeq)StreamT.super.cycleUntil((Predicate)predicate);
    }

    @Override
    public <U, R> StreamTSeq<R> zip(Iterable<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return (StreamTSeq)StreamT.super.zip((Iterable)other, (BiFunction)zipper);
    }

    @Override
    public <U> StreamTSeq<Tuple2<T, U>> zip(Stream<? extends U> other) {
        return (StreamTSeq)StreamT.super.zip((Stream)other);
    }

    @Override
    public <S, U> StreamTSeq<Tuple3<T, S, U>> zip3(Stream<? extends S> second, Stream<? extends U> third) {
        return (StreamTSeq)StreamT.super.zip3((Stream)second, (Stream)third);
    }

    @Override
    public <T2, T3, T4> StreamTSeq<Tuple4<T, T2, T3, T4>> zip4(Stream<? extends T2> second, Stream<? extends T3> third, Stream<? extends T4> fourth) {
        return (StreamTSeq)StreamT.super.zip4((Stream)second, (Stream)third, (Stream)fourth);
    }

    @Override
    public StreamTSeq<Tuple2<T, Long>> zipWithIndex() {
        return (StreamTSeq)StreamT.super.zipWithIndex();
    }

    @Override
    public StreamTSeq<ListX<T>> sliding(int windowSize) {
        return (StreamTSeq)StreamT.super.sliding(windowSize);
    }

    @Override
    public StreamTSeq<ListX<T>> sliding(int windowSize, int increment) {
        return (StreamTSeq)StreamT.super.sliding(windowSize, increment);
    }

    @Override
    public <C extends Collection<? super T>> StreamTSeq<C> grouped(int size, Supplier<C> supplier) {
        return (StreamTSeq)StreamT.super.grouped(size, (Supplier)supplier);
    }

    @Override
    public StreamTSeq<ListX<T>> groupedUntil(Predicate<? super T> predicate) {
        return (StreamTSeq)StreamT.super.groupedUntil((Predicate)predicate);
    }

    @Override
    public StreamTSeq<ListX<T>> groupedStatefullyWhile(BiPredicate<ListX<? super T>, ? super T> predicate) {
        return (StreamTSeq)StreamT.super.groupedStatefullyWhile((BiPredicate)predicate);
    }

    @Override
    public StreamTSeq<ListX<T>> groupedWhile(Predicate<? super T> predicate) {
        return (StreamTSeq)StreamT.super.groupedWhile((Predicate)predicate);
    }

    @Override
    public <C extends Collection<? super T>> StreamTSeq<C> groupedWhile(Predicate<? super T> predicate, Supplier<C> factory2) {
        return (StreamTSeq)StreamT.super.groupedWhile((Predicate)predicate, (Supplier)factory2);
    }

    @Override
    public <C extends Collection<? super T>> StreamTSeq<C> groupedUntil(Predicate<? super T> predicate, Supplier<C> factory2) {
        return (StreamTSeq)StreamT.super.groupedUntil((Predicate)predicate, (Supplier)factory2);
    }

    @Override
    public StreamTSeq<ListX<T>> grouped(int groupSize) {
        return (StreamTSeq)StreamT.super.grouped(groupSize);
    }

    @Override
    public <K, A, D> StreamTSeq<Tuple2<K, D>> grouped(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return (StreamTSeq)StreamT.super.grouped((Function)classifier, (Collector)downstream);
    }

    @Override
    public <K> StreamTSeq<Tuple2<K, Seq<T>>> grouped(Function<? super T, ? extends K> classifier) {
        return (StreamTSeq)StreamT.super.grouped((Function)classifier);
    }

    @Override
    public StreamTSeq<T> distinct() {
        return (StreamTSeq)StreamT.super.distinct();
    }

    @Override
    public StreamTSeq<T> scanLeft(Monoid<T> monoid) {
        return (StreamTSeq)StreamT.super.scanLeft((Monoid)monoid);
    }

    @Override
    public <U> StreamTSeq<U> scanLeft(U seed, BiFunction<? super U, ? super T, ? extends U> function) {
        return (StreamTSeq)StreamT.super.scanLeft((Object)seed, (BiFunction)function);
    }

    @Override
    public StreamTSeq<T> scanRight(Monoid<T> monoid) {
        return (StreamTSeq)StreamT.super.scanRight((Monoid)monoid);
    }

    @Override
    public <U> StreamTSeq<U> scanRight(U identity, BiFunction<? super T, ? super U, ? extends U> combiner) {
        return (StreamTSeq)StreamT.super.scanRight((Object)identity, (BiFunction)combiner);
    }

    @Override
    public StreamTSeq<T> sorted() {
        return (StreamTSeq)StreamT.super.sorted();
    }

    @Override
    public StreamTSeq<T> sorted(Comparator<? super T> c) {
        return (StreamTSeq)StreamT.super.sorted((Comparator)c);
    }

    @Override
    public StreamTSeq<T> takeWhile(Predicate<? super T> p) {
        return (StreamTSeq)StreamT.super.takeWhile((Predicate)p);
    }

    @Override
    public StreamTSeq<T> dropWhile(Predicate<? super T> p) {
        return (StreamTSeq)StreamT.super.dropWhile((Predicate)p);
    }

    @Override
    public StreamTSeq<T> takeUntil(Predicate<? super T> p) {
        return (StreamTSeq)StreamT.super.takeUntil((Predicate)p);
    }

    @Override
    public StreamTSeq<T> dropUntil(Predicate<? super T> p) {
        return (StreamTSeq)StreamT.super.dropUntil((Predicate)p);
    }

    @Override
    public StreamTSeq<T> dropRight(int num) {
        return (StreamTSeq)StreamT.super.dropRight(num);
    }

    @Override
    public StreamTSeq<T> takeRight(int num) {
        return (StreamTSeq)StreamT.super.takeRight(num);
    }

    @Override
    public StreamTSeq<T> skip(long num) {
        return (StreamTSeq)StreamT.super.skip(num);
    }

    @Override
    public StreamTSeq<T> skipWhile(Predicate<? super T> p) {
        return (StreamTSeq)StreamT.super.skipWhile((Predicate)p);
    }

    @Override
    public StreamTSeq<T> skipUntil(Predicate<? super T> p) {
        return (StreamTSeq)StreamT.super.skipUntil((Predicate)p);
    }

    @Override
    public StreamTSeq<T> limit(long num) {
        return (StreamTSeq)StreamT.super.limit(num);
    }

    @Override
    public StreamTSeq<T> limitWhile(Predicate<? super T> p) {
        return (StreamTSeq)StreamT.super.limitWhile((Predicate)p);
    }

    @Override
    public StreamTSeq<T> limitUntil(Predicate<? super T> p) {
        return (StreamTSeq)StreamT.super.limitUntil((Predicate)p);
    }

    @Override
    public StreamTSeq<T> intersperse(T value) {
        return (StreamTSeq)StreamT.super.intersperse((Object)value);
    }

    @Override
    public StreamTSeq<T> reverse() {
        return (StreamTSeq)StreamT.super.reverse();
    }

    @Override
    public StreamTSeq<T> shuffle() {
        return (StreamTSeq)StreamT.super.shuffle();
    }

    @Override
    public StreamTSeq<T> skipLast(int num) {
        return (StreamTSeq)StreamT.super.skipLast(num);
    }

    @Override
    public StreamTSeq<T> limitLast(int num) {
        return (StreamTSeq)StreamT.super.limitLast(num);
    }

    @Override
    public StreamTSeq<T> onEmpty(T value) {
        return (StreamTSeq)StreamT.super.onEmpty((Object)value);
    }

    @Override
    public StreamTSeq<T> onEmptyGet(Supplier<? extends T> supplier) {
        return (StreamTSeq)StreamT.super.onEmptyGet((Supplier)supplier);
    }

    @Override
    public <X extends Throwable> StreamTSeq<T> onEmptyThrow(Supplier<? extends X> supplier) {
        return (StreamTSeq)StreamT.super.onEmptyThrow((Supplier)supplier);
    }

    @Override
    public StreamTSeq<T> shuffle(Random random) {
        return (StreamTSeq)StreamT.super.shuffle(random);
    }

    @Override
    public StreamTSeq<T> slice(long from, long to) {
        return (StreamTSeq)StreamT.super.slice(from, to);
    }

    @Override
    public <U extends Comparable<? super U>> StreamTSeq<T> sorted(Function<? super T, ? extends U> function) {
        return (StreamTSeq)StreamT.super.sorted((Function)function);
    }

    public int hashCode() {
        return this.run.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof StreamTSeq) {
            return this.run.equals(((StreamTSeq)o).run);
        }
        return false;
    }
}

