/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.control;

import com.aol.cyclops.control.LazyReact;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.data.async.Adapter;
import com.aol.cyclops.data.async.Queue;
import com.aol.cyclops.data.async.QueueFactories;
import com.aol.cyclops.data.async.QueueFactory;
import com.aol.cyclops.types.futurestream.LazyFutureStream;
import com.aol.cyclops.util.stream.pushable.MultipleStreamSource;
import com.aol.cyclops.util.stream.pushable.PushableLazyFutureStream;
import com.aol.cyclops.util.stream.pushable.PushableReactiveSeq;
import com.aol.cyclops.util.stream.pushable.PushableStream;
import java.util.Objects;
import java.util.stream.Stream;

public class StreamSource {
    private final int backPressureAfter;
    private final boolean backPressureOn;

    public static <T> MultipleStreamSource<T> ofMultiple() {
        return new MultipleStreamSource<T>(StreamSource.ofUnbounded().createQueue());
    }

    public static <T> MultipleStreamSource<T> ofMultiple(int backPressureAfter) {
        return new MultipleStreamSource<T>(StreamSource.of(backPressureAfter).createQueue());
    }

    public static <T> MultipleStreamSource<T> ofMultiple(QueueFactory<?> q) {
        Objects.requireNonNull(q);
        return new MultipleStreamSource<T>(StreamSource.of(q).createQueue());
    }

    public static StreamSource of(final QueueFactory<?> q) {
        Objects.requireNonNull(q);
        return new StreamSource(){

            @Override
            <T> Queue<T> createQueue() {
                return q.build();
            }
        };
    }

    public static StreamSource ofUnbounded() {
        return new StreamSource();
    }

    public static StreamSource of(int backPressureAfter) {
        if (backPressureAfter < 1) {
            throw new IllegalArgumentException("Can't apply back pressure after less than 1 event");
        }
        return new StreamSource(backPressureAfter, true);
    }

    <T> Queue<T> createQueue() {
        Queue q = !this.backPressureOn ? QueueFactories.unboundedNonBlockingQueue().build() : QueueFactories.boundedQueue(this.backPressureAfter).build();
        return q;
    }

    private StreamSource() {
        this.backPressureAfter = Runtime.getRuntime().availableProcessors();
        this.backPressureOn = false;
    }

    public <T> PushableLazyFutureStream<T> futureStream(LazyReact s) {
        Queue<T> q = this.createQueue();
        return new PushableLazyFutureStream<T>(q, s.fromStream(q.stream()));
    }

    public static <T> LazyFutureStream<T> futureStream(Adapter<T> adapter, LazyReact react) {
        return react.fromStream(adapter.stream());
    }

    public <T> PushableStream<T> stream() {
        Queue<T> q = this.createQueue();
        return new PushableStream<T>(q, q.stream());
    }

    public <T> PushableReactiveSeq<T> reactiveSeq() {
        Queue<T> q = this.createQueue();
        return new PushableReactiveSeq<T>(q, q.stream());
    }

    public static <T> Stream<T> stream(Adapter<T> adapter) {
        return adapter.stream();
    }

    public static <T> ReactiveSeq<T> reactiveSeq(Adapter<T> adapter) {
        return adapter.stream();
    }

    private StreamSource(int backPressureAfter, boolean backPressureOn) {
        this.backPressureAfter = backPressureAfter;
        this.backPressureOn = backPressureOn;
    }
}

