/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.types.stream.lazy;

import com.aol.cyclops.control.Eval;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.data.collections.extensions.standard.MapX;
import com.aol.cyclops.types.stream.lazy.DoubleOperatorsMixin;
import com.aol.cyclops.types.stream.lazy.IntOperatorsMixin;
import com.aol.cyclops.types.stream.lazy.LazyCollectable;
import com.aol.cyclops.types.stream.lazy.LongOperatorsMixin;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Comparator;
import java.util.DoubleSummaryStatistics;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;

public class LazyOperations<T>
implements DoubleOperatorsMixin<T>,
IntOperatorsMixin<T>,
LongOperatorsMixin<T>,
LazyCollectable<T> {
    private final ReactiveSeq<T> stream;

    @Override
    public Eval<List<T>> toList() {
        return Eval.later(() -> this.stream.toList());
    }

    @Override
    public Eval<T> lastValue() {
        return Eval.later(() -> {
            List<T> l = this.stream.toList();
            return l.get(l.size() - 1);
        });
    }

    @Override
    public Eval<T> single() {
        return Eval.later(() -> {
            List<T> l = this.stream.toList();
            if (l.size() == 1) {
                return l.get(l.size() - 1);
            }
            throw new UnsupportedOperationException("single only works for Streams with a single value");
        });
    }

    @Override
    public Eval<Set<T>> toSet() {
        return Eval.later(() -> this.stream.toSet());
    }

    @Override
    public <U extends Comparable<? super U>> Eval<Optional<T>> minBy(Function<? super T, ? extends U> function) {
        return Eval.later(() -> this.stream.minBy(function));
    }

    @Override
    public <U extends Comparable<? super U>> Eval<Optional<T>> maxBy(Function<? super T, ? extends U> function) {
        return Eval.later(() -> this.stream.maxBy(function));
    }

    @Override
    public <R, A> Eval<R> collect(Collector<? super T, A, R> collector) {
        return Eval.later(() -> this.stream.collect(collector));
    }

    @Override
    public <C extends Collection<T>> Eval<C> toCollection(Supplier<C> collectionFactory) {
        return Eval.later(() -> this.stream.toCollection(collectionFactory));
    }

    @Override
    public <A> Eval<A[]> toArray(IntFunction<A[]> generator) {
        return Eval.later(() -> this.stream.toArray(generator));
    }

    @Override
    public Eval<Object[]> toArray() {
        return Eval.later(() -> this.stream.toArray());
    }

    @Override
    public <K> Eval<Map<K, List<T>>> groupBy(Function<? super T, ? extends K> classifier) {
        return Eval.later(() -> this.stream.groupBy(classifier));
    }

    @Override
    public <K, A, D> Eval<Map<K, D>> groupBy(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return Eval.later(() -> this.stream.groupBy(classifier, downstream));
    }

    @Override
    public <K, D, A, M extends Map<K, D>> Eval<M> groupBy(Function<? super T, ? extends K> classifier, Supplier<M> mapFactory, Collector<? super T, A, D> downstream) {
        return Eval.later(() -> this.stream.groupBy(classifier, mapFactory, downstream));
    }

    @Override
    public <U> Eval<U> foldLeft(U seed, BiFunction<U, ? super T, U> function) {
        return Eval.later(() -> this.stream.foldLeft(seed, function));
    }

    @Override
    public <U> Eval<U> foldRight(U seed, BiFunction<? super T, U, U> function) {
        return Eval.later(() -> this.stream.foldRight(seed, function));
    }

    @Override
    public Eval<Optional<T>> min(Comparator<? super T> comparator) {
        return Eval.later(() -> this.stream.min(comparator));
    }

    @Override
    public Eval<Optional<T>> max(Comparator<? super T> comparator) {
        return Eval.later(() -> this.stream.max(comparator));
    }

    @Override
    public <R> Eval<R> collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        return Eval.later(() -> this.stream.collect(supplier, accumulator, combiner));
    }

    @Override
    public <U> Eval<U> reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        return Eval.later(() -> this.stream.reduce(identity, accumulator, combiner));
    }

    @Override
    public Eval<Optional<T>> reduce(BinaryOperator<T> accumulator) {
        return Eval.later(() -> this.stream.reduce(accumulator));
    }

    @Override
    public Eval<T> reduce(T identity, BinaryOperator<T> accumulator) {
        return Eval.later(() -> this.stream.reduce(identity, accumulator));
    }

    @Override
    public Eval<Long> count() {
        return Eval.later(() -> this.stream.count());
    }

    @Override
    public Eval<String> join(CharSequence sep) {
        return Eval.later(() -> this.stream.join(sep));
    }

    @Override
    public Eval<String> join() {
        return Eval.later(() -> this.stream.join());
    }

    @Override
    public Eval<String> join(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return Eval.later(() -> this.stream.join(delimiter, prefix, suffix));
    }

    @Override
    public Eval<Optional<T>> findAny() {
        return Eval.later(() -> this.stream.findAny());
    }

    @Override
    public Eval<Optional<T>> findFirst() {
        return Eval.later(() -> this.stream.findFirst());
    }

    @Override
    public Eval<T> firstValue() {
        return Eval.later(() -> this.stream.firstValue());
    }

    @Override
    public Eval<Boolean> allMatch(Predicate<? super T> predicate) {
        return Eval.later(() -> this.stream.allMatch(predicate));
    }

    @Override
    public Eval<Boolean> anyMatch(Predicate<? super T> predicate) {
        return Eval.later(() -> this.stream.anyMatch(predicate));
    }

    @Override
    public Eval<Boolean> noneMatch(Predicate<? super T> predicate) {
        return Eval.later(() -> this.stream.noneMatch(predicate));
    }

    public Eval<Void> forEach(Consumer<T> c) {
        return Eval.later(() -> {
            this.stream.forEach(c);
            return null;
        });
    }

    @Override
    public Eval<T> single(Predicate<T> predicate) {
        return Eval.later(() -> this.stream.filter((Predicate)predicate).single());
    }

    @Override
    public Eval<Optional<T>> singleOptional() {
        return Eval.later(() -> this.stream.singleOptional());
    }

    @Override
    public Eval<Long> countDistinct() {
        return Eval.later(() -> this.stream.countDistinct());
    }

    @Override
    public <U> Eval<Long> countDistinctBy(Function<? super T, ? extends U> function) {
        return Eval.later(() -> this.stream.countDistinctBy(function));
    }

    @Override
    public Eval<Optional<T>> mode() {
        return Eval.later(() -> this.stream.mode());
    }

    @Override
    public Eval<Optional<T>> sum() {
        return Eval.later(() -> this.stream.sum());
    }

    @Override
    public <U> Eval<Optional<U>> sum(Function<? super T, ? extends U> function) {
        return Eval.later(() -> this.stream.sum(function));
    }

    @Override
    public Eval<Optional<T>> avg() {
        return Eval.later(() -> this.stream.avg());
    }

    @Override
    public <U> Eval<Optional<U>> avg(Function<? super T, ? extends U> function) {
        return Eval.later(() -> this.stream.avg(function));
    }

    @Override
    public Eval<Optional<T>> min() {
        return Eval.later(() -> this.stream.min());
    }

    @Override
    public <U extends Comparable<? super U>> Eval<Optional<U>> min(Function<? super T, ? extends U> function) {
        return Eval.later(() -> this.stream.min(function));
    }

    @Override
    public <U> Eval<Optional<U>> min(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return Eval.later(() -> this.stream.min(function, comparator));
    }

    @Override
    public <U> Eval<Optional<T>> minBy(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return Eval.later(() -> this.stream.minBy(function, comparator));
    }

    @Override
    public Eval<Optional<T>> max() {
        return Eval.later(() -> this.stream.max());
    }

    @Override
    public <U extends Comparable<? super U>> Eval<Optional<U>> max(Function<? super T, ? extends U> function) {
        return Eval.later(() -> this.stream.max(function));
    }

    @Override
    public <U> Eval<Optional<U>> max(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return Eval.later(() -> this.stream.max(function, comparator));
    }

    @Override
    public <U> Eval<Optional<T>> maxBy(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return Eval.later(() -> this.stream.maxBy(function, comparator));
    }

    @Override
    public Eval<Optional<T>> median() {
        return Eval.later(() -> this.stream.median());
    }

    @Override
    public Eval<Optional<T>> median(Comparator<? super T> comparator) {
        return Eval.later(() -> this.stream.median(comparator));
    }

    @Override
    public <U extends Comparable<? super U>> Eval<Optional<T>> medianBy(Function<? super T, ? extends U> function) {
        return Eval.later(() -> this.stream.medianBy(function));
    }

    @Override
    public <U> Eval<Optional<T>> medianBy(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return Eval.later(() -> this.stream.medianBy(function, comparator));
    }

    @Override
    public Eval<Optional<T>> percentile(double percentile) {
        return Eval.later(() -> this.stream.percentile(percentile));
    }

    @Override
    public Eval<Optional<T>> percentile(double percentile, Comparator<? super T> comparator) {
        return Eval.later(() -> this.stream.percentile(percentile, comparator));
    }

    @Override
    public <U extends Comparable<? super U>> Eval<Optional<T>> percentileBy(double percentile, Function<? super T, ? extends U> function) {
        return Eval.later(() -> this.stream.percentileBy(percentile, function));
    }

    @Override
    public <U> Eval<Optional<T>> percentileBy(double percentile, Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return Eval.later(() -> this.stream.percentileBy(percentile, function, comparator));
    }

    @Override
    public <L extends List<T>> Eval<L> toList(Supplier<L> factory2) {
        return Eval.later(() -> this.stream.toList(factory2));
    }

    @Override
    public <S extends Set<T>> Eval<S> toSet(Supplier<S> factory2) {
        return Eval.later(() -> this.stream.toSet(factory2));
    }

    @Override
    public <K, V> Eval<MapX<K, V>> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return Eval.later(() -> this.stream.toMapX(keyMapper, valueMapper));
    }

    @Override
    public Eval<Double> sumDouble(ToDoubleFunction<? super T> fn) {
        return DoubleOperatorsMixin.super.sumDouble(fn);
    }

    @Override
    public Eval<Long> sumLong(ToLongFunction<? super T> fn) {
        return LongOperatorsMixin.super.sumLong(fn);
    }

    @Override
    public Eval<OptionalLong> maxLong(ToLongFunction<? super T> fn) {
        return LongOperatorsMixin.super.maxLong(fn);
    }

    @Override
    public Eval<OptionalLong> minLong(ToLongFunction<? super T> fn) {
        return LongOperatorsMixin.super.minLong(fn);
    }

    @Override
    public Eval<OptionalDouble> averageLong(ToLongFunction<? super T> fn) {
        return LongOperatorsMixin.super.averageLong(fn);
    }

    @Override
    public Eval<LongSummaryStatistics> summaryStatisticsLong(ToLongFunction<? super T> fn) {
        return LongOperatorsMixin.super.summaryStatisticsLong(fn);
    }

    @Override
    public Eval<Integer> sumInt(ToIntFunction<? super T> fn) {
        return IntOperatorsMixin.super.sumInt(fn);
    }

    @Override
    public Eval<OptionalInt> maxInt(ToIntFunction<? super T> fn) {
        return IntOperatorsMixin.super.maxInt(fn);
    }

    @Override
    public Eval<OptionalInt> minInt(ToIntFunction<? super T> fn) {
        return IntOperatorsMixin.super.minInt(fn);
    }

    @Override
    public Eval<OptionalDouble> averageInt(ToIntFunction<? super T> fn) {
        return IntOperatorsMixin.super.averageInt(fn);
    }

    @Override
    public Eval<IntSummaryStatistics> summaryStatisticsInt(ToIntFunction<? super T> fn) {
        return IntOperatorsMixin.super.summaryStatisticsInt(fn);
    }

    @Override
    public Eval<OptionalDouble> maxDouble(ToDoubleFunction<? super T> fn) {
        return DoubleOperatorsMixin.super.maxDouble(fn);
    }

    @Override
    public Eval<OptionalDouble> minDouble(ToDoubleFunction<? super T> fn) {
        return DoubleOperatorsMixin.super.minDouble(fn);
    }

    @Override
    public Eval<OptionalDouble> averageDouble(ToDoubleFunction<? super T> fn) {
        return DoubleOperatorsMixin.super.averageDouble(fn);
    }

    @Override
    public Eval<DoubleSummaryStatistics> summaryStatisticsDouble(ToDoubleFunction<? super T> fn) {
        return DoubleOperatorsMixin.super.summaryStatisticsDouble(fn);
    }

    @ConstructorProperties(value={"stream"})
    public LazyOperations(ReactiveSeq<T> stream) {
        this.stream = stream;
    }

    @Override
    public ReactiveSeq<T> getStream() {
        return this.stream;
    }
}

