/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.types.stream.future;

import com.aol.cyclops.types.stream.HasExec;
import com.aol.cyclops.types.stream.HasStream;
import com.aol.cyclops.types.stream.future.LongOperators;
import java.util.LongSummaryStatistics;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.function.ToLongFunction;
import java.util.stream.LongStream;

public interface LongOperatorsMixin<T>
extends LongOperators<T>,
HasStream<T>,
HasExec {
    @Override
    default public CompletableFuture<Long> sumLong(ToLongFunction<? super T> fn) {
        return CompletableFuture.supplyAsync(() -> this.getStream().flatMapToLong(t -> LongStream.of(fn.applyAsLong(t))).sum(), this.getExec());
    }

    @Override
    default public CompletableFuture<OptionalLong> maxLong(ToLongFunction<? super T> fn) {
        return CompletableFuture.supplyAsync(() -> this.getStream().flatMapToLong(t -> LongStream.of(fn.applyAsLong(t))).max(), this.getExec());
    }

    @Override
    default public CompletableFuture<OptionalLong> minLong(ToLongFunction<? super T> fn) {
        return CompletableFuture.supplyAsync(() -> this.getStream().flatMapToLong(t -> LongStream.of(fn.applyAsLong(t))).min(), this.getExec());
    }

    @Override
    default public CompletableFuture<OptionalDouble> averageLong(ToLongFunction<? super T> fn) {
        return CompletableFuture.supplyAsync(() -> this.getStream().flatMapToLong(t -> LongStream.of(fn.applyAsLong(t))).average(), this.getExec());
    }

    @Override
    default public CompletableFuture<LongSummaryStatistics> summaryStatisticsLong(ToLongFunction<? super T> fn) {
        return CompletableFuture.supplyAsync(() -> this.getStream().flatMapToLong(t -> LongStream.of(fn.applyAsLong(t))).summaryStatistics(), this.getExec());
    }
}

