/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.types.futurestream;

import com.aol.cyclops.control.LazyReact;
import com.aol.cyclops.data.async.Queue;
import com.aol.cyclops.internal.react.async.future.CompletedException;
import com.aol.cyclops.types.futurestream.Continuation;
import com.aol.cyclops.types.futurestream.LazyFutureStream;
import com.aol.cyclops.types.futurestream.ToQueue;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;

public interface LazyToQueue<U>
extends ToQueue<U> {
    public <R> LazyFutureStream<R> then(Function<? super U, ? extends R> var1, Executor var2);

    public <R> LazyFutureStream<R> thenSync(Function<? super U, ? extends R> var1);

    public LazyReact getPopulator();

    public LazyFutureStream<U> peekSync(Consumer<? super U> var1);

    @Override
    default public Queue<U> toQueue() {
        Queue queue = this.getQueueFactory().build();
        Continuation continuation = this.peekSync(queue::add).self(s -> {
            if (this.getPopulator().isPoolingActive()) {
                s.peekSync((T v) -> {
                    throw new CompletedException(v);
                });
            }
        }).runContinuation(() -> queue.close());
        queue.addContinuation(continuation);
        return queue;
    }

    @Override
    default public Queue<U> toQueue(Function<Queue, Queue> fn) {
        Queue queue = fn.apply(this.getQueueFactory().build());
        Continuation continuation = this.thenSync(queue::add).self(s -> {
            if (this.getPopulator().isPoolingActive()) {
                s.peekSync((T v) -> {
                    throw new CompletedException(v);
                });
            }
        }).runContinuation(() -> queue.close());
        queue.addContinuation(continuation);
        return queue;
    }

    @Override
    default public void addToQueue(Queue queue) {
        Continuation continuation = this.thenSync(queue::add).self(s -> {
            if (this.getPopulator().isPoolingActive()) {
                s.peekSync((T v) -> {
                    throw new CompletedException(v);
                });
            }
        }).runContinuation(() -> {
            throw new Queue.ClosedQueueException();
        });
        queue.addContinuation(continuation);
    }

    @Override
    default public <K> void toQueue(Map<K, Queue<U>> shards, Function<? super U, ? extends K> sharder) {
        LazyReact service = this.getPopulator();
        this.then(it -> ((Queue)shards.get(sharder.apply((Object)it))).offer(it), service.getExecutor()).runThread(() -> {
            shards.values().forEach(it -> it.close());
            this.returnPopulator(service);
        });
    }

    public void returnPopulator(LazyReact var1);

    default public U add(U value, Queue<U> queue) {
        if (!queue.add(value)) {
            throw new RuntimeException();
        }
        return value;
    }
}

