/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.types.futurestream;

import com.aol.cyclops.data.async.Queue;
import com.aol.cyclops.data.async.QueueFactory;
import com.aol.cyclops.types.futurestream.SimpleReactStream;
import com.aol.cyclops.types.futurestream.ToQueue;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;

public interface EagerToQueue<U>
extends ToQueue<U> {
    @Override
    public QueueFactory<U> getQueueFactory();

    public <R1, R2> SimpleReactStream<R2> allOf(Collector<? super U, ?, R1> var1, Function<? super R1, ? extends R2> var2);

    public <R> SimpleReactStream<R> thenSync(Function<? super U, ? extends R> var1);

    @Override
    default public Queue<U> toQueue() {
        Queue queue = this.getQueueFactory().build();
        this.thenSync(it -> queue.offer(it)).allOf(it -> queue.close());
        return queue;
    }

    @Override
    default public Queue<U> toQueue(Function<Queue, Queue> modifier) {
        Queue queue = modifier.apply(this.getQueueFactory().build());
        this.thenSync(it -> queue.offer(it)).allOf(it -> queue.close());
        return queue;
    }

    @Override
    default public void addToQueue(Queue queue) {
        this.thenSync(it -> queue.offer(it)).allOf(it -> queue.close());
    }

    @Override
    default public <K> void toQueue(Map<K, Queue<U>> shards, Function<? super U, ? extends K> sharder) {
        this.thenSync(it -> ((Queue)shards.get(sharder.apply((Object)it))).offer(it)).allOf(data -> {
            shards.values().forEach(it -> it.close());
            return true;
        });
    }
}

