/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.types.futurestream;

import com.aol.cyclops.control.SimpleReact;
import com.aol.cyclops.data.async.Queue;
import com.aol.cyclops.data.async.QueueFactory;
import com.aol.cyclops.internal.react.SimpleReactStreamImpl;
import com.aol.cyclops.internal.react.stream.CloseableIterator;
import com.aol.cyclops.internal.react.stream.ReactBuilder;
import com.aol.cyclops.internal.react.stream.StreamWrapper;
import com.aol.cyclops.react.RetryBuilder;
import com.aol.cyclops.react.SimpleReactFailedStageException;
import com.aol.cyclops.react.ThreadPools;
import com.aol.cyclops.react.async.subscription.Continueable;
import com.aol.cyclops.types.futurestream.BlockingStream;
import com.aol.cyclops.types.futurestream.LazyFutureStream;
import com.aol.cyclops.types.futurestream.SimpleReactStream;
import com.nurkiewicz.asyncretry.AsyncRetryExecutor;
import com.nurkiewicz.asyncretry.RetryExecutor;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jooq.lambda.Seq;

public interface BaseSimpleReactStream<U>
extends BlockingStream<U> {
    public ReactBuilder getSimpleReact();

    default public <U> BaseSimpleReactStream<U> ofType(Class<? extends U> type) {
        return this.filterSync(type::isInstance).thenSync(t -> t);
    }

    default public <U> BaseSimpleReactStream<U> cast(Class<? extends U> type) {
        return this.thenSync(type::cast);
    }

    default public BaseSimpleReactStream<U> intersperse(U value) {
        return this.flatMap(t -> Stream.of(value, t)).skip(1L);
    }

    public BaseSimpleReactStream<U> skip(long var1);

    default public Iterator<U> iterator() {
        Queue<U> q = this.toQueue();
        if (this.getSubscription().closed()) {
            return new CloseableIterator<Object>(Arrays.asList(new Object[0]).iterator(), this.getSubscription(), null);
        }
        return new CloseableIterator(q.stream(this.getSubscription()).iterator(), this.getSubscription(), q);
    }

    @Override
    public StreamWrapper<U> getLastActive();

    public <R> BaseSimpleReactStream<R> then(Function<? super U, ? extends R> var1, Executor var2);

    public <R> BaseSimpleReactStream<R> thenSync(Function<? super U, ? extends R> var1);

    public <R> Object retry(Function<? super U, ? extends R> var1);

    public <R> BaseSimpleReactStream<R> fromStream(Stream<R> var1);

    public <R> BaseSimpleReactStream<R> then(Function<? super U, ? extends R> var1);

    public BaseSimpleReactStream<U> peek(Consumer<? super U> var1);

    public BaseSimpleReactStream<U> peekSync(Consumer<? super U> var1);

    public <R> BaseSimpleReactStream<R> flatMapToCompletableFuture(Function<? super U, CompletableFuture<? extends R>> var1);

    public <R> BaseSimpleReactStream<R> flatMapToCompletableFutureSync(Function<? super U, CompletableFuture<? extends R>> var1);

    public <R> BaseSimpleReactStream<R> flatMap(Function<? super U, ? extends Stream<? extends R>> var1);

    public BaseSimpleReactStream<U> filter(Predicate<? super U> var1);

    public BaseSimpleReactStream<U> filterSync(Predicate<? super U> var1);

    public <T> Stream<CompletableFuture<T>> streamCompletableFutures();

    public BaseSimpleReactStream<U> onFail(Function<? super SimpleReactFailedStageException, ? extends U> var1);

    public BaseSimpleReactStream<U> onFail(Class<? extends Throwable> var1, Function<? super SimpleReactFailedStageException, ? extends U> var2);

    public BaseSimpleReactStream<U> capture(Consumer<Throwable> var1);

    public BaseSimpleReactStream<U> sync();

    public BaseSimpleReactStream<U> async();

    public Queue<U> toQueue();

    public static <T> SimpleReactStream<T> react(Supplier<T> value) {
        return new SimpleReact(ThreadPools.getStandard(), (RetryExecutor)new AsyncRetryExecutor(ThreadPools.getSequentialRetry()), false).ofAsync(value);
    }

    @SafeVarargs
    public static <T> SimpleReactStream<T> react(Supplier<T> ... values) {
        return new SimpleReact(ThreadPools.getStandard(), (RetryExecutor)new AsyncRetryExecutor(ThreadPools.getSequentialRetry()), false).ofAsync(values);
    }

    public static <T> SimpleReactStream<T> of(T value) {
        return BaseSimpleReactStream.simpleReactStream(Seq.of(value));
    }

    @SafeVarargs
    public static <T> SimpleReactStream<T> of(T ... values) {
        return BaseSimpleReactStream.simpleReactStream(Seq.of((Object[])values));
    }

    public static <T> SimpleReactStream<T> freeThread(T value) {
        return new SimpleReact(ThreadPools.getSequential(), (RetryExecutor)new AsyncRetryExecutor(ThreadPools.getSequentialRetry()), false).of(value);
    }

    @SafeVarargs
    public static <T> SimpleReactStream<T> freeThread(T ... values) {
        return new SimpleReact(ThreadPools.getSequential(), (RetryExecutor)new AsyncRetryExecutor(ThreadPools.getSequentialRetry()), false).of(values);
    }

    public static <T> SimpleReactStream<T> empty() {
        return BaseSimpleReactStream.simpleReactStream(Seq.empty());
    }

    public static <U> SimpleReactStream<U> parallel(U ... array) {
        return SimpleReact.parallelCommonBuilder().from(Arrays.asList(array));
    }

    public static <T> BaseSimpleReactStream<T> simpleReactStreamFrom(Stream<CompletableFuture<T>> stream) {
        return new SimpleReact(ThreadPools.getSequential(), (RetryExecutor)new AsyncRetryExecutor(ThreadPools.getSequentialRetry()), false).fromStream(stream);
    }

    public static <T> BaseSimpleReactStream<T> simpleReactStream(CompletableFuture<T> value) {
        return new SimpleReact(ThreadPools.getSequential(), (RetryExecutor)new AsyncRetryExecutor(ThreadPools.getSequentialRetry()), false).fromStream(Stream.of(value));
    }

    public static <T> SimpleReactStream<T> simpleReactStream(CompletableFuture<T> ... values) {
        return new SimpleReact(ThreadPools.getSequential(), (RetryExecutor)new AsyncRetryExecutor(ThreadPools.getSequentialRetry()), false).fromStream(Stream.of(values));
    }

    public static <T> SimpleReactStream<T> simpleReactStream(Stream<T> stream) {
        if (stream instanceof LazyFutureStream) {
            stream = ((LazyFutureStream)stream).toQueue().stream(((LazyFutureStream)stream).getSubscription());
        }
        SimpleReact sr = new SimpleReact(ThreadPools.getCurrentThreadExecutor(), (RetryExecutor)RetryBuilder.getDefaultInstance().withScheduler(ThreadPools.getSequentialRetry()), false);
        return new SimpleReactStreamImpl(sr, stream.map(CompletableFuture::completedFuture));
    }

    public static <T> SimpleReactStream<T> simpleReactStreamFromIterable(Iterable<T> iterable) {
        return BaseSimpleReactStream.simpleReactStream(iterable.iterator());
    }

    public static <T> SimpleReactStream<T> simpleReactStream(Iterator<T> iterator) {
        return BaseSimpleReactStream.simpleReactStream(StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false));
    }

    public Continueable getSubscription();

    public QueueFactory<U> getQueueFactory();

    public BaseSimpleReactStream<U> withSubscription(Continueable var1);

    public BaseSimpleReactStream<U> withQueueFactory(QueueFactory<U> var1);

    public BaseSimpleReactStream<U> withRetrier(RetryExecutor var1);

    public Executor getTaskExecutor();

    public boolean isAsync();
}

