/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.types;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.Reducer;
import com.aol.cyclops.control.Eval;
import com.aol.cyclops.control.FeatureToggle;
import com.aol.cyclops.control.Ior;
import com.aol.cyclops.control.LazyReact;
import com.aol.cyclops.control.Maybe;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.SimpleReact;
import com.aol.cyclops.control.Try;
import com.aol.cyclops.control.Xor;
import com.aol.cyclops.data.LazyImmutable;
import com.aol.cyclops.data.Mutable;
import com.aol.cyclops.data.collections.extensions.persistent.PBagX;
import com.aol.cyclops.data.collections.extensions.persistent.POrderedSetX;
import com.aol.cyclops.data.collections.extensions.persistent.PQueueX;
import com.aol.cyclops.data.collections.extensions.persistent.PSetX;
import com.aol.cyclops.data.collections.extensions.persistent.PStackX;
import com.aol.cyclops.data.collections.extensions.persistent.PVectorX;
import com.aol.cyclops.data.collections.extensions.standard.DequeX;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.data.collections.extensions.standard.QueueX;
import com.aol.cyclops.data.collections.extensions.standard.SetX;
import com.aol.cyclops.data.collections.extensions.standard.SortedSetX;
import com.aol.cyclops.types.Convertable;
import com.aol.cyclops.types.Foldable;
import com.aol.cyclops.types.futurestream.LazyFutureStream;
import com.aol.cyclops.types.futurestream.SimpleReactStream;
import com.aol.cyclops.types.stream.reactive.ValueSubscriber;
import com.aol.cyclops.util.function.Predicates;
import java.beans.ConstructorProperties;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public interface Value<T>
extends Supplier<T>,
Foldable<T>,
Convertable<T>,
Publisher<T>,
Predicate<T> {
    default public <R> R visit(Function<? super T, ? extends R> present, Supplier<? extends R> absent) {
        return this.toMaybe().visit(present, absent);
    }

    @Override
    default public boolean test(T t) {
        if (!(t instanceof Value)) {
            return Predicates.eqv(Maybe.ofNullable(t)).test(this);
        }
        return Predicates.eqv((Value)t).test(this);
    }

    default public ValueSubscriber<T> newSubscriber() {
        return ValueSubscriber.subscriber();
    }

    default public void subscribe(final Subscriber<? super T> sub) {
        sub.onSubscribe(new Subscription(){
            AtomicBoolean running = new AtomicBoolean(true);

            public void request(long n) {
                if (n < 1L) {
                    sub.onError((Throwable)new IllegalArgumentException("3.9 While the Subscription is not cancelled, Subscription.request(long n) MUST throw a java.lang.IllegalArgumentException if the argument is <= 0."));
                }
                if (!this.running.compareAndSet(true, false)) {
                    return;
                }
                try {
                    sub.onNext(Value.this.get());
                }
                catch (Throwable t) {
                    sub.onError(t);
                }
                sub.onComplete();
            }

            public void cancel() {
                this.running.set(false);
            }
        });
    }

    public static <T> Value<T> of(Supplier<T> supplier) {
        return new ValueImpl<T>(supplier);
    }

    @Override
    default public ReactiveSeq<T> stream() {
        return ReactiveSeq.of(new Try[]{Try.withCatch(() -> this.get(), NoSuchElementException.class)}).filter(Try::isSuccess).map(Try::get);
    }

    default public ListX<?> unapply() {
        return this.toListX();
    }

    default public ReactiveSeq<T> iterate(UnaryOperator<T> fn) {
        return ReactiveSeq.iterate(this.get(), fn);
    }

    default public ReactiveSeq<T> generate() {
        return ReactiveSeq.generate(this);
    }

    @Override
    default public <E> E mapReduce(Reducer<E> monoid) {
        return monoid.mapReduce(this.toStream());
    }

    default public T fold(Monoid<T> monoid) {
        return monoid.reduce(this.toStream());
    }

    default public T fold(T identity, BinaryOperator<T> accumulator) {
        Optional opt = this.toOptional();
        if (opt.isPresent()) {
            return (T)accumulator.apply(identity, this.get());
        }
        return identity;
    }

    default public LazyImmutable<T> toLazyImmutable() {
        return LazyImmutable.of(this.get());
    }

    default public Mutable<T> toMutable() {
        return Mutable.of(this.get());
    }

    default public Xor<?, T> toXor() {
        if (this instanceof Xor) {
            return (Xor)this;
        }
        Optional o = this.toOptional();
        return o.isPresent() ? Xor.primary(o.get()) : Xor.secondary(new NoSuchElementException());
    }

    default public <ST> Xor<ST, T> toXor(ST secondary) {
        Optional o = this.toOptional();
        return o.isPresent() ? Xor.primary(o.get()) : Xor.secondary(secondary);
    }

    default public <X extends Throwable> Try<T, X> toTry(X throwable) {
        return this.toXor().visit((? super ST secondary) -> Try.failure(throwable), (? super PT primary) -> Try.success(primary));
    }

    default public Try<T, Throwable> toTry() {
        return this.toXor().visit((? super ST secondary) -> Try.failure(new NoSuchElementException()), (? super PT primary) -> Try.success(primary));
    }

    default public <X extends Throwable> Try<T, X> toTry(Class<X> ... classes) {
        return Try.withCatch(() -> this.get(), classes);
    }

    default public Ior<?, T> toIor() {
        if (this instanceof Ior) {
            return (Ior)this;
        }
        Optional o = this.toOptional();
        return o.isPresent() ? Ior.primary(o.get()) : Ior.secondary(new NoSuchElementException());
    }

    default public FeatureToggle<T> toFeatureToggle() {
        Optional opt = this.toOptional();
        return opt.isPresent() ? FeatureToggle.enable(opt.get()) : FeatureToggle.disable(null);
    }

    default public Eval<T> toEvalNow() {
        return Eval.now(this.get());
    }

    default public Eval<T> toEvalLater() {
        return Eval.later(this);
    }

    default public Eval<T> toEvalAlways() {
        return Eval.always(this);
    }

    default public Maybe<T> toMaybe() {
        return Maybe.fromOptional(this.toOptional());
    }

    default public ListX<T> toListX() {
        return ListX.fromIterable(this.toList());
    }

    default public SetX<T> toSetX() {
        return SetX.fromIterable(this.toList());
    }

    default public SortedSetX<T> toSortedSetX() {
        return SortedSetX.fromIterable(this.toList());
    }

    default public QueueX<T> toQueueX() {
        return QueueX.fromIterable(this.toList());
    }

    default public DequeX<T> toDequeX() {
        return DequeX.fromIterable(this.toList());
    }

    default public PStackX<T> toPStackX() {
        return PStackX.fromCollection(this.toList());
    }

    default public PVectorX<T> toPVectorX() {
        return PVectorX.fromCollection(this.toList());
    }

    default public PQueueX<T> toPQueueX() {
        return PQueueX.fromCollection(this.toList());
    }

    default public PSetX<T> toPSetX() {
        return PSetX.fromCollection(this.toList());
    }

    default public POrderedSetX<T> toPOrderedSetX() {
        return POrderedSetX.fromCollection(this.toList());
    }

    default public PBagX<T> toPBagX() {
        return PBagX.fromCollection(this.toList());
    }

    default public String mkString() {
        Optional opt = this.toOptional();
        if (opt.isPresent()) {
            return this.getClass().getSimpleName() + "[" + opt.get() + "]";
        }
        return this.getClass().getSimpleName() + "[]";
    }

    default public LazyFutureStream<T> toFutureStream(LazyReact reactor) {
        return reactor.ofAsync(this);
    }

    default public LazyFutureStream<T> toFutureStream() {
        return new LazyReact().ofAsync(this);
    }

    default public SimpleReactStream<T> toSimpleReact(SimpleReact reactor) {
        return reactor.ofAsync(this);
    }

    default public SimpleReactStream<T> toSimpleReact() {
        return new SimpleReact().ofAsync(this);
    }

    public static class ValueImpl<T>
    implements Value<T> {
        private final Supplier<T> delegate;

        @Override
        public T get() {
            return this.delegate.get();
        }

        @Override
        public Iterator<T> iterator() {
            return this.stream().iterator();
        }

        @ConstructorProperties(value={"delegate"})
        public ValueImpl(Supplier<T> delegate) {
            this.delegate = delegate;
        }
    }
}

