/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.types;

import com.aol.cyclops.control.Matchable;
import com.aol.cyclops.control.Trampoline;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

@FunctionalInterface
public interface Functor<T> {
    default public <U> Functor<U> cast(Class<? extends U> type) {
        return this.map(type::cast);
    }

    public <R> Functor<R> map(Function<? super T, ? extends R> var1);

    default public Functor<T> peek(Consumer<? super T> c) {
        return this.map(input -> {
            c.accept(input);
            return input;
        });
    }

    default public <R> Functor<R> trampoline(Function<? super T, ? extends Trampoline<? extends R>> mapper) {
        return this.map(in -> ((Trampoline)mapper.apply(in)).result());
    }

    default public <R> Functor<R> patternMatch(Function<Matchable.CheckValue1<T, R>, Matchable.CheckValue1<T, R>> case1, Supplier<? extends R> otherwise) {
        return this.map(u -> Matchable.of(u).matches(case1, otherwise).get());
    }
}

