/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.types;

import com.aol.cyclops.control.FutureW;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Stream;

public interface Convertable<T>
extends Iterable<T>,
Supplier<T> {
    public static <T> Convertable<T> fromSupplier(Supplier<T> supplier) {
        return new SupplierToConvertable<T>(supplier);
    }

    @Override
    public T get();

    default public T orElseGet(Supplier<? extends T> value) {
        return this.toOptional().orElseGet(value);
    }

    default public Optional<T> toOptional() {
        try {
            return Optional.ofNullable(this.get());
        }
        catch (NoSuchElementException e) {
            return Optional.empty();
        }
    }

    default public Stream<T> toStream() {
        return Stream.of(this.toOptional()).filter(Optional::isPresent).map(Optional::get);
    }

    default public AtomicReference<T> toAtomicReference() {
        return new AtomicReference<T>(this.get());
    }

    default public Optional<AtomicReference<T>> toOptionalAtomicReference() {
        return this.toOptional().map(u -> new AtomicReference<Object>(u));
    }

    default public T orElse(T value) {
        return this.toOptional().orElse(value);
    }

    default public <X extends Throwable> T orElseThrow(Supplier<? extends X> ex) throws X {
        return this.toOptional().orElseThrow(ex);
    }

    default public List<T> toList() {
        Optional<T> opt = this.toOptional();
        if (opt.isPresent()) {
            return Arrays.asList(this.get());
        }
        return Arrays.asList(new Object[0]);
    }

    @Override
    default public Iterator<T> iterator() {
        return this.toList().iterator();
    }

    default public FutureW<T> toFutureW() {
        return FutureW.of(this.toCompletableFuture());
    }

    default public CompletableFuture<T> toCompletableFuture() {
        try {
            return CompletableFuture.completedFuture(this.get());
        }
        catch (Throwable t) {
            CompletableFuture res = new CompletableFuture();
            res.completeExceptionally(t);
            return res;
        }
    }

    default public CompletableFuture<T> toCompletableFutureAsync() {
        return CompletableFuture.supplyAsync(this);
    }

    default public CompletableFuture<T> toCompletableFutureAsync(Executor exec) {
        return CompletableFuture.supplyAsync(this, exec);
    }

    public static final class SupplierToConvertable<T>
    implements Convertable<T> {
        private final Supplier<T> delegate;

        @Override
        public T get() {
            return this.delegate.get();
        }

        @ConstructorProperties(value={"delegate"})
        public SupplierToConvertable(Supplier<T> delegate) {
            this.delegate = delegate;
        }

        public Supplier<T> getDelegate() {
            return this.delegate;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SupplierToConvertable)) {
                return false;
            }
            SupplierToConvertable other = (SupplierToConvertable)o;
            Supplier<T> this$delegate = this.getDelegate();
            Supplier<T> other$delegate = other.getDelegate();
            return !(this$delegate == null ? other$delegate != null : !this$delegate.equals(other$delegate));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Supplier<T> $delegate = this.getDelegate();
            result = result * 59 + ($delegate == null ? 0 : $delegate.hashCode());
            return result;
        }

        public String toString() {
            return "Convertable.SupplierToConvertable(delegate=" + this.getDelegate() + ")";
        }
    }
}

