/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.react.threads;

import com.aol.cyclops.internal.react.stream.ReactBuilder;
import com.aol.cyclops.util.ExceptionSoftener;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.function.Function;
import java.util.function.Supplier;

public class ReactPool<REACTOR extends ReactBuilder> {
    private final BlockingQueue<REACTOR> queue;
    private final Supplier<REACTOR> supplier;

    private ReactPool(int size) {
        this.queue = new LinkedBlockingQueue<REACTOR>(size);
        this.supplier = null;
    }

    private ReactPool() {
        this.queue = new LinkedBlockingQueue<REACTOR>();
        this.supplier = null;
    }

    private ReactPool(BlockingQueue<REACTOR> queue) {
        this.queue = queue;
        this.supplier = null;
    }

    private ReactPool(Supplier<REACTOR> supplier) {
        this.queue = new LinkedBlockingQueue<REACTOR>();
        this.supplier = supplier;
    }

    public static <REACTOR extends ReactBuilder> ReactPool<REACTOR> boundedPool(Collection<REACTOR> reactors) {
        ReactPool<REACTOR> r = new ReactPool<REACTOR>(reactors.size());
        reactors.forEach(r::populate);
        return r;
    }

    public static <REACTOR extends ReactBuilder> ReactPool<REACTOR> unboundedPool(Collection<REACTOR> reactors) {
        ReactPool<REACTOR> r = new ReactPool<REACTOR>();
        reactors.forEach(r::populate);
        return r;
    }

    public static <REACTOR extends ReactBuilder> ReactPool<REACTOR> elasticPool(Supplier<REACTOR> supplier) {
        return new ReactPool<REACTOR>(supplier);
    }

    public static <REACTOR extends ReactBuilder> ReactPool<REACTOR> syncrhonousPool() {
        ReactPool r = new ReactPool(new SynchronousQueue());
        return r;
    }

    public void populate(REACTOR next) {
        try {
            this.queue.put(next);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw ExceptionSoftener.throwSoftenedException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T react(Function<? super REACTOR, ? extends T> fn) {
        Object reactor = null;
        try {
            reactor = this.nextReactor();
            T t = fn.apply(reactor);
            return t;
        }
        finally {
            if (reactor != null) {
                this.queue.offer(reactor);
            }
        }
    }

    public REACTOR nextReactor() {
        ReactBuilder reactor = (ReactBuilder)this.queue.poll();
        try {
            if (reactor == null) {
                reactor = this.isElastic() ? (ReactBuilder)this.supplier.get() : (ReactBuilder)this.queue.take();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw ExceptionSoftener.throwSoftenedException(e);
        }
        return (REACTOR)reactor;
    }

    private boolean isElastic() {
        return this.supplier != null;
    }
}

