/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.react.collectors.lazy;

import com.aol.cyclops.internal.react.async.future.FastFuture;
import com.aol.cyclops.react.collectors.lazy.LazyResultConsumer;
import com.aol.cyclops.react.collectors.lazy.MaxActive;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;

public class EmptyCollector<T>
implements LazyResultConsumer<T> {
    private final List<FastFuture<T>> active = new ArrayList<FastFuture<T>>();
    private final MaxActive maxActive;
    private final Function<FastFuture<T>, T> safeJoin;

    EmptyCollector() {
        this.maxActive = MaxActive.IO;
        this.safeJoin = cf -> cf.join();
    }

    @Override
    public void accept(FastFuture<T> t) {
        this.active.add(t);
        if (this.active.size() > this.maxActive.getMaxActive()) {
            while (this.active.size() > this.maxActive.getReduceTo()) {
                List toRemove = this.active.stream().filter(cf -> cf.isDone()).peek(this::handleExceptions).collect(Collectors.toList());
                this.active.removeAll(toRemove);
                if (this.active.size() <= this.maxActive.getReduceTo()) continue;
                CompletableFuture promise = new CompletableFuture();
                FastFuture.xOf(this.active.size() - this.maxActive.getReduceTo(), () -> promise.complete(true), this.active.toArray(new FastFuture[0]));
                promise.join();
            }
        }
    }

    public void add(FastFuture<T> t) {
        this.active.add(t);
    }

    private void handleExceptions(FastFuture cf) {
        if (cf.isCompletedExceptionally()) {
            this.safeJoin.apply(cf);
        }
    }

    @Override
    public EmptyCollector<T> withResults(Collection<FastFuture<T>> t) {
        return this.withMaxActive(this.maxActive);
    }

    @Override
    public void block(Function<FastFuture<T>, T> safeJoin) {
        if (this.active.size() == 0) {
            return;
        }
        this.active.stream().peek(cf -> safeJoin.apply((FastFuture)cf)).forEach(a -> {});
    }

    @Override
    public Collection<FastFuture<T>> getResults() {
        this.active.stream().forEach(cf -> this.safeJoin.apply((FastFuture<FastFuture>)cf));
        this.active.clear();
        return new ArrayList<FastFuture<T>>();
    }

    @Override
    public Collection<FastFuture<T>> getAllResults() {
        return this.getResults();
    }

    public boolean hasCapacity(int i) {
        return this.maxActive.getMaxActive() + i > this.active.size();
    }

    public EmptyCollector<T> withMaxActive(MaxActive maxActive) {
        return this.maxActive == maxActive ? this : new EmptyCollector<T>(maxActive, this.safeJoin);
    }

    public EmptyCollector<T> withSafeJoin(Function<FastFuture<T>, T> safeJoin) {
        return this.safeJoin == safeJoin ? this : new EmptyCollector<T>(this.maxActive, safeJoin);
    }

    @ConstructorProperties(value={"maxActive", "safeJoin"})
    public EmptyCollector(MaxActive maxActive, Function<FastFuture<T>, T> safeJoin) {
        this.maxActive = maxActive;
        this.safeJoin = safeJoin;
    }

    public MaxActive getMaxActive() {
        return this.maxActive;
    }

    public Function<FastFuture<T>, T> getSafeJoin() {
        return this.safeJoin;
    }
}

