/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.stream.spliterators;

import com.aol.cyclops.internal.stream.spliterators.ReversableSpliterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.IntConsumer;

public class ReversingRangeIntSpliterator
implements Spliterator.OfInt,
ReversableSpliterator {
    private final int min;
    private final int max;
    private int index;
    private boolean reverse;

    public ReversingRangeIntSpliterator(int min, int max, boolean reverse) {
        this.min = Math.min(min, max) - 1;
        this.max = Math.max(min, max);
        this.reverse = this.max >= this.min ? reverse : !reverse;
        this.index = Math.min(min, max);
    }

    @Override
    public ReversableSpliterator invert() {
        this.setReverse(!this.isReverse());
        this.index = this.max - 1;
        return this;
    }

    @Override
    public boolean tryAdvance(IntConsumer consumer) {
        Objects.requireNonNull(consumer);
        if (!this.reverse && this.index < this.max && this.index > this.min) {
            consumer.accept(this.index++);
            return true;
        }
        if (this.reverse && this.index > this.min && this.index < this.max) {
            consumer.accept(this.index--);
            return true;
        }
        return false;
    }

    @Override
    public long estimateSize() {
        return this.max;
    }

    @Override
    public int characteristics() {
        return 1024;
    }

    @Override
    public Spliterator.OfInt trySplit() {
        return this;
    }

    @Override
    public ReversableSpliterator copy() {
        return new ReversingRangeIntSpliterator(this.index, this.max, this.reverse);
    }

    @Override
    public boolean isReverse() {
        return this.reverse;
    }

    @Override
    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }
}

