/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.stream.operators;

import com.aol.cyclops.data.collections.extensions.standard.ListXImpl;
import com.aol.cyclops.util.stream.StreamUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class BatchWhileOperator<T, C extends Collection<? super T>> {
    private static final Object UNSET = new Object();
    private final Stream<T> stream;
    private final Supplier<C> factory;

    public BatchWhileOperator(Stream<T> stream) {
        this.stream = stream;
        this.factory = () -> new ListXImpl();
    }

    public BatchWhileOperator(Stream<T> stream, Supplier<C> factory2) {
        this.stream = stream;
        this.factory = factory2;
    }

    public Stream<C> batchWhile(final Predicate<? super T> predicate) {
        final Iterator it = this.stream.iterator();
        return StreamUtils.stream(new Iterator<C>(){
            T value = BatchWhileOperator.access$000();

            @Override
            public boolean hasNext() {
                return this.value != UNSET || it.hasNext();
            }

            @Override
            public C next() {
                Collection list = (Collection)BatchWhileOperator.this.factory.get();
                if (this.value != UNSET) {
                    list.add(this.value);
                }
                while (it.hasNext()) {
                    Object value = it.next();
                    list.add(value);
                    if (!predicate.test(value)) {
                        value = UNSET;
                        break;
                    }
                    value = UNSET;
                }
                return list;
            }
        }).filter(l -> l.size() > 0);
    }
}

