/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.stream.operators;

import com.aol.cyclops.data.collections.extensions.standard.ListXImpl;
import com.aol.cyclops.util.stream.StreamUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class BatchBySizeOperator<T, C extends Collection<? super T>> {
    private final Stream<T> stream;
    private final Supplier<C> factory;

    public BatchBySizeOperator(Stream<T> stream) {
        this.stream = stream;
        this.factory = () -> new ListXImpl();
    }

    public BatchBySizeOperator(Stream<T> stream2, Supplier<C> factory2) {
        this.stream = stream2;
        this.factory = factory2;
    }

    public Stream<C> batchBySize(final int groupSize) {
        if (groupSize < 1) {
            throw new IllegalArgumentException("Batch size must be 1 or more");
        }
        final Iterator it = this.stream.iterator();
        return StreamUtils.stream(new Iterator<C>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public C next() {
                Collection list = (Collection)BatchBySizeOperator.this.factory.get();
                for (int i = 0; i < groupSize; ++i) {
                    if (!it.hasNext()) continue;
                    list.add(it.next());
                }
                return list;
            }
        });
    }
}

