/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.stream;

import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.util.stream.Streamable;
import java.beans.ConstructorProperties;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ReversedIterator<U>
implements Streamable<U> {
    private final List<U> list;

    public List<U> getValue() {
        return this.list;
    }

    @Override
    public ReactiveSeq<U> stream() {
        return ReactiveSeq.fromIterator(this.reversedIterator());
    }

    public Iterator<U> reversedIterator() {
        final ListIterator<U> iterator = this.list.listIterator(this.list.size());
        return new Iterator<U>(){

            @Override
            public boolean hasNext() {
                return iterator.hasPrevious();
            }

            @Override
            public U next() {
                return iterator.previous();
            }
        };
    }

    @ConstructorProperties(value={"list"})
    public ReversedIterator(List<U> list) {
        this.list = list;
    }
}

