/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.stream;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.Reducer;
import com.aol.cyclops.control.AnyM;
import com.aol.cyclops.control.For;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.data.collections.extensions.CollectionX;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.data.collections.extensions.standard.MapX;
import com.aol.cyclops.internal.monads.ComprehenderSelector;
import com.aol.cyclops.internal.stream.spliterators.ReversableSpliterator;
import com.aol.cyclops.types.Unwrapable;
import com.aol.cyclops.types.anyM.AnyMSeq;
import com.aol.cyclops.types.stream.HeadAndTail;
import com.aol.cyclops.types.stream.HotStream;
import com.aol.cyclops.types.stream.PausableHotStream;
import com.aol.cyclops.types.stream.future.FutureOperations;
import com.aol.cyclops.util.stream.AsStreamable;
import com.aol.cyclops.util.stream.StreamUtils;
import com.aol.cyclops.util.stream.Streamable;
import java.io.BufferedReader;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.BaseStream;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.jooq.lambda.Collectable;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple;
import org.jooq.lambda.tuple.Tuple2;
import org.jooq.lambda.tuple.Tuple3;
import org.jooq.lambda.tuple.Tuple4;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class ReactiveSeqImpl<T>
implements Unwrapable,
ReactiveSeq<T>,
Iterable<T> {
    private final Seq<T> stream;
    private final Optional<ReversableSpliterator> reversable;

    public ReactiveSeqImpl(Stream<T> stream) {
        this.stream = Seq.seq(stream);
        this.reversable = Optional.empty();
    }

    public ReactiveSeqImpl(Stream<T> stream, ReversableSpliterator rev) {
        this.stream = Seq.seq(stream);
        this.reversable = Optional.of(rev);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator) {
        return (U)this.stream.foldLeft(identity, accumulator);
    }

    @Override
    public <T> ReactiveSeq<T> unit(T unit) {
        return ReactiveSeq.of(new Object[]{unit});
    }

    @Override
    public HotStream<T> schedule(String cron, ScheduledExecutorService ex) {
        return StreamUtils.schedule(this, cron, ex);
    }

    @Override
    public HotStream<T> scheduleFixedDelay(long delay, ScheduledExecutorService ex) {
        return StreamUtils.scheduleFixedDelay(this, delay, ex);
    }

    @Override
    public HotStream<T> scheduleFixedRate(long rate, ScheduledExecutorService ex) {
        return StreamUtils.scheduleFixedRate(this, rate, ex);
    }

    @Override
    @Deprecated
    public final <R> R unwrap() {
        return (R)this;
    }

    @Override
    public final <T1> ReactiveSeq<T1> flatten() {
        return StreamUtils.flatten(this.stream);
    }

    public final Stream<T> unwrapStream() {
        return this.stream;
    }

    @Override
    public final ReactiveSeq<T> cycle(int times) {
        return StreamUtils.reactiveSeq(StreamUtils.cycle(times, AsStreamable.fromStream(this.stream)), this.reversable);
    }

    @Override
    public final ReactiveSeq<T> cycle() {
        return StreamUtils.reactiveSeq(StreamUtils.cycle(this.stream), this.reversable);
    }

    @Override
    public final Tuple2<ReactiveSeq<T>, ReactiveSeq<T>> duplicateSequence() {
        Tuple2<Stream<T>, Stream<T>> tuple = StreamUtils.duplicate(this.stream);
        return tuple.map1(s -> StreamUtils.reactiveSeq(s, this.reversable.map((? super T r) -> r.copy()))).map2(s -> StreamUtils.reactiveSeq(s, this.reversable.map((? super T r) -> r.copy())));
    }

    @Override
    public final Tuple3<ReactiveSeq<T>, ReactiveSeq<T>, ReactiveSeq<T>> triplicate() {
        Tuple3<Stream<T>, Stream<T>, Stream<T>> tuple = StreamUtils.triplicate(this.stream);
        return tuple.map1(s -> StreamUtils.reactiveSeq(s, this.reversable.map((? super T r) -> r.copy()))).map2(s -> StreamUtils.reactiveSeq(s, this.reversable.map((? super T r) -> r.copy()))).map3(s -> StreamUtils.reactiveSeq(s, this.reversable.map((? super T r) -> r.copy())));
    }

    @Override
    public final Tuple4<ReactiveSeq<T>, ReactiveSeq<T>, ReactiveSeq<T>, ReactiveSeq<T>> quadruplicate() {
        Tuple4<Stream<T>, Stream<T>, Stream<T>, Stream<T>> tuple = StreamUtils.quadruplicate(this.stream);
        return tuple.map1(s -> StreamUtils.reactiveSeq(s, this.reversable.map((? super T r) -> r.copy()))).map2(s -> StreamUtils.reactiveSeq(s, this.reversable.map((? super T r) -> r.copy()))).map3(s -> StreamUtils.reactiveSeq(s, this.reversable.map((? super T r) -> r.copy()))).map4(s -> StreamUtils.reactiveSeq(s, this.reversable.map((? super T r) -> r.copy())));
    }

    @Override
    public final Tuple2<Optional<T>, ReactiveSeq<T>> splitSequenceAtHead() {
        Tuple2<ReactiveSeq<T>, ReactiveSeq<T>> Tuple22 = this.splitAt(1);
        return new Tuple2(((ReactiveSeq)Tuple22.v1).toOptional().flatMap((? super T l) -> l.size() > 0 ? Optional.of(l.get(0)) : Optional.empty()), Tuple22.v2);
    }

    @Override
    public final Tuple2<ReactiveSeq<T>, ReactiveSeq<T>> splitAt(int where) {
        return StreamUtils.splitAt(this.stream, where).map1(s -> StreamUtils.reactiveSeq(s, this.reversable.map((? super T r) -> r.copy()))).map2(s -> StreamUtils.reactiveSeq(s, this.reversable.map((? super T r) -> r.copy())));
    }

    @Override
    public final Tuple2<ReactiveSeq<T>, ReactiveSeq<T>> splitBy(Predicate<T> splitter) {
        return StreamUtils.splitBy(this.stream, splitter).map1(s -> StreamUtils.reactiveSeq(s, this.reversable.map((? super T r) -> r.copy()))).map2(s -> StreamUtils.reactiveSeq(s, this.reversable.map((? super T r) -> r.copy())));
    }

    @Override
    public final Tuple2<ReactiveSeq<T>, ReactiveSeq<T>> partitionSequence(Predicate<T> splitter) {
        return StreamUtils.partition(this.stream, splitter).map1(s -> StreamUtils.reactiveSeq(s, this.reversable.map((? super T r) -> r.copy()))).map2(s -> StreamUtils.reactiveSeq(s, this.reversable.map((? super T r) -> r.copy())));
    }

    @Override
    public final ReactiveSeq<T> cycle(Monoid<T> m, int times) {
        return StreamUtils.reactiveSeq(StreamUtils.cycle(times, Streamable.of(m.reduce((Stream<T>)this.stream))), this.reversable);
    }

    @Override
    public final <R> ReactiveSeq<R> cycle(Class<R> monadC, int times) {
        return (ReactiveSeqImpl)this.cycle(times).map((T r) -> new ComprehenderSelector().selectComprehender(monadC).of(r));
    }

    @Override
    public final ReactiveSeq<T> cycleWhile(Predicate<? super T> predicate) {
        return StreamUtils.reactiveSeq(StreamUtils.cycle(this.stream), this.reversable).limitWhile((Predicate)predicate);
    }

    @Override
    public final ReactiveSeq<T> cycleUntil(Predicate<? super T> predicate) {
        return StreamUtils.reactiveSeq(StreamUtils.cycle(this.stream), this.reversable).limitWhile((Predicate)predicate.negate());
    }

    @Override
    public final <S> ReactiveSeq<Tuple2<T, S>> zip(Stream<? extends S> second) {
        return this.zipStream(second, (a, b) -> new Tuple2(a, b));
    }

    @Override
    public final <S, U> ReactiveSeq<Tuple3<T, S, U>> zip3(Stream<? extends S> second, Stream<? extends U> third) {
        return this.zip((Stream)second).zipStream((Stream)third).map((T p) -> new Tuple3(((Tuple2)p.v1()).v1(), ((Tuple2)p.v1()).v2(), p.v2()));
    }

    @Override
    public final <T2, T3, T4> ReactiveSeq<Tuple4<T, T2, T3, T4>> zip4(Stream<T2> second, Stream<T3> third, Stream<T4> fourth) {
        return this.zip3(second, third).zipStream(fourth).map((T t) -> new Tuple4(((Tuple3)t.v1()).v1(), ((Tuple3)t.v1()).v2(), ((Tuple3)t.v1()).v3(), t.v2()));
    }

    @Override
    public final <S, R> ReactiveSeq<R> zipSequence(ReactiveSeq<? extends S> second, BiFunction<? super T, ? super S, ? extends R> zipper) {
        return StreamUtils.reactiveSeq(StreamUtils.zipSequence(this.stream, second, zipper), Optional.empty());
    }

    @Override
    public final <S, R> ReactiveSeq<R> zipAnyM(AnyM<? extends S> second, BiFunction<? super T, ? super S, ? extends R> zipper) {
        return this.zipSequence(second.stream(), zipper);
    }

    @Override
    public final <S, R> ReactiveSeq<R> zipStream(BaseStream<? extends S, ? extends BaseStream<? extends S, ?>> second, BiFunction<? super T, ? super S, ? extends R> zipper) {
        return StreamUtils.reactiveSeq(StreamUtils.zipStream(this.stream, second, zipper), Optional.empty());
    }

    @Override
    public final ReactiveSeq<ListX<T>> sliding(int windowSize) {
        return StreamUtils.reactiveSeq(StreamUtils.sliding(this.stream, windowSize), this.reversable);
    }

    @Override
    public final ReactiveSeq<ListX<T>> sliding(int windowSize, int increment) {
        return StreamUtils.reactiveSeq(StreamUtils.sliding(this.stream, windowSize, increment), this.reversable);
    }

    @Override
    public final ReactiveSeq<ListX<T>> grouped(int groupSize) {
        return StreamUtils.reactiveSeq(StreamUtils.batchBySize(this.stream, groupSize), this.reversable);
    }

    @Override
    public ReactiveSeq<ListX<T>> groupedStatefullyWhile(BiPredicate<ListX<? super T>, ? super T> predicate) {
        return StreamUtils.reactiveSeq(StreamUtils.groupedStatefullyWhile(this.stream, predicate), this.reversable);
    }

    @Override
    public final <K> MapX<K, List<T>> groupBy(Function<? super T, ? extends K> classifier) {
        return MapX.fromMap(this.collect(Collectors.groupingBy(classifier)));
    }

    @Override
    public final ReactiveSeq<T> distinct() {
        return StreamUtils.reactiveSeq(this.stream.distinct(), this.reversable);
    }

    @Override
    public final ReactiveSeq<T> scanLeft(Monoid<T> monoid) {
        return StreamUtils.reactiveSeq(StreamUtils.scanLeft(this.stream, monoid), this.reversable);
    }

    @Override
    public final <U> ReactiveSeq<U> scanLeft(U seed, BiFunction<? super U, ? super T, ? extends U> function) {
        return StreamUtils.reactiveSeq(Seq.seq(this.stream).scanLeft(seed, function), this.reversable);
    }

    @Override
    public final ReactiveSeq<T> scanRight(Monoid<T> monoid) {
        return StreamUtils.reactiveSeq(this.reverse().scanLeft(monoid.zero(), (T u, U t) -> monoid.combiner().apply(t, u)), this.reversable);
    }

    @Override
    public final <U> ReactiveSeq<U> scanRight(U identity, BiFunction<? super T, ? super U, ? extends U> combiner) {
        return StreamUtils.reactiveSeq(StreamUtils.scanRight(this.stream, identity, combiner), this.reversable);
    }

    @Override
    public final ReactiveSeq<T> sorted() {
        return StreamUtils.reactiveSeq(this.stream.sorted(), this.reversable);
    }

    @Override
    public final ReactiveSeq<T> sorted(Comparator<? super T> c) {
        return StreamUtils.reactiveSeq(this.stream.sorted(c), this.reversable);
    }

    @Override
    public final ReactiveSeq<T> skip(long num) {
        return StreamUtils.reactiveSeq(this.stream.skip(num), this.reversable);
    }

    @Override
    public final ReactiveSeq<T> skipWhile(Predicate<? super T> p) {
        return StreamUtils.reactiveSeq(StreamUtils.skipWhile(this.stream, p), this.reversable);
    }

    @Override
    public final ReactiveSeq<T> skipUntil(Predicate<? super T> p) {
        return StreamUtils.reactiveSeq(StreamUtils.skipUntil(this.stream, p), this.reversable);
    }

    @Override
    public final ReactiveSeq<T> limit(long num) {
        return StreamUtils.reactiveSeq(this.stream.limit(num), this.reversable);
    }

    @Override
    public final ReactiveSeq<T> limitWhile(Predicate<? super T> p) {
        return StreamUtils.reactiveSeq(StreamUtils.limitWhile(this.stream, p), this.reversable);
    }

    @Override
    public final ReactiveSeq<T> limitUntil(Predicate<? super T> p) {
        return StreamUtils.reactiveSeq(StreamUtils.limitUntil(this.stream, p), this.reversable);
    }

    @Override
    public final ReactiveSeq<T> parallel() {
        return this;
    }

    @Override
    public final boolean allMatch(Predicate<? super T> c) {
        return this.stream.allMatch(c);
    }

    @Override
    public final boolean anyMatch(Predicate<? super T> c) {
        return this.stream.anyMatch(c);
    }

    @Override
    public boolean xMatch(int num, Predicate<? super T> c) {
        return StreamUtils.xMatch(this.stream, num, c);
    }

    @Override
    public final boolean noneMatch(Predicate<? super T> c) {
        return this.stream.allMatch(c.negate());
    }

    @Override
    public final String join() {
        return StreamUtils.join(this.stream, "");
    }

    @Override
    public final String join(String sep) {
        return StreamUtils.join(this.stream, sep);
    }

    @Override
    public final String join(String sep, String start, String end) {
        return StreamUtils.join(this.stream, sep, start, end);
    }

    @Override
    public final <U extends Comparable<? super U>> Optional<T> minBy(Function<? super T, ? extends U> function) {
        return StreamUtils.minBy(this.stream, function);
    }

    @Override
    public final Optional<T> min(Comparator<? super T> comparator) {
        return StreamUtils.min(this.stream, comparator);
    }

    @Override
    public final <C extends Comparable<? super C>> Optional<T> maxBy(Function<? super T, ? extends C> f) {
        return StreamUtils.maxBy(this.stream, f);
    }

    @Override
    public final Optional<T> max(Comparator<? super T> comparator) {
        return StreamUtils.max(this.stream, comparator);
    }

    @Override
    public final HeadAndTail<T> headAndTail() {
        return StreamUtils.headAndTail(this.stream);
    }

    @Override
    public final Optional<T> findFirst() {
        return this.stream.findFirst();
    }

    @Override
    public final Optional<T> findAny() {
        return this.stream.findAny();
    }

    @Override
    public final <R> R mapReduce(Reducer<R> reducer) {
        return reducer.mapReduce((Stream)this.stream);
    }

    @Override
    public final <R> R mapReduce(Function<? super T, ? extends R> mapper, Monoid<R> reducer) {
        return reducer.reduce((Stream<R>)this.stream.map(mapper));
    }

    @Override
    public final <R, A> R collect(Collector<? super T, A, R> collector) {
        return (R)this.stream.collect(collector);
    }

    @Override
    public final <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        return (R)this.stream.collect(supplier, accumulator, combiner);
    }

    @Override
    public final T reduce(Monoid<T> reducer) {
        return reducer.reduce((Stream<T>)this.stream);
    }

    @Override
    public final Optional<T> reduce(BinaryOperator<T> accumulator) {
        return this.stream.reduce(accumulator);
    }

    @Override
    public final T reduce(T identity, BinaryOperator<T> accumulator) {
        return (T)this.stream.reduce(identity, accumulator);
    }

    @Override
    public final <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        return (U)this.stream.reduce(identity, accumulator, combiner);
    }

    @Override
    public final ListX<T> reduce(Stream<? extends Monoid<T>> reducers) {
        return StreamUtils.reduce(this.stream, reducers);
    }

    @Override
    public final ListX<T> reduce(Iterable<? extends Monoid<T>> reducers) {
        return StreamUtils.reduce(this.stream, reducers);
    }

    public final T foldLeft(Monoid<T> reducer) {
        return this.reduce(reducer);
    }

    public final T foldLeft(T identity, BinaryOperator<T> accumulator) {
        return (T)this.stream.reduce(identity, accumulator);
    }

    public final <T> T foldLeftMapToType(Reducer<T> reducer) {
        return reducer.mapReduce((Stream)this.stream);
    }

    @Override
    public final T foldRight(Monoid<T> reducer) {
        return reducer.reduce((Stream<T>)this.reverse());
    }

    @Override
    public final <U> U foldRight(U seed, BiFunction<? super T, ? super U, ? extends U> function) {
        return (U)Seq.seq(this.stream).foldRight(seed, function);
    }

    @Override
    public final <T> T foldRightMapToType(Reducer<T> reducer) {
        return reducer.mapReduce((Stream)this.reverse());
    }

    @Override
    public final Streamable<T> toStreamable() {
        return AsStreamable.fromStream(this.stream());
    }

    @Override
    public final Set<T> toSet() {
        return (Set)this.stream.collect(Collectors.toSet());
    }

    @Override
    public final List<T> toList() {
        return (List)this.stream.collect(Collectors.toList());
    }

    @Override
    public final <C extends Collection<T>> C toCollection(Supplier<C> collectionFactory) {
        return (C)((Collection)this.stream.collect(Collectors.toCollection(collectionFactory)));
    }

    @Override
    public final <T> Stream<T> toStream() {
        return this.stream;
    }

    @Override
    public final ReactiveSeq<T> stream() {
        return this;
    }

    @Override
    public final boolean startsWithIterable(Iterable<T> iterable) {
        return StreamUtils.startsWith(this.stream, iterable);
    }

    @Override
    public final boolean startsWith(Stream<T> stream2) {
        return StreamUtils.startsWith(this.stream, stream2);
    }

    @Override
    public AnyMSeq<T> anyM() {
        return AnyM.fromStream(this.stream);
    }

    @Override
    public final <R> ReactiveSeq<R> map(Function<? super T, ? extends R> fn) {
        return new ReactiveSeqImpl<T>(this.stream.map(fn));
    }

    @Override
    public final ReactiveSeq<T> peek(Consumer<? super T> c) {
        return new ReactiveSeqImpl<T>(this.stream.peek(c));
    }

    @Override
    public final <R> ReactiveSeq<R> flatMap(Function<? super T, ? extends Stream<? extends R>> fn) {
        return StreamUtils.reactiveSeq(this.stream.flatMap(fn), this.reversable);
    }

    @Override
    public final <R> ReactiveSeq<R> flatMapAnyM(Function<? super T, AnyM<? extends R>> fn) {
        return StreamUtils.reactiveSeq(StreamUtils.flatMapAnyM(this.stream, fn), this.reversable);
    }

    @Override
    public final <R> ReactiveSeq<R> flatMapIterable(Function<? super T, ? extends Iterable<? extends R>> fn) {
        return StreamUtils.reactiveSeq(StreamUtils.flatMapIterable(this.stream, fn), Optional.empty());
    }

    @Override
    public final <R> ReactiveSeq<R> flatMapStream(Function<? super T, BaseStream<? extends R, ?>> fn) {
        return StreamUtils.reactiveSeq(StreamUtils.flatMapStream(this.stream, fn), this.reversable);
    }

    public final <R> ReactiveSeq<R> flatMapOptional(Function<? super T, Optional<? extends R>> fn) {
        return StreamUtils.reactiveSeq(StreamUtils.flatMapOptional(this.stream, fn), this.reversable);
    }

    public final <R> ReactiveSeq<R> flatMapCompletableFuture(Function<? super T, CompletableFuture<? extends R>> fn) {
        return StreamUtils.reactiveSeq(StreamUtils.flatMapCompletableFuture(this.stream, fn), this.reversable);
    }

    public final ReactiveSeq<Character> flatMapCharSequence(Function<? super T, CharSequence> fn) {
        return StreamUtils.reactiveSeq(StreamUtils.flatMapCharSequence(this.stream, fn), this.reversable);
    }

    public final ReactiveSeq<String> flatMapFile(Function<? super T, File> fn) {
        return StreamUtils.reactiveSeq(StreamUtils.flatMapFile(this.stream, fn), this.reversable);
    }

    public final ReactiveSeq<String> flatMapURL(Function<? super T, URL> fn) {
        return StreamUtils.reactiveSeq(StreamUtils.flatMapURL(this.stream, fn), this.reversable);
    }

    public final ReactiveSeq<String> flatMapBufferedReader(Function<? super T, BufferedReader> fn) {
        return StreamUtils.reactiveSeq(StreamUtils.flatMapBufferedReader(this.stream, fn), this.reversable);
    }

    @Override
    public final ReactiveSeq<T> filter(Predicate<? super T> fn) {
        return StreamUtils.reactiveSeq(this.stream.filter(fn), this.reversable);
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.stream.forEach(action);
    }

    @Override
    public Iterator<T> iterator() {
        return this.stream.iterator();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.stream.spliterator();
    }

    @Override
    public boolean isParallel() {
        return this.stream.isParallel();
    }

    @Override
    public ReactiveSeq<T> sequential() {
        return StreamUtils.reactiveSeq(this.stream.sequential(), this.reversable);
    }

    @Override
    public ReactiveSeq<T> unordered() {
        return StreamUtils.reactiveSeq(this.stream.unordered(), this.reversable);
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super T> mapper) {
        return this.stream.mapToInt(mapper);
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super T> mapper) {
        return this.stream.mapToLong(mapper);
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super T> mapper) {
        return this.stream.mapToDouble(mapper);
    }

    @Override
    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> mapper) {
        return this.stream.flatMapToInt(mapper);
    }

    @Override
    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> mapper) {
        return this.stream.flatMapToLong(mapper);
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
        return this.stream.flatMapToDouble(mapper);
    }

    @Override
    public void forEachOrdered(Consumer<? super T> action) {
        this.stream.forEachOrdered(action);
    }

    @Override
    public Object[] toArray() {
        return this.stream.toArray();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.stream.toArray(generator);
    }

    @Override
    public long count() {
        return this.stream.count();
    }

    @Override
    public ReactiveSeq<T> intersperse(T value) {
        return StreamUtils.reactiveSeq(this.stream.flatMap(t -> Stream.of(value, t)).skip(1L), this.reversable);
    }

    @Override
    public <U> ReactiveSeq<U> ofType(Class<? extends U> type) {
        return StreamUtils.reactiveSeq(StreamUtils.ofType(this.stream, type), this.reversable);
    }

    @Override
    public <U> ReactiveSeq<U> cast(Class<? extends U> type) {
        return StreamUtils.reactiveSeq(StreamUtils.cast(this.stream, type), this.reversable);
    }

    @Override
    public CollectionX<T> toLazyCollection() {
        return StreamUtils.toLazyCollection(this.stream);
    }

    @Override
    public CollectionX<T> toConcurrentLazyCollection() {
        return StreamUtils.toConcurrentLazyCollection(this.stream);
    }

    public Streamable<T> toLazyStreamable() {
        return StreamUtils.toLazyStreamable(this.stream);
    }

    @Override
    public Streamable<T> toConcurrentLazyStreamable() {
        return StreamUtils.toConcurrentLazyStreamable(this.stream);
    }

    @Override
    public ReactiveSeq<T> reverse() {
        if (this.reversable.isPresent()) {
            this.reversable.ifPresent(r -> r.invert());
            return this;
        }
        return StreamUtils.reactiveSeq(StreamUtils.reverse(this.stream), this.reversable);
    }

    @Override
    public ReactiveSeq<T> onClose(Runnable closeHandler) {
        return this;
    }

    @Override
    public void close() {
    }

    @Override
    public ReactiveSeq<T> shuffle() {
        return StreamUtils.reactiveSeq(StreamUtils.shuffle(this.stream).stream(), this.reversable);
    }

    @Override
    public ReactiveSeq<T> appendStream(Stream<T> stream) {
        return StreamUtils.reactiveSeq(StreamUtils.appendStream(this.stream, stream), Optional.empty());
    }

    @Override
    public ReactiveSeq<T> prependStream(Stream<T> stream) {
        return StreamUtils.reactiveSeq(StreamUtils.prependStream(this.stream, stream), Optional.empty());
    }

    @Override
    public ReactiveSeq<T> append(T ... values) {
        return StreamUtils.reactiveSeq(StreamUtils.append(this.stream, values), Optional.empty());
    }

    @Override
    public ReactiveSeq<T> prepend(T ... values) {
        return StreamUtils.reactiveSeq(StreamUtils.prepend(this.stream, values), Optional.empty());
    }

    @Override
    public ReactiveSeq<T> insertAt(int pos, T ... values) {
        return StreamUtils.reactiveSeq(StreamUtils.insertAt(this.stream, pos, values), Optional.empty());
    }

    @Override
    public ReactiveSeq<T> deleteBetween(int start, int end) {
        return StreamUtils.reactiveSeq(StreamUtils.deleteBetween(this.stream, start, end), Optional.empty());
    }

    @Override
    public ReactiveSeq<T> insertStreamAt(int pos, Stream<T> stream) {
        return StreamUtils.reactiveSeq(StreamUtils.insertStreamAt(this.stream, pos, stream), Optional.empty());
    }

    @Override
    public FutureOperations<T> futureOperations(Executor exec) {
        return StreamUtils.futureOperations(this.stream, exec);
    }

    @Override
    public boolean endsWithIterable(Iterable<T> iterable) {
        return StreamUtils.endsWith(this.stream, iterable);
    }

    @Override
    public HotStream<T> hotStream(Executor e) {
        return StreamUtils.hotStream(this.stream, e);
    }

    @Override
    public T firstValue() {
        return StreamUtils.firstValue(this.stream);
    }

    @Override
    public void subscribe(final Subscriber<? super T> sub) {
        final Iterator it = this.stream.iterator();
        sub.onSubscribe(new Subscription(){
            volatile boolean running = true;
            boolean active = false;
            final LinkedList<Long> requests = new LinkedList();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void request(long n) {
                if (!this.running) {
                    return;
                }
                if (n < 1L) {
                    sub.onError((Throwable)new IllegalArgumentException("3.9 While the Subscription is not cancelled, Subscription.request(long n) MUST throw a java.lang.IllegalArgumentException if the argument is <= 0."));
                }
                this.requests.push(n);
                if (this.active) {
                    return;
                }
                this.active = true;
                block5: while (this.requests.size() > 0) {
                    long num = this.requests.pop();
                    int i = 0;
                    while ((long)i < num && this.running) {
                        block11: {
                            boolean progressing = false;
                            boolean progressed = false;
                            try {
                                if (it.hasNext()) {
                                    progressing = true;
                                    sub.onNext(it.next());
                                    progressed = true;
                                    break block11;
                                }
                                try {
                                    sub.onComplete();
                                }
                                finally {
                                    this.running = false;
                                }
                            }
                            catch (Throwable t) {
                                sub.onError(t);
                                if (!progressing || progressed) break block11;
                            }
                            continue block5;
                        }
                        ++i;
                    }
                }
                this.active = false;
            }

            public void cancel() {
                this.running = false;
            }
        });
    }

    @Override
    public <U> ReactiveSeq<Tuple2<T, U>> zip(Seq<? extends U> other) {
        return StreamUtils.reactiveSeq(Seq.seq(this.stream).zip(other), this.reversable);
    }

    @Override
    public ReactiveSeq<T> onEmpty(T value) {
        return StreamUtils.reactiveSeq(Seq.seq(this.stream).onEmpty(value), Optional.empty());
    }

    @Override
    public ReactiveSeq<T> onEmptyGet(Supplier<? extends T> supplier) {
        return StreamUtils.reactiveSeq(Seq.seq(this.stream).onEmptyGet(supplier), Optional.empty());
    }

    @Override
    public <X extends Throwable> ReactiveSeq<T> onEmptyThrow(Supplier<? extends X> supplier) {
        return StreamUtils.reactiveSeq(Seq.seq(this.stream).onEmptyThrow(supplier), Optional.empty());
    }

    @Override
    public ReactiveSeq<T> concat(Stream<? extends T> other) {
        return StreamUtils.reactiveSeq(Seq.seq(this.stream).concat(other), Optional.empty());
    }

    @Override
    public ReactiveSeq<T> concat(T other) {
        return StreamUtils.reactiveSeq(Seq.seq(this.stream).concat(other), Optional.empty());
    }

    @Override
    public ReactiveSeq<T> concat(T ... other) {
        return StreamUtils.reactiveSeq(Seq.seq(this.stream).concat((Object[])other), Optional.empty());
    }

    @Override
    public <U> ReactiveSeq<T> distinct(Function<? super T, ? extends U> keyExtractor) {
        return StreamUtils.reactiveSeq(Seq.seq(this.stream).distinct(keyExtractor), this.reversable);
    }

    @Override
    public <U, R> ReactiveSeq<R> zip(Seq<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return StreamUtils.reactiveSeq(Seq.seq(this.stream).zip(other, zipper), Optional.empty());
    }

    @Override
    public ReactiveSeq<T> shuffle(Random random) {
        return StreamUtils.reactiveSeq(Seq.seq(this.stream).shuffle(random), this.reversable);
    }

    @Override
    public ReactiveSeq<T> slice(long from, long to) {
        return StreamUtils.reactiveSeq(Seq.seq(this.stream).slice(from, to), this.reversable);
    }

    @Override
    public <U extends Comparable<? super U>> ReactiveSeq<T> sorted(Function<? super T, ? extends U> function) {
        return StreamUtils.reactiveSeq(Seq.seq(this.stream).sorted(function), this.reversable);
    }

    @Override
    public <U> ReactiveSeq<Tuple2<T, U>> zipStream(Stream<? extends U> other) {
        return StreamUtils.reactiveSeq(StreamUtils.zipStream(this.stream, other, Tuple::tuple), Optional.empty());
    }

    @Override
    public ReactiveSeq<T> xPer(int x, long time, TimeUnit t) {
        return StreamUtils.reactiveSeq(StreamUtils.xPer(this.stream, x, time, t), this.reversable);
    }

    @Override
    public ReactiveSeq<T> onePer(long time, TimeUnit t) {
        return StreamUtils.reactiveSeq(StreamUtils.onePer(this.stream, time, t), this.reversable);
    }

    @Override
    public ReactiveSeq<T> debounce(long time, TimeUnit t) {
        return StreamUtils.reactiveSeq(StreamUtils.debounce(this.stream, time, t), this.reversable);
    }

    @Override
    public ReactiveSeq<ListX<T>> groupedBySizeAndTime(int size, long time, TimeUnit t) {
        return StreamUtils.reactiveSeq(StreamUtils.batchBySizeAndTime(this.stream, size, time, t), this.reversable);
    }

    @Override
    public ReactiveSeq<ListX<T>> groupedByTime(long time, TimeUnit t) {
        return StreamUtils.reactiveSeq(StreamUtils.batchByTime(this.stream, time, t), this.reversable);
    }

    @Override
    public T foldRight(T identity, BinaryOperator<T> accumulator) {
        return (T)this.reverse().foldLeft(identity, accumulator);
    }

    @Override
    public boolean endsWith(Stream<T> iterable) {
        return StreamUtils.endsWith(this.stream, () -> iterable.iterator());
    }

    @Override
    public ReactiveSeq<T> skip(long time, TimeUnit unit) {
        return StreamUtils.reactiveSeq(StreamUtils.skip(this.stream, time, unit), this.reversable);
    }

    @Override
    public ReactiveSeq<T> limit(long time, TimeUnit unit) {
        return StreamUtils.reactiveSeq(StreamUtils.limit(this.stream, time, unit), this.reversable);
    }

    @Override
    public ReactiveSeq<T> fixedDelay(long l, TimeUnit unit) {
        return StreamUtils.reactiveSeq(StreamUtils.fixedDelay(this.stream, l, unit), this.reversable);
    }

    @Override
    public ReactiveSeq<T> jitter(long l) {
        return StreamUtils.reactiveSeq(StreamUtils.jitter(this.stream, l), this.reversable);
    }

    @Override
    public ReactiveSeq<ListX<T>> groupedUntil(Predicate<? super T> predicate) {
        return StreamUtils.reactiveSeq(StreamUtils.batchUntil(this.stream, predicate), this.reversable);
    }

    @Override
    public ReactiveSeq<ListX<T>> groupedWhile(Predicate<? super T> predicate) {
        return StreamUtils.reactiveSeq(StreamUtils.batchWhile(this.stream, predicate), this.reversable);
    }

    @Override
    public <C extends Collection<? super T>> ReactiveSeq<C> groupedWhile(Predicate<? super T> predicate, Supplier<C> factory2) {
        return StreamUtils.reactiveSeq(StreamUtils.batchWhile(this.stream, predicate, factory2), this.reversable);
    }

    @Override
    public <C extends Collection<? super T>> ReactiveSeq<C> groupedUntil(Predicate<? super T> predicate, Supplier<C> factory2) {
        return StreamUtils.reactiveSeq(StreamUtils.batchWhile(this.stream, predicate.negate(), factory2), this.reversable);
    }

    @Override
    public <C extends Collection<? super T>> ReactiveSeq<C> groupedBySizeAndTime(int size, long time, TimeUnit unit, Supplier<C> factory2) {
        return StreamUtils.reactiveSeq(StreamUtils.batchBySizeAndTime(this.stream, size, time, unit, factory2), this.reversable);
    }

    @Override
    public <C extends Collection<? super T>> ReactiveSeq<C> groupedByTime(long time, TimeUnit unit, Supplier<C> factory2) {
        return StreamUtils.reactiveSeq(StreamUtils.batchByTime(this.stream, time, unit, factory2), this.reversable);
    }

    @Override
    public <C extends Collection<? super T>> ReactiveSeq<C> grouped(int size, Supplier<C> factory2) {
        return StreamUtils.reactiveSeq(StreamUtils.batchBySize(this.stream, size, factory2), this.reversable);
    }

    @Override
    public ReactiveSeq<T> skipLast(int num) {
        return StreamUtils.reactiveSeq(StreamUtils.skipLast(this.stream, num), this.reversable);
    }

    @Override
    public ReactiveSeq<T> limitLast(int num) {
        return StreamUtils.reactiveSeq(StreamUtils.limitLast(this.stream, num), this.reversable);
    }

    @Override
    public ReactiveSeq<T> recover(Function<Throwable, ? extends T> fn) {
        return StreamUtils.reactiveSeq(StreamUtils.recover(this.stream, fn), this.reversable);
    }

    @Override
    public <EX extends Throwable> ReactiveSeq<T> recover(Class<EX> exceptionClass, Function<EX, ? extends T> fn) {
        return StreamUtils.reactiveSeq(StreamUtils.recover(this.stream, exceptionClass, fn), this.reversable);
    }

    @Override
    public <R1, R2, R> ReactiveSeq<R> forEach3(Function<? super T, ? extends BaseStream<R1, ?>> stream1, Function<? super T, Function<? super R1, ? extends BaseStream<R2, ?>>> stream2, Function<? super T, Function<? super R1, Function<? super R2, ? extends R>>> yieldingFunction) {
        return (ReactiveSeq)For.stream(this).stream(u -> (BaseStream)stream1.apply(u)).stream(u -> r1 -> (BaseStream)((Function)stream2.apply(u)).apply(r1)).yield(yieldingFunction).unwrap();
    }

    @Override
    public <R1, R2, R> ReactiveSeq<R> forEach3(Function<? super T, ? extends BaseStream<R1, ?>> stream1, Function<? super T, Function<? super R1, ? extends BaseStream<R2, ?>>> stream2, Function<? super T, Function<? super R1, Function<? super R2, Boolean>>> filterFunction, Function<? super T, Function<? super R1, Function<? super R2, ? extends R>>> yieldingFunction) {
        return (ReactiveSeq)For.stream(this).stream(u -> (BaseStream)stream1.apply(u)).stream(u -> r1 -> (BaseStream)((Function)stream2.apply(u)).apply(r1)).filter(filterFunction).yield(yieldingFunction).unwrap();
    }

    @Override
    public <R1, R> ReactiveSeq<R> forEach2(Function<? super T, ? extends BaseStream<R1, ?>> stream1, Function<? super T, Function<? super R1, ? extends R>> yieldingFunction) {
        return (ReactiveSeq)For.stream(this).stream(u -> (BaseStream)stream1.apply(u)).yield(yieldingFunction).unwrap();
    }

    @Override
    public <R1, R> ReactiveSeq<R> forEach2(Function<? super T, ? extends BaseStream<R1, ?>> stream1, Function<? super T, Function<? super R1, Boolean>> filterFunction, Function<? super T, Function<? super R1, ? extends R>> yieldingFunction) {
        return (ReactiveSeq)For.stream(this).stream(u -> (BaseStream)stream1.apply(u)).filter(filterFunction).yield(yieldingFunction).unwrap();
    }

    @Override
    public <X extends Throwable> Subscription forEachX(long numberOfElements, Consumer<? super T> consumer) {
        return StreamUtils.forEachX(this, numberOfElements, consumer);
    }

    @Override
    public <X extends Throwable> Subscription forEachXWithError(long numberOfElements, Consumer<? super T> consumer, Consumer<? super Throwable> consumerError) {
        return StreamUtils.forEachXWithError(this, numberOfElements, consumer, consumerError);
    }

    @Override
    public <X extends Throwable> Subscription forEachXEvents(long numberOfElements, Consumer<? super T> consumer, Consumer<? super Throwable> consumerError, Runnable onComplete) {
        return StreamUtils.forEachXEvents(this, numberOfElements, consumer, consumerError, onComplete);
    }

    @Override
    public <X extends Throwable> void forEachWithError(Consumer<? super T> consumerElement, Consumer<? super Throwable> consumerError) {
        StreamUtils.forEachWithError(this, consumerElement, consumerError);
    }

    @Override
    public <X extends Throwable> void forEachEvent(Consumer<? super T> consumerElement, Consumer<? super Throwable> consumerError, Runnable onComplete) {
        StreamUtils.forEachEvent(this, consumerElement, consumerError, onComplete);
    }

    @Override
    public HotStream<T> primedHotStream(Executor e) {
        return StreamUtils.primedHotStream(this, e);
    }

    @Override
    public PausableHotStream<T> pausableHotStream(Executor e) {
        return StreamUtils.pausableHotStream(this, e);
    }

    @Override
    public PausableHotStream<T> primedPausableHotStream(Executor e) {
        return StreamUtils.primedPausableHotStream(this, e);
    }

    public String format() {
        return Seq.seq(this.stream).format();
    }

    @Override
    public Collectable<T> collectable() {
        return Seq.seq(this.stream);
    }

    @Override
    public <T> ReactiveSeq<T> unitIterator(Iterator<T> it) {
        return ReactiveSeq.fromIterator(it);
    }

    @Override
    public ReactiveSeq<T> append(T value) {
        if (value instanceof Stream) {
            return this.appendStream((Stream)value);
        }
        return this.append(new Object[]{value});
    }

    @Override
    public ReactiveSeq<T> prepend(T value) {
        if (value instanceof Stream) {
            return this.prependStream((Stream)value);
        }
        return this.prepend(new Object[]{value});
    }
}

