/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.react.stream;

import com.aol.cyclops.data.async.Queue;
import com.aol.cyclops.react.async.subscription.Continueable;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class InfiniteClosingSpliterator<T>
implements Spliterator<T> {
    private long estimate;
    final Supplier<T> s;
    private final Continueable subscription;
    private final Queue queue;

    protected InfiniteClosingSpliterator(long estimate, Supplier<T> s, Continueable subscription, Queue queue) {
        this.estimate = estimate;
        this.s = s;
        this.subscription = subscription;
        this.queue = queue;
        this.subscription.addQueue(queue);
    }

    public InfiniteClosingSpliterator(long estimate, Supplier<T> s, Continueable subscription) {
        this.estimate = estimate;
        this.s = s;
        this.subscription = subscription;
        this.queue = null;
    }

    @Override
    public long estimateSize() {
        return this.estimate;
    }

    @Override
    public int characteristics() {
        return 1024;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        try {
            action.accept(this.s.get());
            return !this.subscription.closed();
        }
        catch (Queue.ClosedQueueException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Spliterator<T> trySplit() {
        return new InfiniteClosingSpliterator<T>(this.estimate >>>= 1, this.s, this.subscription, this.queue);
    }
}

