/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.matcher2;

import com.aol.cyclops.control.Maybe;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.internal.matcher2.Case;
import com.aol.cyclops.internal.matcher2.Cases;
import com.aol.cyclops.internal.matcher2.Extractor;
import com.aol.cyclops.internal.matcher2.Extractors;
import com.aol.cyclops.internal.matcher2.SeqUtils;
import com.aol.cyclops.types.Decomposable;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jooq.lambda.tuple.Tuple;

public class PatternMatcher
implements Function {
    private final Cases cases;

    public PatternMatcher() {
        this.cases = Cases.of(new Case[0]);
    }

    public <T, X> Function<T, X> asUnwrappedFunction() {
        return this.cases.asUnwrappedFunction();
    }

    public Maybe<Object> apply(Object t) {
        return this.match(t);
    }

    public <R> Maybe<R> match(Object ... t) {
        return this.cases.match(t);
    }

    public <R> Maybe<R> unapply(Decomposable t) {
        return this.cases.unapply(t);
    }

    public <R> Maybe<R> match(Object t) {
        return this.cases.match(t);
    }

    private Function extractorAction(Extractor extractor, Function action) {
        if (extractor == null) {
            return action;
        }
        return input -> action.apply(extractor.apply(input));
    }

    public <T, V, X> PatternMatcher inCaseOfManyType(Predicate master, Function<? super T, ? extends X> a, Predicate<V> ... predicates) {
        ReactiveSeq pred = ReactiveSeq.of(predicates);
        return this.inCaseOf(it -> master.test(it) && SeqUtils.seq(Extractors.decompose().apply(it)).zip(pred, (a1, b1) -> Tuple.tuple((Object)a1, (Object)b1)).map(t -> ((Predicate)t.v2).test(t.v1)).allMatch(v -> v == true), a);
    }

    private List wrapInList(Object a) {
        if (a instanceof List) {
            return (List)a;
        }
        return Arrays.asList(a);
    }

    public <V, X> PatternMatcher inCaseOf(Predicate<V> match, Function<? super V, ? extends X> a) {
        return this.inCaseOfThenExtract(match, a, null);
    }

    public <R, T, X> PatternMatcher inCaseOfThenExtract(Predicate<T> match, Function<? super R, ? extends X> a, Extractor<T, R> extractor) {
        return this.withCases(this.cases.append(this.index(), Case.of(match, this.extractorAction(extractor, a))));
    }

    private int index() {
        return this.cases.size();
    }

    @ConstructorProperties(value={"cases"})
    public PatternMatcher(Cases cases) {
        this.cases = cases;
    }

    public PatternMatcher withCases(Cases cases) {
        return this.cases == cases ? this : new PatternMatcher(cases);
    }

    public Cases getCases() {
        return this.cases;
    }
}

