/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.matcher2;

import com.aol.cyclops.control.FluentFunctions;
import com.aol.cyclops.control.Maybe;
import com.aol.cyclops.internal.invokedynamic.ReflectionCache;
import com.aol.cyclops.internal.matcher2.AsDecomposable;
import com.aol.cyclops.internal.matcher2.Extractor;
import com.aol.cyclops.types.Decomposable;
import java.util.Optional;

public class Extractors {
    public static final <T, R> Extractor<T, R> decompose() {
        return input -> {
            if (input instanceof Decomposable) {
                return ((Decomposable)input).unapply();
            }
            if (input instanceof Iterable) {
                return input;
            }
            if (input instanceof Optional) {
                return Maybe.fromOptional((Optional)input);
            }
            return input;
        };
    }

    public static final <T, R> Extractor<T, R> decomposeCoerced() {
        return input -> {
            if (input instanceof Decomposable) {
                return ((Decomposable)input).unapply();
            }
            if (input instanceof Iterable) {
                return input;
            }
            if (input instanceof Optional) {
                return Maybe.fromOptional((Optional)input);
            }
            return ReflectionCache.getUnapplyMethod(input.getClass()).map(FluentFunctions.ofChecked(m -> m.invoke(input, new Object[0]))).orElse(AsDecomposable.asDecomposable(input).unapply());
        };
    }
}

