/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.matcher2;

import com.aol.cyclops.internal.matcher2.ActiveCase;
import com.aol.cyclops.internal.matcher2.EmptyCase;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jooq.lambda.tuple.Tuple;
import org.jooq.lambda.tuple.Tuple2;

public interface Case<T, R> {
    public static final Case empty = new EmptyCase();

    public boolean isEmpty();

    public Tuple2<Predicate<? super T>, Function<? super T, ? extends R>> get();

    default public Predicate<? super T> getPredicate() {
        return (Predicate)this.get().v1;
    }

    default public Function<? super T, ? extends R> getAction() {
        return (Function)this.get().v2;
    }

    default public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    default public Optional<R> match(T value) {
        if (((Predicate)this.get().v1).test(value)) {
            return Optional.of(((Function)this.get().v2).apply(value));
        }
        return Optional.empty();
    }

    default public CompletableFuture<Optional<R>> matchAsync(Executor executor, T value) {
        return CompletableFuture.supplyAsync(() -> this.match(value), executor);
    }

    public static <T, R> Case<T, R> of(Predicate<? super T> predicate, Function<? super T, ? extends R> action) {
        return new ActiveCase(Tuple.tuple(predicate, action));
    }

    public static <T, R> Case<T, R> of(Tuple2<Predicate<? super T>, Function<? super T, ? extends R>> pattern) {
        return new ActiveCase<T, R>(pattern);
    }

    public static <T, R, X extends Function<T, R>> Case<T, R> empty() {
        return empty;
    }
}

