/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.comprehensions;

import com.aol.cyclops.internal.comprehensions.comprehenders.Comprehenders;
import com.aol.cyclops.internal.comprehensions.comprehenders.InvokeDynamicComprehender;
import com.aol.cyclops.internal.comprehensions.comprehenders.MaterializedList;
import com.aol.cyclops.internal.comprehensions.converters.MonadicConverters;
import com.aol.cyclops.types.extensability.Comprehender;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jooq.lambda.tuple.Tuple2;
import org.pcollections.ConsPStack;
import org.pcollections.HashTreePMap;
import org.pcollections.PMap;
import org.pcollections.PStack;

public interface ComprehensionsModule {

    public static class Foreach<T> {
        private PStack<Expansion> generators = ConsPStack.empty();

        public T yield(ExecutionState<T> state) {
            Expansion head = (Expansion)this.generators.get(0);
            return new Yield((List<Expansion>)this.generators).process(state.contextualExecutor, (PMap<String, Object>)HashTreePMap.empty(), head.getFunction().executeAndSetContext(HashTreePMap.empty()), head.getName(), 1);
        }

        void addExpansion(Expansion g) {
            this.generators = this.generators.plus(this.generators.size(), (Object)g);
        }

        public static <T> T foreach(final Function<ComprehensionData<?, T>, T> fn) {
            ContextualExecutor comprehension = new ContextualExecutor<T>(new Foreach<T>()){

                @Override
                public T execute() {
                    return fn.apply(new ComprehensionData(new ExecutionState(this)));
                }
            };
            return comprehension.executeAndSetContext(new Foreach<T>());
        }
    }

    public static class Yield<T> {
        private final List<Expansion> expansions;
        private final MonadicConverters converters = new MonadicConverters();

        T process(ContextualExecutor yieldExecutor, PMap<String, Object> context, Object currentExpansionUnwrapped, String lastExpansionName, int index) {
            Tuple2 comprehender = this.selectComprehender(currentExpansionUnwrapped).orElseGet(() -> this.selectComprehender(this.converters.convertToMonadicForm(currentExpansionUnwrapped)).orElse((Tuple2<Comprehender, Object>)new Tuple2((Object)new InvokeDynamicComprehender(Optional.ofNullable(currentExpansionUnwrapped).map(Object::getClass)), currentExpansionUnwrapped)));
            if (this.expansions.size() == index) {
                return (T)((Comprehender)comprehender.v1).map(comprehender.v2, it -> yieldExecutor.executeAndSetContext(context.plus((Object)lastExpansionName, it)));
            }
            Expansion head = this.expansions.get(index);
            if (head instanceof Filter) {
                Object s = ((Comprehender)comprehender.v1).filter(comprehender.v2, it -> (Boolean)head.getFunction().executeAndSetContext(context.plus((Object)lastExpansionName, it)));
                return this.process(yieldExecutor, context, s, lastExpansionName, index + 1);
            }
            Object result = ((Comprehender)comprehender.v1).executeflatMap(comprehender.v2, it -> {
                PMap newMap = context.plus((Object)lastExpansionName, it);
                return this.process(yieldExecutor, (PMap<String, Object>)newMap, head.getFunction().executeAndSetContext(newMap), head.getName(), index + 1);
            });
            return (T)((Comprehender)comprehender.v1).executeflatMap(result, a -> this.takeFirst((Comprehender)comprehender.v1, a));
        }

        private <T> T takeFirst(Comprehender comp, Object o) {
            if (o instanceof MaterializedList) {
                if (((List)o).size() == 0) {
                    return comp.empty();
                }
                return comp.of(((List)o).get(0));
            }
            return comp.of(o);
        }

        private Optional<Tuple2<Comprehender, Object>> selectComprehender(Object structure) {
            if (structure == null) {
                return Optional.empty();
            }
            return new Comprehenders().getRegisteredComprehenders().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(structure.getClass())).map(e -> (Comprehender)e.getValue()).map(v -> new Tuple2(v, structure)).findFirst();
        }

        @ConstructorProperties(value={"expansions"})
        public Yield(List<Expansion> expansions) {
            this.expansions = expansions;
        }
    }

    public static class Filter
    extends Expansion {
        public Filter(String name, ContextualExecutor<Object> func) {
            super(name, func);
        }
    }

    public static final class ExecutionState<T> {
        public final ContextualExecutor<T> contextualExecutor;

        @ConstructorProperties(value={"contextualExecutor"})
        public ExecutionState(ContextualExecutor<T> contextualExecutor) {
            this.contextualExecutor = contextualExecutor;
        }
    }

    public static class Expansion {
        private final String name;
        private final ContextualExecutor<Object> function;

        public String getName() {
            return this.name;
        }

        public ContextualExecutor<Object> getFunction() {
            return this.function;
        }

        @ConstructorProperties(value={"name", "function"})
        public Expansion(String name, ContextualExecutor<Object> function) {
            this.name = name;
            this.function = function;
        }
    }

    public static abstract class ContextualExecutor<T> {
        private volatile Object context;

        public T executeAndSetContext(Object context) {
            this.context = context;
            return this.execute();
        }

        public abstract T execute();

        @ConstructorProperties(value={"context"})
        public ContextualExecutor(Object context) {
            this.context = context;
        }

        public Object getContext() {
            return this.context;
        }
    }

    public static interface InternalSupplier
    extends Supplier<Object> {
    }

    public static class ComprehensionData<T, R> {
        private final BaseComprehensionData data;

        ComprehensionData(ExecutionState state) {
            this.data = new BaseComprehensionData(state);
        }

        public ComprehensionData<T, R> filter(Supplier<Boolean> s) {
            this.data.guardInternal(s);
            return this;
        }

        public R yield(Supplier<R> s) {
            return this.data.yieldInternal(s);
        }

        public T $(String name) {
            return this.data.$Internal(name);
        }

        public ComprehensionData<T, R> $(String name, Object f) {
            this.data.$Internal(name, f);
            return this;
        }

        public ComprehensionData<T, R> $(String name, InternalSupplier f) {
            this.data.$Internal(name, f);
            return this;
        }
    }

    public static final class BaseComprehensionData {
        private ContextualExecutor<Object> delegate;
        private ContextualExecutor<Object> currentContext;

        public BaseComprehensionData(ExecutionState state) {
            this.delegate = state.contextualExecutor;
        }

        public BaseComprehensionData guardInternal(final Supplier<Boolean> s) {
            ((Foreach)this.delegate.getContext()).addExpansion(new Filter("guard", new ContextualExecutor(this.delegate.getContext()){

                public Object execute() {
                    currentContext = this;
                    return s.get();
                }
            }));
            return this;
        }

        public <R> R yieldInternal(final Supplier s) {
            return (R)((Foreach)this.delegate.getContext()).yield(new ExecutionState(new ContextualExecutor(this.delegate.getContext()){

                public Object execute() {
                    currentContext = this;
                    return s.get();
                }
            }));
        }

        public <T> T $Internal(String property) {
            Object delegate = this.currentContext.getContext();
            return (T)((Map)delegate).get(property);
        }

        public BaseComprehensionData $Internal(String name, final Object f) {
            Expansion g = new Expansion(name, new ContextualExecutor(this){

                public Object execute() {
                    currentContext = this;
                    if (f instanceof InternalSupplier) {
                        return ((InternalSupplier)f).get();
                    }
                    return f;
                }
            });
            ((Foreach)this.delegate.getContext()).addExpansion(g);
            return this;
        }
    }
}

