/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.control.AnyM;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.data.Mutable;
import com.aol.cyclops.internal.monads.ComprehenderSelector;
import com.aol.cyclops.internal.monads.MonadWrapper;
import com.aol.cyclops.internal.stream.SeqUtils;
import com.aol.cyclops.types.anyM.AnyMSeq;
import com.aol.cyclops.types.anyM.AnyMValue;
import com.aol.cyclops.types.extensability.Comprehender;
import com.aol.cyclops.types.extensability.ValueComprehender;
import com.aol.cyclops.types.mixins.WrappingFilterable;
import com.aol.cyclops.types.mixins.WrappingFunctor;
import com.aol.cyclops.util.stream.Streamable;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface Monad<T>
extends WrappingFunctor<T>,
WrappingFilterable<T> {
    public <T> Monad<T> withMonad(Object var1);

    @Override
    default public <T> Monad<T> withFunctor(T functor) {
        return this.withMonad(functor);
    }

    @Override
    default public Object getFunctor() {
        return this.unwrap();
    }

    default public <NT> Monad<NT> streamedMonad() {
        Stream<Integer> stream = Stream.of(Integer.valueOf(1));
        Monad<Object> r = this.withMonad((Stream)new ComprehenderSelector().selectComprehender(stream).executeflatMap(stream, i -> this.unwrap()));
        return r.bind(e -> e);
    }

    default public Stream<T> stream() {
        if (this.unwrap() instanceof Stream) {
            return (Stream)this.unwrap();
        }
        if (this.unwrap() instanceof Iterable) {
            return StreamSupport.stream(((Iterable)this.unwrap()).spliterator(), false);
        }
        Stream<Integer> stream = Stream.of(Integer.valueOf(1));
        return (Stream)this.withMonad((Stream)new ComprehenderSelector().selectComprehender(stream).executeflatMap(stream, i -> this.unwrap())).unwrap();
    }

    default public Monad<T> cycle(int times) {
        return Monad.fromStream(SeqUtils.cycle(times, Streamable.fromStream(this.stream())));
    }

    @Override
    default public WrappingFilterable<T> withFilterable(T filter) {
        return this.withMonad(filter);
    }

    @Override
    default public Object getFilterable() {
        return this.unwrap();
    }

    @Override
    default public Monad<T> filter(Predicate<? super T> fn) {
        return (Monad)WrappingFilterable.super.filter(fn);
    }

    @Override
    default public <R> Monad<R> map(Function<? super T, ? extends R> fn) {
        return (Monad)WrappingFunctor.super.map((Function)fn);
    }

    @Override
    default public Monad<T> peek(Consumer<? super T> c) {
        return (Monad)WrappingFunctor.super.peek((Consumer)c);
    }

    default public <R> Monad<R> bind(Function<? super T, ?> fn) {
        return this.withMonad(new ComprehenderSelector().selectComprehender(this.unwrap()).executeflatMap(this.unwrap(), fn));
    }

    default public <R> Monad<R> liftAndBind(Function<? super T, ?> fn) {
        return this.withMonad(new ComprehenderSelector().selectComprehender(this.unwrap()).liftAndFlatMap(this.unwrap(), fn));
    }

    default public <T1> Monad<T1> flatten() {
        return this.bind(t -> t instanceof AnyM ? ((AnyM)t).unwrap() : t);
    }

    default public <R> Monad<R> flatMapToStream(Function<Object, ? extends Stream<? extends R>> fn) {
        Stream<Integer> stream = Stream.of(Integer.valueOf(1));
        Monad<Object> r = this.withMonad((Stream)new ComprehenderSelector().selectComprehender(stream).executeflatMap(stream, i -> this.unwrap()));
        return r.bind(e -> e);
    }

    default public <T> Object unit(T value) {
        return new ComprehenderSelector().selectComprehender(this.unwrap()).of(value);
    }

    default public T get() {
        final Mutable<Object> captured = Mutable.of(null);
        Comprehender c = new ComprehenderSelector().selectComprehender(this.unwrap());
        c.resolveForCrossTypeFlatMap(new ValueComprehender(){

            @Override
            public Object of(Object o) {
                return captured.set(o);
            }

            @Override
            public Object empty() {
                throw new NoSuchElementException();
            }

            @Override
            public Object map(Object t, Function fn) {
                return null;
            }

            @Override
            public Object flatMap(Object t, Function fn) {
                return null;
            }

            @Override
            public Class getTargetClass() {
                return null;
            }
        }, this.unwrap());
        return captured.get();
    }

    @Override
    public Object unwrap();

    public <T> AnyMValue<T> anyMValue();

    public <T> AnyMSeq<T> anyMSeq();

    public <T> ReactiveSeq<T> sequence();

    public static <T> Monad<T> of(Object o) {
        return new MonadWrapper(o);
    }

    default public Monad<T> empty() {
        return (Monad)new ComprehenderSelector().selectComprehender(this.unwrap()).empty();
    }

    public static <T> Monad<T> fromStream(Stream<T> monad) {
        return new MonadWrapper(monad);
    }

    default public <R> Monad<R> applyM(Monad<Function<? super T, ? extends R>> fn) {
        return this.bind(v -> fn.map((T innerFn) -> innerFn.apply(v)).unwrap());
    }

    default public <R> Monad<R> replicateM(int times) {
        return new MonadWrapper(this.unit(1)).flatten().bind(v -> this.cycle(times).unwrap());
    }

    default public <R> Monad<R> reduceM(Monoid<R> reducer) {
        return new MonadWrapper(Monad.fromStream(this.stream()).map(value -> new ComprehenderSelector().selectComprehender(reducer.zero().getClass()).of(value)).sequence().reduce(reducer));
    }
}

