/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.data.collections.extensions.standard;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.control.Matchable;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.Trampoline;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.data.collections.extensions.standard.MutableCollectionX;
import com.aol.cyclops.data.collections.extensions.standard.QueueXImpl;
import com.aol.cyclops.util.stream.StreamUtils;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple2;
import org.jooq.lambda.tuple.Tuple3;
import org.jooq.lambda.tuple.Tuple4;
import org.reactivestreams.Publisher;

public interface QueueX<T>
extends Queue<T>,
MutableCollectionX<T> {
    public static <T> Collector<T, ?, Queue<T>> defaultCollector() {
        return Collectors.toCollection(() -> new LinkedList());
    }

    public static <T> QueueX<T> empty() {
        return QueueX.fromIterable((Queue)QueueX.defaultCollector().supplier().get());
    }

    @SafeVarargs
    public static <T> QueueX<T> of(T ... values) {
        Queue res = (Queue)QueueX.defaultCollector().supplier().get();
        for (T v : values) {
            res.add(v);
        }
        return QueueX.fromIterable(res);
    }

    public static <T> QueueX<T> singleton(T value) {
        return QueueX.of(value);
    }

    public static <T> QueueX<T> fromPublisher(Publisher<? extends T> publisher) {
        return ReactiveSeq.fromPublisher(publisher).toQueueX();
    }

    public static <T> QueueX<T> fromIterable(Iterable<T> it) {
        return QueueX.fromIterable(QueueX.defaultCollector(), it);
    }

    public static <T> QueueX<T> fromIterable(Collector<T, ?, Queue<T>> collector, Iterable<T> it) {
        if (it instanceof QueueX) {
            return (QueueX)it;
        }
        if (it instanceof Deque) {
            return new QueueXImpl<T>((Queue)it, collector);
        }
        return new QueueXImpl<T>(StreamUtils.stream(it).collect(collector), collector);
    }

    public <T> Collector<T, ?, Queue<T>> getCollector();

    @Override
    default public QueueX<T> toQueueX() {
        return this;
    }

    @Override
    default public <T1> QueueX<T1> from(Collection<T1> c) {
        return QueueX.fromIterable(this.getCollector(), c);
    }

    @Override
    default public <X> QueueX<X> fromStream(Stream<X> stream) {
        return new QueueXImpl<T>(stream.collect(this.getCollector()), this.getCollector());
    }

    @Override
    default public QueueX<T> combine(BiPredicate<? super T, ? super T> predicate, BinaryOperator<T> op) {
        return (QueueX)MutableCollectionX.super.combine((BiPredicate)predicate, (BinaryOperator)op);
    }

    @Override
    default public <R> QueueX<R> unit(Collection<R> col) {
        return QueueX.fromIterable(col);
    }

    @Override
    default public <R> QueueX<R> unit(R value) {
        return QueueX.singleton(value);
    }

    @Override
    default public <R> QueueX<R> unitIterator(Iterator<R> it) {
        return QueueX.fromIterable(() -> it);
    }

    @Override
    default public ReactiveSeq<T> stream() {
        return ReactiveSeq.fromIterable(this);
    }

    @Override
    default public QueueX<T> reverse() {
        return (QueueX)MutableCollectionX.super.reverse();
    }

    @Override
    default public QueueX<T> filter(Predicate<? super T> pred) {
        return (QueueX)MutableCollectionX.super.filter((Predicate)pred);
    }

    @Override
    default public <R> QueueX<R> map(Function<? super T, ? extends R> mapper) {
        return (QueueX)MutableCollectionX.super.map((Function)mapper);
    }

    @Override
    default public <R> QueueX<R> flatMap(Function<? super T, ? extends Iterable<? extends R>> mapper) {
        return (QueueX)MutableCollectionX.super.flatMap(mapper);
    }

    @Override
    default public QueueX<T> limit(long num) {
        return (QueueX)MutableCollectionX.super.limit(num);
    }

    @Override
    default public QueueX<T> skip(long num) {
        return (QueueX)MutableCollectionX.super.skip(num);
    }

    @Override
    default public QueueX<T> takeWhile(Predicate<? super T> p) {
        return (QueueX)MutableCollectionX.super.takeWhile((Predicate)p);
    }

    @Override
    default public QueueX<T> dropWhile(Predicate<? super T> p) {
        return (QueueX)MutableCollectionX.super.dropWhile((Predicate)p);
    }

    @Override
    default public QueueX<T> takeRight(int num) {
        return (QueueX)MutableCollectionX.super.takeRight(num);
    }

    @Override
    default public QueueX<T> dropRight(int num) {
        return (QueueX)MutableCollectionX.super.dropRight(num);
    }

    @Override
    default public QueueX<T> takeUntil(Predicate<? super T> p) {
        return (QueueX)MutableCollectionX.super.takeUntil((Predicate)p);
    }

    @Override
    default public QueueX<T> dropUntil(Predicate<? super T> p) {
        return (QueueX)MutableCollectionX.super.dropUntil((Predicate)p);
    }

    @Override
    default public <R> QueueX<R> trampoline(Function<? super T, ? extends Trampoline<? extends R>> mapper) {
        return (QueueX)MutableCollectionX.super.trampoline((Function)mapper);
    }

    @Override
    default public QueueX<T> slice(long from, long to) {
        return (QueueX)MutableCollectionX.super.slice(from, to);
    }

    @Override
    default public <U extends Comparable<? super U>> QueueX<T> sorted(Function<? super T, ? extends U> function) {
        return (QueueX)MutableCollectionX.super.sorted((Function)function);
    }

    @Override
    default public QueueX<ListX<T>> grouped(int groupSize) {
        return (QueueX)MutableCollectionX.super.grouped(groupSize);
    }

    @Override
    default public <K, A, D> QueueX<Tuple2<K, D>> grouped(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return (QueueX)MutableCollectionX.super.grouped((Function)classifier, (Collector)downstream);
    }

    @Override
    default public <K> QueueX<Tuple2<K, Seq<T>>> grouped(Function<? super T, ? extends K> classifier) {
        return (QueueX)MutableCollectionX.super.grouped((Function)classifier);
    }

    @Override
    default public <U> QueueX<Tuple2<T, U>> zip(Iterable<? extends U> other) {
        return (QueueX)MutableCollectionX.super.zip((Iterable)other);
    }

    @Override
    default public <U, R> QueueX<R> zip(Iterable<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return (QueueX)MutableCollectionX.super.zip((Iterable)other, (BiFunction)zipper);
    }

    @Override
    default public QueueX<ListX<T>> sliding(int windowSize) {
        return (QueueX)MutableCollectionX.super.sliding(windowSize);
    }

    @Override
    default public QueueX<ListX<T>> sliding(int windowSize, int increment) {
        return (QueueX)MutableCollectionX.super.sliding(windowSize, increment);
    }

    @Override
    default public QueueX<T> scanLeft(Monoid<T> monoid) {
        return (QueueX)MutableCollectionX.super.scanLeft((Monoid)monoid);
    }

    @Override
    default public <U> QueueX<U> scanLeft(U seed, BiFunction<? super U, ? super T, ? extends U> function) {
        return (QueueX)MutableCollectionX.super.scanLeft((Object)seed, (BiFunction)function);
    }

    @Override
    default public QueueX<T> scanRight(Monoid<T> monoid) {
        return (QueueX)MutableCollectionX.super.scanRight((Monoid)monoid);
    }

    @Override
    default public <U> QueueX<U> scanRight(U identity, BiFunction<? super T, ? super U, ? extends U> combiner) {
        return (QueueX)MutableCollectionX.super.scanRight((Object)identity, (BiFunction)combiner);
    }

    @Override
    default public QueueX<T> plus(T e) {
        this.add(e);
        return this;
    }

    @Override
    default public QueueX<T> plusAll(Collection<? extends T> list) {
        this.addAll(list);
        return this;
    }

    @Override
    default public QueueX<T> minus(Object e) {
        this.remove(e);
        return this;
    }

    @Override
    default public QueueX<T> minusAll(Collection<?> list) {
        this.removeAll(list);
        return this;
    }

    @Override
    default public QueueX<T> peek(Consumer<? super T> c) {
        return (QueueX)MutableCollectionX.super.peek((Consumer)c);
    }

    @Override
    default public <R> QueueX<R> patternMatch(Function<Matchable.CheckValue1<T, R>, Matchable.CheckValue1<T, R>> case1, Supplier<? extends R> otherwise) {
        return (QueueX)MutableCollectionX.super.patternMatch((Function)case1, (Supplier)otherwise);
    }

    @Override
    default public <U> QueueX<U> cast(Class<? extends U> type) {
        return (QueueX)MutableCollectionX.super.cast((Class)type);
    }

    @Override
    default public QueueX<T> cycle(int times) {
        return (QueueX)MutableCollectionX.super.cycle(times);
    }

    @Override
    default public QueueX<T> cycle(Monoid<T> m, int times) {
        return (QueueX)MutableCollectionX.super.cycle((Monoid)m, times);
    }

    @Override
    default public QueueX<T> cycleWhile(Predicate<? super T> predicate) {
        return (QueueX)MutableCollectionX.super.cycleWhile((Predicate)predicate);
    }

    @Override
    default public QueueX<T> cycleUntil(Predicate<? super T> predicate) {
        return (QueueX)MutableCollectionX.super.cycleUntil((Predicate)predicate);
    }

    @Override
    default public <U> QueueX<Tuple2<T, U>> zipStream(Stream<? extends U> other) {
        return (QueueX)MutableCollectionX.super.zipStream((Stream)other);
    }

    @Override
    default public <U> QueueX<Tuple2<T, U>> zip(Seq<? extends U> other) {
        return (QueueX)MutableCollectionX.super.zip((Seq)other);
    }

    @Override
    default public <S, U> QueueX<Tuple3<T, S, U>> zip3(Stream<? extends S> second, Stream<? extends U> third) {
        return (QueueX)MutableCollectionX.super.zip3((Stream)second, (Stream)third);
    }

    @Override
    default public <T2, T3, T4> QueueX<Tuple4<T, T2, T3, T4>> zip4(Stream<T2> second, Stream<T3> third, Stream<T4> fourth) {
        return (QueueX)MutableCollectionX.super.zip4((Stream)second, (Stream)third, (Stream)fourth);
    }

    @Override
    default public QueueX<Tuple2<T, Long>> zipWithIndex() {
        return (QueueX)MutableCollectionX.super.zipWithIndex();
    }

    @Override
    default public QueueX<T> distinct() {
        return (QueueX)MutableCollectionX.super.distinct();
    }

    @Override
    default public QueueX<T> sorted() {
        return (QueueX)MutableCollectionX.super.sorted();
    }

    @Override
    default public QueueX<T> sorted(Comparator<? super T> c) {
        return (QueueX)MutableCollectionX.super.sorted((Comparator)c);
    }

    @Override
    default public QueueX<T> skipWhile(Predicate<? super T> p) {
        return (QueueX)MutableCollectionX.super.skipWhile((Predicate)p);
    }

    @Override
    default public QueueX<T> skipUntil(Predicate<? super T> p) {
        return (QueueX)MutableCollectionX.super.skipUntil((Predicate)p);
    }

    @Override
    default public QueueX<T> limitWhile(Predicate<? super T> p) {
        return (QueueX)MutableCollectionX.super.limitWhile((Predicate)p);
    }

    @Override
    default public QueueX<T> limitUntil(Predicate<? super T> p) {
        return (QueueX)MutableCollectionX.super.limitUntil((Predicate)p);
    }

    @Override
    default public QueueX<T> intersperse(T value) {
        return (QueueX)MutableCollectionX.super.intersperse((Object)value);
    }

    @Override
    default public QueueX<T> shuffle() {
        return (QueueX)MutableCollectionX.super.shuffle();
    }

    @Override
    default public QueueX<T> skipLast(int num) {
        return (QueueX)MutableCollectionX.super.skipLast(num);
    }

    @Override
    default public QueueX<T> limitLast(int num) {
        return (QueueX)MutableCollectionX.super.limitLast(num);
    }

    @Override
    default public QueueX<T> onEmpty(T value) {
        return (QueueX)MutableCollectionX.super.onEmpty((Object)value);
    }

    @Override
    default public QueueX<T> onEmptyGet(Supplier<? extends T> supplier) {
        return (QueueX)MutableCollectionX.super.onEmptyGet((Supplier)supplier);
    }

    @Override
    default public <X extends Throwable> QueueX<T> onEmptyThrow(Supplier<? extends X> supplier) {
        return (QueueX)MutableCollectionX.super.onEmptyThrow((Supplier)supplier);
    }

    @Override
    default public QueueX<T> shuffle(Random random) {
        return (QueueX)MutableCollectionX.super.shuffle(random);
    }

    @Override
    default public <U> QueueX<U> ofType(Class<? extends U> type) {
        return (QueueX)MutableCollectionX.super.ofType((Class)type);
    }

    @Override
    default public QueueX<T> filterNot(Predicate<? super T> fn) {
        return (QueueX)MutableCollectionX.super.filterNot((Predicate)fn);
    }

    @Override
    default public QueueX<T> notNull() {
        return (QueueX)MutableCollectionX.super.notNull();
    }

    @Override
    default public QueueX<T> removeAll(Stream<? extends T> stream) {
        return (QueueX)MutableCollectionX.super.removeAll((Stream)stream);
    }

    @Override
    default public QueueX<T> removeAll(Iterable<? extends T> it) {
        return (QueueX)MutableCollectionX.super.removeAll((Iterable)it);
    }

    @Override
    default public QueueX<T> removeAll(T ... values) {
        return (QueueX)MutableCollectionX.super.removeAll((Object[])values);
    }

    @Override
    default public QueueX<T> retainAll(Iterable<? extends T> it) {
        return (QueueX)MutableCollectionX.super.retainAll((Iterable)it);
    }

    @Override
    default public QueueX<T> retainAll(Stream<? extends T> seq) {
        return (QueueX)MutableCollectionX.super.retainAll((Stream)seq);
    }

    @Override
    default public QueueX<T> retainAll(T ... values) {
        return (QueueX)MutableCollectionX.super.retainAll((Object[])values);
    }

    @Override
    default public <C extends Collection<? super T>> QueueX<C> grouped(int size, Supplier<C> supplier) {
        return (QueueX)MutableCollectionX.super.grouped(size, (Supplier)supplier);
    }

    @Override
    default public QueueX<ListX<T>> groupedUntil(Predicate<? super T> predicate) {
        return (QueueX)MutableCollectionX.super.groupedUntil((Predicate)predicate);
    }

    @Override
    default public QueueX<ListX<T>> groupedWhile(Predicate<? super T> predicate) {
        return (QueueX)MutableCollectionX.super.groupedWhile((Predicate)predicate);
    }

    @Override
    default public <C extends Collection<? super T>> QueueX<C> groupedWhile(Predicate<? super T> predicate, Supplier<C> factory2) {
        return (QueueX)MutableCollectionX.super.groupedWhile((Predicate)predicate, (Supplier)factory2);
    }

    @Override
    default public <C extends Collection<? super T>> QueueX<C> groupedUntil(Predicate<? super T> predicate, Supplier<C> factory2) {
        return (QueueX)MutableCollectionX.super.groupedUntil((Predicate)predicate, (Supplier)factory2);
    }

    @Override
    default public QueueX<ListX<T>> groupedStatefullyWhile(BiPredicate<ListX<? super T>, ? super T> predicate) {
        return (QueueX)MutableCollectionX.super.groupedStatefullyWhile((BiPredicate)predicate);
    }

    @Override
    default public QueueX<T> removeAll(Seq<? extends T> stream) {
        return (QueueX)MutableCollectionX.super.removeAll((Seq)stream);
    }

    @Override
    default public QueueX<T> retainAll(Seq<? extends T> stream) {
        return (QueueX)MutableCollectionX.super.retainAll((Seq)stream);
    }
}

