/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.data.collections.extensions.persistent;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.Reducer;
import com.aol.cyclops.control.Matchable;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.Trampoline;
import com.aol.cyclops.data.collections.extensions.CollectionX;
import com.aol.cyclops.data.collections.extensions.FluentCollectionX;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.util.stream.StreamUtils;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple2;
import org.jooq.lambda.tuple.Tuple3;
import org.jooq.lambda.tuple.Tuple4;

public interface PersistentCollectionX<T>
extends FluentCollectionX<T> {
    @Override
    default public ReactiveSeq<T> stream() {
        return ReactiveSeq.fromIterable(this);
    }

    @Override
    default public PersistentCollectionX<T> plusInOrder(T e) {
        return (PersistentCollectionX)FluentCollectionX.super.plusInOrder(e);
    }

    @Override
    public <R> PersistentCollectionX<R> unit(Collection<R> var1);

    public <R> PersistentCollectionX<R> emptyUnit();

    public <T> Reducer<? extends Collection<T>> monoid();

    @Override
    public <T1> PersistentCollectionX<T1> from(Collection<T1> var1);

    @Override
    default public CollectionX<T> reverse() {
        return this.from(this.monoid().mapReduce((Stream)this.stream().reverse()));
    }

    @Override
    default public PersistentCollectionX<T> filter(Predicate<? super T> pred) {
        FluentCollectionX<Object> mapped = this.emptyUnit();
        for (Object value : this) {
            if (!pred.test(value)) continue;
            mapped = mapped.plusInOrder(value);
        }
        return this.unit(mapped);
    }

    @Override
    default public <R> PersistentCollectionX<R> map(Function<? super T, ? extends R> mapper) {
        FluentCollectionX<R> mapped = this.emptyUnit();
        for (Object next : this) {
            mapped = mapped.plusInOrder(mapper.apply(next));
        }
        return this.unit(mapped);
    }

    @Override
    default public <R> PersistentCollectionX<R> flatMap(Function<? super T, ? extends Iterable<? extends R>> mapper) {
        return this.from(this.monoid().mapReduce(this.stream().flatMap(mapper.andThen(StreamUtils::stream))));
    }

    @Override
    default public PersistentCollectionX<T> limit(long num) {
        FluentCollectionX<Object> mapped = this.emptyUnit();
        Iterator it = this.iterator();
        for (long i = 0L; i < num && it.hasNext(); ++i) {
            mapped = mapped.plusInOrder(it.next());
        }
        return mapped;
    }

    @Override
    default public PersistentCollectionX<T> skip(long num) {
        FluentCollectionX<Object> mapped = this.emptyUnit();
        Iterator it = this.iterator();
        for (long i = 0L; i < num && it.hasNext(); ++i) {
            it.next();
        }
        while (it.hasNext()) {
            mapped = mapped.plusInOrder(it.next());
        }
        return mapped;
    }

    @Override
    default public PersistentCollectionX<T> dropRight(int num) {
        return this.from(this.monoid().mapReduce((Stream)((Object)this.stream().skipLast(num))));
    }

    @Override
    default public PersistentCollectionX<T> takeRight(int num) {
        return this.from(this.monoid().mapReduce((Stream)((Object)this.stream().limitLast(num))));
    }

    @Override
    default public PersistentCollectionX<T> takeWhile(Predicate<? super T> p) {
        return this.from(this.monoid().mapReduce((Stream)this.stream().limitWhile(p)));
    }

    @Override
    default public PersistentCollectionX<T> dropWhile(Predicate<? super T> p) {
        return this.from(this.monoid().mapReduce((Stream)this.stream().skipWhile(p)));
    }

    @Override
    default public PersistentCollectionX<T> takeUntil(Predicate<? super T> p) {
        return this.from(this.monoid().mapReduce((Stream)this.stream().limitUntil(p)));
    }

    @Override
    default public PersistentCollectionX<T> dropUntil(Predicate<? super T> p) {
        return this.from(this.monoid().mapReduce((Stream)this.stream().skipUntil(p)));
    }

    @Override
    default public <R> PersistentCollectionX<R> trampoline(Function<? super T, ? extends Trampoline<? extends R>> mapper) {
        return this.map((T in) -> ((Trampoline)mapper.apply(in)).result());
    }

    @Override
    default public PersistentCollectionX<T> slice(long from, long to) {
        return this.from(this.monoid().mapReduce((Stream)this.stream().slice(from, to)));
    }

    @Override
    default public <U extends Comparable<? super U>> PersistentCollectionX<T> sorted(Function<? super T, ? extends U> function) {
        return this.from(this.monoid().mapReduce((Stream)this.stream().sorted(function)));
    }

    @Override
    default public PersistentCollectionX<ListX<T>> grouped(int groupSize) {
        return this.from(this.monoid().mapReduce(this.stream().grouped(groupSize).map(ListX::fromIterable)));
    }

    @Override
    default public <K, A, D> PersistentCollectionX<Tuple2<K, D>> grouped(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return this.from(this.monoid().mapReduce((Stream)this.stream().grouped(classifier, downstream)));
    }

    @Override
    default public <K> PersistentCollectionX<Tuple2<K, Seq<T>>> grouped(Function<? super T, ? extends K> classifier) {
        return this.from(this.monoid().mapReduce((Stream)this.stream().grouped(classifier)));
    }

    @Override
    default public <U> PersistentCollectionX<Tuple2<T, U>> zip(Iterable<? extends U> other) {
        return this.from(this.monoid().mapReduce((Stream)this.stream().zip(other)));
    }

    @Override
    default public <U, R> PersistentCollectionX<R> zip(Iterable<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return this.from(this.monoid().mapReduce((Stream)this.stream().zip(other, zipper)));
    }

    @Override
    default public PersistentCollectionX<ListX<T>> sliding(int windowSize) {
        return this.from(this.monoid().mapReduce((Stream)((Object)this.stream().sliding(windowSize))));
    }

    @Override
    default public PersistentCollectionX<ListX<T>> sliding(int windowSize, int increment) {
        return this.from(this.monoid().mapReduce((Stream)((Object)this.stream().sliding(windowSize, increment))));
    }

    @Override
    default public PersistentCollectionX<T> scanLeft(Monoid<T> monoid) {
        return this.from(this.monoid().mapReduce((Stream)((Object)this.stream().scanLeft(monoid))));
    }

    @Override
    default public PersistentCollectionX<T> scanRight(Monoid<T> monoid) {
        return this.from(this.monoid().mapReduce((Stream)((Object)this.stream().scanRight(monoid))));
    }

    @Override
    default public <U> PersistentCollectionX<U> scanLeft(U seed, BiFunction<? super U, ? super T, ? extends U> function) {
        return this.from(this.monoid().mapReduce((Stream)this.stream().scanLeft(seed, function)));
    }

    @Override
    default public <U> PersistentCollectionX<U> scanRight(U identity, BiFunction<? super T, ? super U, ? extends U> combiner) {
        return this.from(this.monoid().mapReduce((Stream)this.stream().scanRight(identity, combiner)));
    }

    @Override
    default public PersistentCollectionX<T> cycle(int times) {
        return this.from(this.monoid().mapReduce((Stream)((Object)this.stream().cycle(times))));
    }

    @Override
    default public PersistentCollectionX<T> cycle(Monoid<T> m, int times) {
        return this.from(this.monoid().mapReduce((Stream)((Object)this.stream().cycle(m, times))));
    }

    @Override
    default public PersistentCollectionX<T> cycleWhile(Predicate<? super T> predicate) {
        return this.from(this.monoid().mapReduce((Stream)((Object)this.stream().cycleWhile(predicate))));
    }

    @Override
    default public PersistentCollectionX<T> cycleUntil(Predicate<? super T> predicate) {
        return this.from(this.monoid().mapReduce((Stream)((Object)this.stream().cycleUntil(predicate))));
    }

    @Override
    default public <U> PersistentCollectionX<Tuple2<T, U>> zipStream(Stream<? extends U> other) {
        return this.from(this.monoid().mapReduce((Stream)((Object)this.stream().zipStream(other))));
    }

    @Override
    default public <U> PersistentCollectionX<Tuple2<T, U>> zip(Seq<? extends U> other) {
        return this.from(this.monoid().mapReduce((Stream)this.stream().zip(other)));
    }

    @Override
    default public <S, U> PersistentCollectionX<Tuple3<T, S, U>> zip3(Stream<? extends S> second, Stream<? extends U> third) {
        return this.from(this.monoid().mapReduce((Stream)((Object)this.stream().zip3(second, third))));
    }

    @Override
    default public <T2, T3, T4> PersistentCollectionX<Tuple4<T, T2, T3, T4>> zip4(Stream<T2> second, Stream<T3> third, Stream<T4> fourth) {
        return this.from(this.monoid().mapReduce((Stream)((Object)this.stream().zip4(second, third, fourth))));
    }

    @Override
    default public PersistentCollectionX<Tuple2<T, Long>> zipWithIndex() {
        return this.from(this.monoid().mapReduce((Stream)this.stream().zipWithIndex()));
    }

    @Override
    default public PersistentCollectionX<T> distinct() {
        return this.from(this.monoid().mapReduce(this.stream().distinct()));
    }

    @Override
    default public PersistentCollectionX<T> sorted() {
        return this.from(this.monoid().mapReduce(this.stream().sorted()));
    }

    @Override
    default public PersistentCollectionX<T> sorted(Comparator<? super T> c) {
        return this.from(this.monoid().mapReduce(this.stream().sorted((Comparator)c)));
    }

    @Override
    default public PersistentCollectionX<T> skipWhile(Predicate<? super T> p) {
        return this.from(this.monoid().mapReduce((Stream)this.stream().skipWhile(p)));
    }

    @Override
    default public PersistentCollectionX<T> skipUntil(Predicate<? super T> p) {
        return this.from(this.monoid().mapReduce((Stream)this.stream().skipUntil(p)));
    }

    @Override
    default public PersistentCollectionX<T> limitWhile(Predicate<? super T> p) {
        return this.from(this.monoid().mapReduce((Stream)this.stream().limitWhile(p)));
    }

    @Override
    default public PersistentCollectionX<T> limitUntil(Predicate<? super T> p) {
        return this.from(this.monoid().mapReduce((Stream)this.stream().limitUntil(p)));
    }

    @Override
    default public PersistentCollectionX<T> intersperse(T value) {
        return this.from(this.monoid().mapReduce((Stream)this.stream().intersperse(value)));
    }

    @Override
    default public PersistentCollectionX<T> shuffle() {
        return this.from(this.monoid().mapReduce((Stream)this.stream().shuffle()));
    }

    @Override
    default public PersistentCollectionX<T> skipLast(int num) {
        return this.from(this.monoid().mapReduce((Stream)((Object)this.stream().skipLast(num))));
    }

    @Override
    default public PersistentCollectionX<T> limitLast(int num) {
        return this.from(this.monoid().mapReduce((Stream)((Object)this.stream().limitLast(num))));
    }

    @Override
    default public PersistentCollectionX<T> onEmpty(T value) {
        return this.from(this.monoid().mapReduce((Stream)this.stream().onEmpty(value)));
    }

    @Override
    default public PersistentCollectionX<T> onEmptyGet(Supplier<? extends T> supplier) {
        return this.from(this.monoid().mapReduce((Stream)this.stream().onEmptyGet(supplier)));
    }

    @Override
    default public <X extends Throwable> PersistentCollectionX<T> onEmptyThrow(Supplier<? extends X> supplier) {
        return this.from(this.monoid().mapReduce((Stream)this.stream().onEmptyThrow(supplier)));
    }

    @Override
    default public PersistentCollectionX<T> shuffle(Random random) {
        return this.from(this.monoid().mapReduce((Stream)this.stream().shuffle(random)));
    }

    @Override
    default public <U> PersistentCollectionX<U> ofType(Class<? extends U> type) {
        return this.from(this.monoid().mapReduce((Stream)((Object)this.stream().ofType(type))));
    }

    @Override
    default public PersistentCollectionX<T> filterNot(Predicate<? super T> fn) {
        return this.from(this.monoid().mapReduce((Stream)((Object)this.stream().filterNot(fn))));
    }

    @Override
    default public PersistentCollectionX<T> notNull() {
        return this.from(this.monoid().mapReduce((Stream)((Object)this.stream().notNull())));
    }

    @Override
    default public PersistentCollectionX<T> removeAll(Stream<? extends T> stream) {
        return this.from(this.monoid().mapReduce((Stream)((Object)this.stream().removeAll(stream))));
    }

    @Override
    default public PersistentCollectionX<T> removeAll(Seq<? extends T> stream) {
        return this.from(this.monoid().mapReduce((Stream)this.stream().removeAll(stream)));
    }

    @Override
    default public PersistentCollectionX<T> removeAll(Iterable<? extends T> it) {
        return this.from(this.monoid().mapReduce((Stream)((Object)this.stream().removeAll(it))));
    }

    @Override
    default public PersistentCollectionX<T> removeAll(T ... values) {
        return this.from(this.monoid().mapReduce((Stream)((Object)this.stream().removeAll(values))));
    }

    @Override
    default public PersistentCollectionX<T> retainAll(Iterable<? extends T> it) {
        return this.from(this.monoid().mapReduce((Stream)((Object)this.stream().retainAll(it))));
    }

    @Override
    default public PersistentCollectionX<T> retainAll(Stream<? extends T> seq) {
        return this.from(this.monoid().mapReduce((Stream)((Object)this.stream().retainAll(seq))));
    }

    @Override
    default public PersistentCollectionX<T> retainAll(Seq<? extends T> stream) {
        return this.from(this.monoid().mapReduce((Stream)this.stream().retainAll(stream)));
    }

    @Override
    default public PersistentCollectionX<T> retainAll(T ... values) {
        return this.from(this.monoid().mapReduce((Stream)((Object)this.stream().retainAll(values))));
    }

    @Override
    default public <U> PersistentCollectionX<U> cast(Class<? extends U> type) {
        return this.from(this.monoid().mapReduce((Stream)this.stream().cast(type)));
    }

    @Override
    default public <R> PersistentCollectionX<R> patternMatch(Function<Matchable.CheckValue1<T, R>, Matchable.CheckValue1<T, R>> case1, Supplier<? extends R> otherwise) {
        return this.from(this.monoid().mapReduce((Stream)((Object)this.stream().patternMatch(case1, otherwise))));
    }

    @Override
    default public PersistentCollectionX<ReactiveSeq<T>> permutations() {
        return this.from(this.monoid().mapReduce((Stream)((Object)this.stream().permutations())));
    }

    @Override
    default public PersistentCollectionX<ReactiveSeq<T>> combinations(int size) {
        return this.from(this.monoid().mapReduce((Stream)((Object)this.stream().combinations(size))));
    }

    @Override
    default public PersistentCollectionX<ReactiveSeq<T>> combinations() {
        return this.from(this.monoid().mapReduce((Stream)((Object)this.stream().combinations())));
    }

    @Override
    default public <C extends Collection<? super T>> PersistentCollectionX<C> grouped(int size, Supplier<C> supplier) {
        return this.from(this.monoid().mapReduce((Stream)((Object)this.stream().grouped(size, supplier))));
    }

    @Override
    default public PersistentCollectionX<ListX<T>> groupedUntil(Predicate<? super T> predicate) {
        return this.from(this.monoid().mapReduce((Stream)((Object)this.stream().groupedUntil(predicate))));
    }

    @Override
    default public PersistentCollectionX<ListX<T>> groupedStatefullyWhile(BiPredicate<ListX<? super T>, ? super T> predicate) {
        return this.from(this.monoid().mapReduce((Stream)((Object)this.stream().groupedStatefullyWhile(predicate))));
    }

    @Override
    default public PersistentCollectionX<T> combine(BiPredicate<? super T, ? super T> predicate, BinaryOperator<T> op) {
        return this.from(this.monoid().mapReduce((Stream)((Object)this.stream().combine(predicate, op))));
    }

    @Override
    default public PersistentCollectionX<ListX<T>> groupedWhile(Predicate<? super T> predicate) {
        return this.from(this.monoid().mapReduce((Stream)((Object)this.stream().groupedWhile(predicate))));
    }

    @Override
    default public <C extends Collection<? super T>> PersistentCollectionX<C> groupedWhile(Predicate<? super T> predicate, Supplier<C> factory2) {
        return this.from(this.monoid().mapReduce((Stream)((Object)this.stream().groupedWhile(predicate, factory2))));
    }

    @Override
    default public <C extends Collection<? super T>> PersistentCollectionX<C> groupedUntil(Predicate<? super T> predicate, Supplier<C> factory2) {
        return this.from(this.monoid().mapReduce((Stream)((Object)this.stream().groupedUntil(predicate, factory2))));
    }
}

