/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.data.collections.extensions.persistent;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.Reducer;
import com.aol.cyclops.Reducers;
import com.aol.cyclops.control.Matchable;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.Trampoline;
import com.aol.cyclops.data.collections.extensions.persistent.PQueueXImpl;
import com.aol.cyclops.data.collections.extensions.persistent.PersistentCollectionX;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple2;
import org.jooq.lambda.tuple.Tuple3;
import org.jooq.lambda.tuple.Tuple4;
import org.pcollections.AmortizedPQueue;
import org.pcollections.PQueue;
import org.reactivestreams.Publisher;

public interface PQueueX<T>
extends PQueue<T>,
PersistentCollectionX<T> {
    public static <T> PQueueX<T> of(T ... values) {
        PQueue result = PQueueX.empty();
        for (T value : values) {
            result = result.plus(value);
        }
        return new PQueueXImpl<T>(result);
    }

    public static <T> PQueueX<T> empty() {
        return new PQueueXImpl(AmortizedPQueue.empty());
    }

    public static <T> PQueueX<T> singleton(T value) {
        return PQueueX.empty().plus((Object)value);
    }

    public static <T> PQueueX<T> fromPublisher(Publisher<? extends T> publisher) {
        return ReactiveSeq.fromPublisher(publisher).toPQueueX();
    }

    public static <T> PQueueX<T> fromIterable(Iterable<T> iterable) {
        if (iterable instanceof PQueueX) {
            return (PQueueX)iterable;
        }
        if (iterable instanceof PQueue) {
            return new PQueueXImpl((PQueue)iterable);
        }
        PQueue res = PQueueX.empty();
        Iterator<T> it = iterable.iterator();
        while (it.hasNext()) {
            res = res.plus(it.next());
        }
        return new PQueueXImpl<T>(res);
    }

    public static <T> PQueueX<T> fromCollection(Collection<T> stream) {
        if (stream instanceof PQueueX) {
            return (PQueueX)stream;
        }
        if (stream instanceof PQueue) {
            return new PQueueXImpl((PQueue)stream);
        }
        return PQueueX.empty().plusAll((Collection)stream);
    }

    public static <T> PQueueX<T> fromStream(Stream<T> stream) {
        return Reducers.toPQueueX().mapReduce(stream);
    }

    @Override
    default public PQueueX<T> combine(BiPredicate<? super T, ? super T> predicate, BinaryOperator<T> op) {
        return (PQueueX)PersistentCollectionX.super.combine((BiPredicate)predicate, (BinaryOperator)op);
    }

    @Override
    default public PQueueX<T> toPQueueX() {
        return this;
    }

    @Override
    default public <R> PQueueX<R> unit(Collection<R> col) {
        return PQueueX.fromCollection(col);
    }

    @Override
    default public <R> PQueueX<R> unit(R value) {
        return PQueueX.singleton(value);
    }

    @Override
    default public <R> PQueueX<R> unitIterator(Iterator<R> it) {
        return PQueueX.fromIterable(() -> it);
    }

    @Override
    default public <R> PQueueX<R> emptyUnit() {
        return PQueueX.empty();
    }

    @Override
    default public ReactiveSeq<T> stream() {
        return ReactiveSeq.fromIterable(this);
    }

    default public PQueue<T> toPSet() {
        return this;
    }

    @Override
    default public <X> PQueueX<X> from(Collection<X> col) {
        return PQueueX.fromCollection(col);
    }

    @Override
    default public <T> Reducer<PQueue<T>> monoid() {
        return Reducers.toPQueue();
    }

    @Override
    public PQueueX<T> plus(T var1);

    @Override
    public PQueueX<T> plusAll(Collection<? extends T> var1);

    @Override
    public PQueueX<T> minus(Object var1);

    @Override
    public PQueueX<T> minusAll(Collection<?> var1);

    @Override
    default public PQueueX<T> reverse() {
        return (PQueueX)PersistentCollectionX.super.reverse();
    }

    @Override
    default public PQueueX<T> filter(Predicate<? super T> pred) {
        return (PQueueX)PersistentCollectionX.super.filter((Predicate)pred);
    }

    @Override
    default public <R> PQueueX<R> map(Function<? super T, ? extends R> mapper) {
        return (PQueueX)PersistentCollectionX.super.map((Function)mapper);
    }

    @Override
    default public <R> PQueueX<R> flatMap(Function<? super T, ? extends Iterable<? extends R>> mapper) {
        return (PQueueX)PersistentCollectionX.super.flatMap((Function)mapper);
    }

    @Override
    default public PQueueX<T> limit(long num) {
        return (PQueueX)PersistentCollectionX.super.limit(num);
    }

    @Override
    default public PQueueX<T> skip(long num) {
        return (PQueueX)PersistentCollectionX.super.skip(num);
    }

    @Override
    default public PQueueX<T> takeRight(int num) {
        return (PQueueX)PersistentCollectionX.super.takeRight(num);
    }

    @Override
    default public PQueueX<T> dropRight(int num) {
        return (PQueueX)PersistentCollectionX.super.dropRight(num);
    }

    @Override
    default public PQueueX<T> takeWhile(Predicate<? super T> p) {
        return (PQueueX)PersistentCollectionX.super.takeWhile((Predicate)p);
    }

    @Override
    default public PQueueX<T> dropWhile(Predicate<? super T> p) {
        return (PQueueX)PersistentCollectionX.super.dropWhile((Predicate)p);
    }

    @Override
    default public PQueueX<T> takeUntil(Predicate<? super T> p) {
        return (PQueueX)PersistentCollectionX.super.takeUntil((Predicate)p);
    }

    @Override
    default public PQueueX<T> dropUntil(Predicate<? super T> p) {
        return (PQueueX)PersistentCollectionX.super.dropUntil((Predicate)p);
    }

    @Override
    default public <R> PQueueX<R> trampoline(Function<? super T, ? extends Trampoline<? extends R>> mapper) {
        return (PQueueX)PersistentCollectionX.super.trampoline((Function)mapper);
    }

    @Override
    default public PQueueX<T> slice(long from, long to) {
        return (PQueueX)PersistentCollectionX.super.slice(from, to);
    }

    @Override
    default public <U extends Comparable<? super U>> PQueueX<T> sorted(Function<? super T, ? extends U> function) {
        return (PQueueX)PersistentCollectionX.super.sorted((Function)function);
    }

    @Override
    default public PQueueX<ListX<T>> grouped(int groupSize) {
        return (PQueueX)PersistentCollectionX.super.grouped(groupSize);
    }

    @Override
    default public <K, A, D> PQueueX<Tuple2<K, D>> grouped(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return (PQueueX)PersistentCollectionX.super.grouped((Function)classifier, (Collector)downstream);
    }

    @Override
    default public <K> PQueueX<Tuple2<K, Seq<T>>> grouped(Function<? super T, ? extends K> classifier) {
        return (PQueueX)PersistentCollectionX.super.grouped((Function)classifier);
    }

    @Override
    default public <U> PQueueX<Tuple2<T, U>> zip(Iterable<? extends U> other) {
        return (PQueueX)PersistentCollectionX.super.zip((Iterable)other);
    }

    @Override
    default public <U, R> PQueueX<R> zip(Iterable<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return (PQueueX)PersistentCollectionX.super.zip((Iterable)other, (BiFunction)zipper);
    }

    @Override
    default public PQueueX<ReactiveSeq<T>> permutations() {
        return (PQueueX)PersistentCollectionX.super.permutations();
    }

    @Override
    default public PQueueX<ReactiveSeq<T>> combinations(int size) {
        return (PQueueX)PersistentCollectionX.super.combinations(size);
    }

    @Override
    default public PQueueX<ReactiveSeq<T>> combinations() {
        return (PQueueX)PersistentCollectionX.super.combinations();
    }

    @Override
    default public PQueueX<ListX<T>> sliding(int windowSize) {
        return (PQueueX)PersistentCollectionX.super.sliding(windowSize);
    }

    @Override
    default public PQueueX<ListX<T>> sliding(int windowSize, int increment) {
        return (PQueueX)PersistentCollectionX.super.sliding(windowSize, increment);
    }

    @Override
    default public PQueueX<T> scanLeft(Monoid<T> monoid) {
        return (PQueueX)PersistentCollectionX.super.scanLeft((Monoid)monoid);
    }

    @Override
    default public <U> PQueueX<U> scanLeft(U seed, BiFunction<? super U, ? super T, ? extends U> function) {
        return (PQueueX)PersistentCollectionX.super.scanLeft((Object)seed, (BiFunction)function);
    }

    @Override
    default public PQueueX<T> scanRight(Monoid<T> monoid) {
        return (PQueueX)PersistentCollectionX.super.scanRight((Monoid)monoid);
    }

    @Override
    default public <U> PQueueX<U> scanRight(U identity, BiFunction<? super T, ? super U, ? extends U> combiner) {
        return (PQueueX)PersistentCollectionX.super.scanRight((Object)identity, (BiFunction)combiner);
    }

    @Override
    default public PQueueX<T> plusInOrder(T e) {
        return (PQueueX)PersistentCollectionX.super.plusInOrder((Object)e);
    }

    @Override
    default public PQueueX<T> cycle(int times) {
        return (PQueueX)PersistentCollectionX.super.cycle(times);
    }

    @Override
    default public PQueueX<T> cycle(Monoid<T> m, int times) {
        return (PQueueX)PersistentCollectionX.super.cycle((Monoid)m, times);
    }

    @Override
    default public PQueueX<T> cycleWhile(Predicate<? super T> predicate) {
        return (PQueueX)PersistentCollectionX.super.cycleWhile((Predicate)predicate);
    }

    @Override
    default public PQueueX<T> cycleUntil(Predicate<? super T> predicate) {
        return (PQueueX)PersistentCollectionX.super.cycleUntil((Predicate)predicate);
    }

    @Override
    default public <U> PQueueX<Tuple2<T, U>> zipStream(Stream<? extends U> other) {
        return (PQueueX)PersistentCollectionX.super.zipStream((Stream)other);
    }

    @Override
    default public <U> PQueueX<Tuple2<T, U>> zip(Seq<? extends U> other) {
        return (PQueueX)PersistentCollectionX.super.zip((Seq)other);
    }

    @Override
    default public <S, U> PQueueX<Tuple3<T, S, U>> zip3(Stream<? extends S> second, Stream<? extends U> third) {
        return (PQueueX)PersistentCollectionX.super.zip3((Stream)second, (Stream)third);
    }

    @Override
    default public <T2, T3, T4> PQueueX<Tuple4<T, T2, T3, T4>> zip4(Stream<T2> second, Stream<T3> third, Stream<T4> fourth) {
        return (PQueueX)PersistentCollectionX.super.zip4((Stream)second, (Stream)third, (Stream)fourth);
    }

    @Override
    default public PQueueX<Tuple2<T, Long>> zipWithIndex() {
        return (PQueueX)PersistentCollectionX.super.zipWithIndex();
    }

    @Override
    default public PQueueX<T> distinct() {
        return (PQueueX)PersistentCollectionX.super.distinct();
    }

    @Override
    default public PQueueX<T> sorted() {
        return (PQueueX)PersistentCollectionX.super.sorted();
    }

    @Override
    default public PQueueX<T> sorted(Comparator<? super T> c) {
        return (PQueueX)PersistentCollectionX.super.sorted((Comparator)c);
    }

    @Override
    default public PQueueX<T> skipWhile(Predicate<? super T> p) {
        return (PQueueX)PersistentCollectionX.super.skipWhile((Predicate)p);
    }

    @Override
    default public PQueueX<T> skipUntil(Predicate<? super T> p) {
        return (PQueueX)PersistentCollectionX.super.skipUntil((Predicate)p);
    }

    @Override
    default public PQueueX<T> limitWhile(Predicate<? super T> p) {
        return (PQueueX)PersistentCollectionX.super.limitWhile((Predicate)p);
    }

    @Override
    default public PQueueX<T> limitUntil(Predicate<? super T> p) {
        return (PQueueX)PersistentCollectionX.super.limitUntil((Predicate)p);
    }

    @Override
    default public PQueueX<T> intersperse(T value) {
        return (PQueueX)PersistentCollectionX.super.intersperse((Object)value);
    }

    @Override
    default public PQueueX<T> shuffle() {
        return (PQueueX)PersistentCollectionX.super.shuffle();
    }

    @Override
    default public PQueueX<T> skipLast(int num) {
        return (PQueueX)PersistentCollectionX.super.skipLast(num);
    }

    @Override
    default public PQueueX<T> limitLast(int num) {
        return (PQueueX)PersistentCollectionX.super.limitLast(num);
    }

    @Override
    default public PQueueX<T> onEmpty(T value) {
        return (PQueueX)PersistentCollectionX.super.onEmpty((Object)value);
    }

    @Override
    default public PQueueX<T> onEmptyGet(Supplier<? extends T> supplier) {
        return (PQueueX)PersistentCollectionX.super.onEmptyGet((Supplier)supplier);
    }

    @Override
    default public <X extends Throwable> PQueueX<T> onEmptyThrow(Supplier<? extends X> supplier) {
        return (PQueueX)PersistentCollectionX.super.onEmptyThrow((Supplier)supplier);
    }

    @Override
    default public PQueueX<T> shuffle(Random random) {
        return (PQueueX)PersistentCollectionX.super.shuffle(random);
    }

    @Override
    default public <U> PQueueX<U> ofType(Class<? extends U> type) {
        return (PQueueX)PersistentCollectionX.super.ofType((Class)type);
    }

    @Override
    default public PQueueX<T> filterNot(Predicate<? super T> fn) {
        return (PQueueX)PersistentCollectionX.super.filterNot((Predicate)fn);
    }

    @Override
    default public PQueueX<T> notNull() {
        return (PQueueX)PersistentCollectionX.super.notNull();
    }

    @Override
    default public PQueueX<T> removeAll(Stream<? extends T> stream) {
        return (PQueueX)PersistentCollectionX.super.removeAll((Stream)stream);
    }

    @Override
    default public PQueueX<T> removeAll(Iterable<? extends T> it) {
        return (PQueueX)PersistentCollectionX.super.removeAll((Iterable)it);
    }

    @Override
    default public PQueueX<T> removeAll(T ... values) {
        return (PQueueX)PersistentCollectionX.super.removeAll((Object[])values);
    }

    @Override
    default public PQueueX<T> retainAll(Iterable<? extends T> it) {
        return (PQueueX)PersistentCollectionX.super.retainAll((Iterable)it);
    }

    @Override
    default public PQueueX<T> retainAll(Stream<? extends T> seq) {
        return (PQueueX)PersistentCollectionX.super.retainAll((Stream)seq);
    }

    @Override
    default public PQueueX<T> retainAll(T ... values) {
        return (PQueueX)PersistentCollectionX.super.retainAll((Object[])values);
    }

    @Override
    default public <U> PQueueX<U> cast(Class<? extends U> type) {
        return (PQueueX)PersistentCollectionX.super.cast((Class)type);
    }

    @Override
    default public <R> PQueueX<R> patternMatch(Function<Matchable.CheckValue1<T, R>, Matchable.CheckValue1<T, R>> case1, Supplier<? extends R> otherwise) {
        return (PQueueX)PersistentCollectionX.super.patternMatch((Function)case1, (Supplier)otherwise);
    }

    @Override
    default public <C extends Collection<? super T>> PQueueX<C> grouped(int size, Supplier<C> supplier) {
        return (PQueueX)PersistentCollectionX.super.grouped(size, (Supplier)supplier);
    }

    @Override
    default public PQueueX<ListX<T>> groupedUntil(Predicate<? super T> predicate) {
        return (PQueueX)PersistentCollectionX.super.groupedUntil((Predicate)predicate);
    }

    @Override
    default public PQueueX<ListX<T>> groupedStatefullyWhile(BiPredicate<ListX<? super T>, ? super T> predicate) {
        return (PQueueX)PersistentCollectionX.super.groupedStatefullyWhile((BiPredicate)predicate);
    }

    @Override
    default public PQueueX<ListX<T>> groupedWhile(Predicate<? super T> predicate) {
        return (PQueueX)PersistentCollectionX.super.groupedWhile((Predicate)predicate);
    }

    @Override
    default public <C extends Collection<? super T>> PQueueX<C> groupedWhile(Predicate<? super T> predicate, Supplier<C> factory2) {
        return (PQueueX)PersistentCollectionX.super.groupedWhile((Predicate)predicate, (Supplier)factory2);
    }

    @Override
    default public <C extends Collection<? super T>> PQueueX<C> groupedUntil(Predicate<? super T> predicate, Supplier<C> factory2) {
        return (PQueueX)PersistentCollectionX.super.groupedUntil((Predicate)predicate, (Supplier)factory2);
    }

    @Override
    default public PQueueX<T> removeAll(Seq<? extends T> stream) {
        return (PQueueX)PersistentCollectionX.super.removeAll((Seq)stream);
    }

    @Override
    default public PQueueX<T> retainAll(Seq<? extends T> stream) {
        return (PQueueX)PersistentCollectionX.super.retainAll((Seq)stream);
    }
}

