/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.data.async;

import com.aol.cyclops.data.async.ContinuationStrategy;
import com.aol.cyclops.data.async.Queue;
import com.aol.cyclops.react.async.subscription.Continueable;
import com.aol.cyclops.types.futurestream.Continuation;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;

public interface AdaptersModule {

    public static class ClosingSpliterator<T>
    implements Spliterator<T> {
        private long estimate;
        final Supplier<T> s;
        private final Continueable subscription;
        private final Queue queue;

        public ClosingSpliterator(long estimate, Supplier<T> s, Continueable subscription, Queue queue) {
            this.estimate = estimate;
            this.s = s;
            this.subscription = subscription;
            this.queue = queue;
            this.subscription.addQueue(queue);
        }

        public ClosingSpliterator(long estimate, Supplier<T> s, Continueable subscription) {
            this.estimate = estimate;
            this.s = s;
            this.subscription = subscription;
            this.queue = null;
        }

        @Override
        public long estimateSize() {
            return this.estimate;
        }

        @Override
        public int characteristics() {
            return 1024;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            Objects.requireNonNull(action);
            try {
                action.accept(this.s.get());
                this.subscription.closeQueueIfFinished(this.queue);
                return true;
            }
            catch (Queue.ClosedQueueException e) {
                if (!e.isDataPresent()) return false;
                e.getCurrentData().forEach(action);
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public Spliterator<T> trySplit() {
            return new ClosingSpliterator<T>(this.estimate >>>= 1, this.s, this.subscription, this.queue);
        }
    }

    public static class QueueToBlockingQueueWrapper
    implements BlockingQueue {
        java.util.Queue queue;

        @Override
        public void forEach(Consumer action) {
            this.queue.forEach(action);
        }

        @Override
        public int hashCode() {
            return this.queue.hashCode();
        }

        @Override
        public Object remove() {
            return this.queue.remove();
        }

        @Override
        public boolean equals(Object obj) {
            return this.queue.equals(obj);
        }

        @Override
        public Object element() {
            return this.queue.element();
        }

        @Override
        public void clear() {
            this.queue.clear();
        }

        @Override
        public boolean containsAll(Collection c) {
            return this.queue.containsAll(c);
        }

        @Override
        public boolean add(Object e) {
            return this.queue.add(e);
        }

        @Override
        public boolean removeAll(Collection c) {
            return this.queue.removeAll(c);
        }

        @Override
        public boolean offer(Object e) {
            return this.queue.offer(e);
        }

        @Override
        public boolean retainAll(Collection c) {
            return this.queue.retainAll(c);
        }

        @Override
        public Object poll() {
            return this.queue.poll();
        }

        @Override
        public Object peek() {
            return this.queue.peek();
        }

        public String toString() {
            return this.queue.toString();
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        @Override
        public int size() {
            return this.queue.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.queue.contains(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.queue.remove(o);
        }

        @Override
        public boolean removeIf(Predicate filter) {
            return this.queue.removeIf(filter);
        }

        @Override
        public boolean addAll(Collection c) {
            return this.queue.addAll(c);
        }

        @Override
        public Object[] toArray() {
            return this.queue.toArray();
        }

        @Override
        public Object[] toArray(Object[] a) {
            return this.queue.toArray(a);
        }

        @Override
        public Iterator iterator() {
            return this.queue.iterator();
        }

        @Override
        public Stream stream() {
            return this.queue.stream();
        }

        @Override
        public Stream parallelStream() {
            return this.queue.parallelStream();
        }

        @Override
        public Spliterator spliterator() {
            return this.queue.spliterator();
        }

        public void put(Object e) throws InterruptedException {
            this.offer(e);
        }

        public boolean offer(Object e, long timeout, TimeUnit unit) throws InterruptedException {
            return this.offer(e);
        }

        public Object take() throws InterruptedException {
            return this.poll();
        }

        public Object poll(long timeout, TimeUnit unit) throws InterruptedException {
            return this.poll();
        }

        @Override
        public int remainingCapacity() {
            return 0;
        }

        public int drainTo(Collection c) {
            return 0;
        }

        public int drainTo(Collection c, int maxElements) {
            return 0;
        }

        @ConstructorProperties(value={"queue"})
        public QueueToBlockingQueueWrapper(java.util.Queue queue) {
            this.queue = queue;
        }
    }

    public static class SingleContinuation
    implements ContinuationStrategy {
        private final Queue<?> queue;
        private Continuation continuation = null;

        public SingleContinuation(Queue<?> queue) {
            this.queue = queue;
        }

        @Override
        public void addContinuation(Continuation c) {
            this.continuation = c;
        }

        @Override
        public void handleContinuation() {
            this.continuation = this.continuation.proceed();
        }
    }

    public static class StreamOfContinuations
    implements ContinuationStrategy {
        private final Queue<?> queue;
        private List<Continuation> continuation = new ArrayList<Continuation>();

        public StreamOfContinuations(Queue<?> queue) {
            this.queue = queue;
        }

        @Override
        public void addContinuation(Continuation c) {
            this.continuation.add(c);
        }

        @Override
        public void handleContinuation() {
            this.continuation = Seq.seq(this.continuation).map(c -> {
                try {
                    return Optional.of(c.proceed());
                }
                catch (Queue.ClosedQueueException e) {
                    return Optional.empty();
                }
            }).filter(Optional::isPresent).map(Optional::get).toList();
            if (this.continuation.size() == 0) {
                this.queue.close();
                throw new Queue.ClosedQueueException();
            }
        }
    }
}

