/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.control.monads.transformers.values;

import com.aol.cyclops.control.AnyM;
import com.aol.cyclops.control.Matchable;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.Trampoline;
import com.aol.cyclops.control.Xor;
import com.aol.cyclops.control.monads.transformers.XorT;
import com.aol.cyclops.control.monads.transformers.values.TransformerValue;
import com.aol.cyclops.types.ConvertableFunctor;
import com.aol.cyclops.types.Filterable;
import com.aol.cyclops.types.MonadicValue;
import com.aol.cyclops.types.MonadicValue2;
import com.aol.cyclops.types.anyM.AnyMValue;
import com.aol.cyclops.types.applicative.Applicativable;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;

public class XorTValue<ST, T>
implements XorT<ST, T>,
MonadicValue2<ST, T>,
TransformerValue<T>,
Supplier<T>,
ConvertableFunctor<T>,
Filterable<T>,
Applicativable<T>,
Matchable.ValueAndOptionalMatcher<T> {
    private final AnyMValue<Xor<ST, T>> run;

    private XorTValue(AnyMValue<Xor<ST, T>> run) {
        this.run = run;
    }

    public Xor<ST, T> value() {
        return (Xor)this.run.get();
    }

    @Override
    public boolean isValuePresent() {
        return !this.run.isEmpty();
    }

    @Override
    public AnyMValue<Xor<ST, T>> unwrap() {
        return this.run;
    }

    @Override
    public XorTValue<T, ST> swap() {
        return XorTValue.of(this.run.map((T xor) -> xor.swap()));
    }

    @Override
    public XorTValue<ST, T> peek(Consumer<? super T> peek) {
        return XorTValue.of(this.run.peek((T opt) -> opt.map((T a) -> {
            peek.accept(a);
            return a;
        })));
    }

    @Override
    public XorTValue<ST, T> filter(Predicate<? super T> test) {
        return XorTValue.of(this.run.map((T opt) -> opt.filter(test)));
    }

    @Override
    public <B> XorTValue<ST, B> map(Function<? super T, ? extends B> f) {
        return new XorTValue<ST, T>(this.run.map((T o) -> o.map(f)));
    }

    public <ST2, B> XorTValue<ST, B> flatMapT(Function<? super T, XorTValue<ST2, ? extends B>> f) {
        return XorTValue.of(this.run.bind((T opt) -> {
            if (opt.isPrimary()) {
                return ((XorTValue)f.apply(opt.get())).run.unwrap();
            }
            return this;
        }));
    }

    @Override
    public <ST2, B> XorTValue<ST2, B> flatMap(Function<? super T, ? extends MonadicValue2<? extends ST2, ? extends B>> f) {
        return new XorTValue<ST, T>(this.run.map((T o) -> o.flatMap(f)));
    }

    public static <ST, U, R> Function<XorTValue<ST, U>, XorTValue<ST, R>> lift(Function<? super U, ? extends R> fn) {
        return optTu -> optTu.map((T input) -> fn.apply((Object)input));
    }

    public static <ST, U1, U2, R> BiFunction<XorTValue<ST, U1>, XorTValue<ST, U2>, XorTValue<ST, R>> lift2(BiFunction<? super U1, ? super U2, ? extends R> fn) {
        return (optTu1, optTu2) -> optTu1.flatMapT(input1 -> optTu2.map((T input2) -> fn.apply((Object)input1, (Object)input2)));
    }

    public static <ST, A> XorTValue<ST, A> fromAnyM(AnyMValue<A> anyM) {
        return XorTValue.of(anyM.map(Xor::primary));
    }

    public static <ST, A> XorTValue<ST, A> of(AnyMValue<Xor<ST, A>> monads) {
        return new XorTValue(monads);
    }

    public static <ST, A> XorTValue<ST, A> of(Xor<ST, A> monads) {
        return XorT.fromOptional(Optional.of(monads));
    }

    public static <A, ST, V extends MonadicValue<Xor<ST, A>>> XorTValue<ST, A> fromValue(V monadicValue) {
        return XorTValue.of(AnyM.ofValue(monadicValue));
    }

    public String toString() {
        return String.format("XorTValue[%s]", this.run);
    }

    @Override
    public T get() {
        return (T)((Xor)this.run.get()).get();
    }

    public boolean isPrimary() {
        return this.run.orElse(Xor.secondary(null)).isPrimary();
    }

    public boolean isSecondary() {
        return ((Xor)this.run.orElseGet(Xor.primary(null))).isSecondary();
    }

    @Override
    public ReactiveSeq<T> stream() {
        return this.run.orElseGet(() -> Xor.secondary(null)).stream();
    }

    @Override
    public Iterator<T> iterator() {
        return this.run.orElse(Xor.secondary(null)).iterator();
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        this.run.orElse(Xor.secondary(null)).subscribe(s);
    }

    @Override
    public boolean test(T t) {
        return ((Xor)this.run.get()).test(t);
    }

    public <R> R visit(Function<?, ? extends R> secondary, Function<? super T, ? extends R> primary, Supplier<R> none) {
        if (!this.isSecondary() && !this.isPrimary()) {
            return none.get();
        }
        if (this.isSecondary()) {
            return (R)((Xor)this.run.get()).swap().visit(secondary, () -> null);
        }
        return (R)this.visit(primary, () -> null);
    }

    @Override
    public <R> XorTValue<ST, R> unit(R value) {
        return XorTValue.of(this.run.unit((Object)Xor.primary(value)));
    }

    @Override
    public <R> XorTValue<ST, R> empty() {
        return XorTValue.of(this.run.unit((Object)Xor.secondary(null)));
    }

    public static <ST, PT> XorTValue<ST, PT> emptyOptional() {
        return XorT.fromOptional(Optional.empty());
    }

    @Override
    public <U> XorTValue<ST, U> cast(Class<? extends U> type) {
        return (XorTValue)XorT.super.cast((Class)type);
    }

    @Override
    public <R> XorTValue<ST, R> trampoline(Function<? super T, ? extends Trampoline<? extends R>> mapper) {
        return (XorTValue)XorT.super.trampoline((Function)mapper);
    }

    @Override
    public <R> XorTValue<ST, R> patternMatch(Function<Matchable.CheckValue1<T, R>, Matchable.CheckValue1<T, R>> case1, Supplier<? extends R> otherwise) {
        return (XorTValue)XorT.super.patternMatch((Function)case1, (Supplier)otherwise);
    }

    @Override
    public <U> XorTValue<ST, U> ofType(Class<? extends U> type) {
        return (XorTValue)XorT.super.ofType((Class)type);
    }

    @Override
    public XorTValue<ST, T> filterNot(Predicate<? super T> fn) {
        return (XorTValue)XorT.super.filterNot((Predicate)fn);
    }

    @Override
    public XorTValue<ST, T> notNull() {
        return (XorTValue)XorT.super.notNull();
    }
}

