/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.control.monads.transformers.values;

import com.aol.cyclops.control.AnyM;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.monads.transformers.StreamT;
import com.aol.cyclops.types.Foldable;
import com.aol.cyclops.types.MonadicValue;
import com.aol.cyclops.types.Traversable;
import com.aol.cyclops.types.anyM.AnyMValue;
import com.aol.cyclops.types.stream.CyclopsCollectable;
import com.aol.cyclops.util.stream.StreamUtils;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class StreamTValue<T>
implements StreamT<T> {
    private final AnyMValue<ReactiveSeq<T>> run;

    private StreamTValue(AnyMValue<? extends Stream<T>> run) {
        this.run = run.map((T s) -> ReactiveSeq.fromStream(s));
    }

    @Override
    public AnyMValue<ReactiveSeq<T>> unwrap() {
        return this.run;
    }

    @Override
    public boolean isSeqPresent() {
        return !this.run.isEmpty();
    }

    @Override
    public StreamTValue<T> peek(Consumer<? super T> peek) {
        return this.map((T a) -> {
            peek.accept(a);
            return a;
        });
    }

    @Override
    public StreamTValue<T> filter(Predicate<? super T> test) {
        return StreamTValue.of(this.run.map((T stream) -> stream.filter(test)));
    }

    @Override
    public <B> StreamTValue<B> map(Function<? super T, ? extends B> f) {
        return new StreamTValue<T>(this.run.map((T o) -> o.map(f)));
    }

    public <B> StreamTValue<B> flatMapT(Function<? super T, StreamTValue<? extends B>> f) {
        return StreamTValue.of(this.run.map((T stream) -> stream.flatMap((T a) -> ((StreamTValue)f.apply(a)).run.stream()).flatMap((T a) -> a)));
    }

    @Override
    public <B> StreamTValue<B> flatMap(Function<? super T, ? extends Stream<? extends B>> f) {
        return new StreamTValue<T>(this.run.map((T o) -> o.flatMap(f)));
    }

    public static <U, R> Function<StreamTValue<U>, StreamTValue<R>> lift(Function<? super U, ? extends R> fn) {
        return optTu -> optTu.map((T input) -> fn.apply((Object)input));
    }

    public static <A> StreamTValue<A> fromAnyM(AnyMValue<A> anyM) {
        return StreamTValue.of(anyM.map(Stream::of));
    }

    public static <A> StreamTValue<A> of(AnyMValue<? extends Stream<A>> monads) {
        return new StreamTValue(monads);
    }

    public static <A> StreamTValue<A> of(Stream<A> monads) {
        return StreamT.fromOptional(Optional.of(monads));
    }

    public static <A, V extends MonadicValue<? extends Stream<A>>> StreamTValue<A> fromValue(V monadicValue) {
        return StreamTValue.of(AnyM.ofValue(monadicValue));
    }

    public boolean isStreamPresent() {
        return !this.run.isEmpty();
    }

    public Stream<T> get() {
        return (Stream)this.run.get();
    }

    public String toString() {
        return String.format("StreamTValue[%s]", this.run);
    }

    @Override
    public Iterator<T> iterator() {
        return this.stream().iterator();
    }

    @Override
    public <U> StreamTValue<U> unitIterator(Iterator<U> u) {
        return StreamTValue.of(this.run.unit(StreamUtils.stream(u)));
    }

    @Override
    public <T> StreamTValue<T> unit(T unit) {
        return StreamTValue.of(this.run.unit(Stream.of(unit)));
    }

    @Override
    public ReactiveSeq<T> stream() {
        return this.run.stream().flatMap((T i) -> i);
    }

    @Override
    public <R> StreamTValue<R> empty() {
        return StreamTValue.of(this.run.empty());
    }

    public static <T> StreamTValue<T> emptyOptional() {
        return StreamT.fromOptional(Optional.empty());
    }

    @Override
    public AnyM<? extends Foldable<T>> nestedFoldables() {
        return this.run;
    }

    @Override
    public AnyM<? extends CyclopsCollectable<T>> nestedCollectables() {
        return this.run;
    }

    @Override
    public <T> StreamTValue<T> unitAnyM(AnyM<Traversable<T>> traversable) {
        return StreamTValue.of((AnyMValue)traversable.map((T t) -> ReactiveSeq.fromIterable(t)));
    }

    @Override
    public AnyM<? extends Traversable<T>> transformerStream() {
        return this.run;
    }
}

