/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.control.monads.transformers.values;

import com.aol.cyclops.control.AnyM;
import com.aol.cyclops.control.Matchable;
import com.aol.cyclops.control.Maybe;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.Trampoline;
import com.aol.cyclops.control.monads.transformers.OptionalT;
import com.aol.cyclops.control.monads.transformers.values.TransformerValue;
import com.aol.cyclops.types.ConvertableFunctor;
import com.aol.cyclops.types.Filterable;
import com.aol.cyclops.types.MonadicValue;
import com.aol.cyclops.types.anyM.AnyMValue;
import com.aol.cyclops.types.applicative.Applicativable;
import com.aol.cyclops.util.stream.StreamUtils;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;

public class OptionalTValue<T>
implements OptionalT<T>,
TransformerValue<T>,
MonadicValue<T>,
Supplier<T>,
ConvertableFunctor<T>,
Filterable<T>,
Applicativable<T>,
Matchable.ValueAndOptionalMatcher<T> {
    private final AnyMValue<Optional<T>> run;

    private OptionalTValue(AnyMValue<Optional<T>> run) {
        this.run = run;
    }

    @Override
    public Maybe<T> value() {
        return Maybe.fromOptional((Optional)this.run.get());
    }

    @Override
    public boolean isValuePresent() {
        return !this.run.isEmpty();
    }

    @Override
    public AnyMValue<Optional<T>> unwrap() {
        return this.run;
    }

    @Override
    public OptionalTValue<T> peek(Consumer<? super T> peek) {
        return OptionalTValue.of(this.run.peek((T opt) -> opt.map((? super T a) -> {
            peek.accept(a);
            return a;
        })));
    }

    @Override
    public OptionalTValue<T> filter(Predicate<? super T> test) {
        return OptionalTValue.of(this.run.map((T opt) -> opt.filter(test)));
    }

    @Override
    public <B> OptionalTValue<B> map(Function<? super T, ? extends B> f) {
        return new OptionalTValue<T>(this.run.map((T o) -> o.map(f)));
    }

    public <B> OptionalTValue<B> flatMapT(Function<? super T, OptionalTValue<? extends B>> f) {
        return OptionalTValue.of(this.run.bind((T opt) -> {
            if (opt.isPresent()) {
                return ((OptionalTValue)f.apply(opt.get())).run.unwrap();
            }
            return this.run.unit((Object)Optional.empty()).unwrap();
        }));
    }

    private static <B> AnyMValue<Optional<B>> narrow(AnyMValue<Optional<? extends B>> run) {
        return run;
    }

    @Override
    public <B> OptionalTValue<B> flatMap(Function<? super T, ? extends MonadicValue<? extends B>> f) {
        AnyM mapped = this.run.map((T o) -> Maybe.fromOptional(o).flatMap(f).toOptional());
        return OptionalTValue.of(OptionalTValue.narrow(mapped));
    }

    public static <U, R> Function<OptionalTValue<U>, OptionalTValue<R>> lift(Function<U, R> fn) {
        return optTu -> optTu.map((T input) -> fn.apply(input));
    }

    public static <U1, U2, R> BiFunction<OptionalTValue<U1>, OptionalTValue<U2>, OptionalTValue<R>> lift2(BiFunction<? super U1, ? super U2, ? extends R> fn) {
        return (optTu1, optTu2) -> optTu1.flatMapT(input1 -> optTu2.map((T input2) -> fn.apply((Object)input1, (Object)input2)));
    }

    public static <A> OptionalTValue<A> fromAnyM(AnyMValue<A> anyM) {
        return OptionalTValue.of(anyM.map(Optional::ofNullable));
    }

    public static <A> OptionalTValue<A> of(AnyMValue<Optional<A>> monads) {
        return new OptionalTValue(monads);
    }

    public static <A> OptionalTValue<A> of(Optional<A> maybe) {
        return OptionalTValue.fromValue(Maybe.just(maybe));
    }

    public static <A, V extends MonadicValue<Optional<A>>> OptionalTValue<A> fromValue(V monadicValue) {
        return OptionalTValue.of(AnyM.ofValue(monadicValue));
    }

    public String toString() {
        return String.format("OptionalTValue[%s]", this.run);
    }

    @Override
    public T get() {
        return ((Optional)this.run.get()).get();
    }

    @Override
    public boolean isPresent() {
        return this.run.orElse(Optional.empty()).isPresent();
    }

    @Override
    public ReactiveSeq<T> stream() {
        return ReactiveSeq.fromStream(StreamUtils.optionalToStream(this.run.orElse(Optional.empty())));
    }

    @Override
    public Iterator<T> iterator() {
        return Maybe.fromOptional(this.run.orElse(Optional.empty())).iterator();
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        Maybe.fromOptional(this.run.orElse(Optional.empty())).subscribe(s);
    }

    @Override
    public boolean test(T t) {
        return Maybe.fromOptional(this.run.orElse(Optional.empty())).test(t);
    }

    @Override
    public <R> OptionalTValue<R> unit(R value) {
        return OptionalTValue.of(this.run.unit((Object)Optional.of(value)));
    }

    @Override
    public <R> OptionalTValue<R> empty() {
        return OptionalTValue.of(this.run.unit((Object)Optional.empty()));
    }

    public static <T> OptionalTValue<T> emptyOptional() {
        return OptionalTValue.fromValue(Maybe.none());
    }

    @Override
    public <U> OptionalTValue<U> cast(Class<? extends U> type) {
        return (OptionalTValue)TransformerValue.super.cast((Class)type);
    }

    @Override
    public <R> OptionalTValue<R> trampoline(Function<? super T, ? extends Trampoline<? extends R>> mapper) {
        return (OptionalTValue)TransformerValue.super.trampoline((Function)mapper);
    }

    @Override
    public <R> OptionalTValue<R> patternMatch(Function<Matchable.CheckValue1<T, R>, Matchable.CheckValue1<T, R>> case1, Supplier<? extends R> otherwise) {
        return (OptionalTValue)TransformerValue.super.patternMatch((Function)case1, (Supplier)otherwise);
    }

    @Override
    public <U> OptionalTValue<U> ofType(Class<? extends U> type) {
        return (OptionalTValue)OptionalT.super.ofType((Class)type);
    }

    @Override
    public OptionalTValue<T> filterNot(Predicate<? super T> fn) {
        return (OptionalTValue)OptionalT.super.filterNot((Predicate)fn);
    }

    @Override
    public OptionalTValue<T> notNull() {
        return (OptionalTValue)OptionalT.super.notNull();
    }
}

