/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.control.monads.transformers.values;

import com.aol.cyclops.control.AnyM;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.monads.transformers.ListT;
import com.aol.cyclops.control.monads.transformers.values.TransformerSeq;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.types.Foldable;
import com.aol.cyclops.types.MonadicValue;
import com.aol.cyclops.types.Traversable;
import com.aol.cyclops.types.anyM.AnyMValue;
import com.aol.cyclops.types.stream.CyclopsCollectable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;

public class ListTValue<T>
implements ListT<T>,
TransformerSeq<T>,
Publisher<T> {
    final AnyMValue<ListX<T>> run;

    private ListTValue(AnyMValue<? extends List<T>> run) {
        this.run = run.map((T s) -> ListX.fromIterable(s));
    }

    @Override
    public boolean isSeqPresent() {
        return !this.run.isEmpty();
    }

    @Override
    public AnyMValue<ListX<T>> unwrap() {
        return this.run;
    }

    @Override
    public ListTValue<T> peek(Consumer<? super T> peek) {
        return this.map((T a) -> {
            peek.accept(a);
            return a;
        });
    }

    @Override
    public ListTValue<T> filter(Predicate<? super T> test) {
        return ListTValue.of(this.run.map((T stream) -> ReactiveSeq.fromList(stream).filter(test).toList()));
    }

    @Override
    public <B> ListTValue<B> map(Function<? super T, ? extends B> f) {
        return ListTValue.of(this.run.map((T o) -> ReactiveSeq.fromList(o).map(f).toList()));
    }

    @Override
    public <B> ListTValue<B> flatMap(Function<? super T, ? extends Iterable<? extends B>> f) {
        return new ListTValue<T>(this.run.map((T o) -> ListX.fromIterable(o).flatMap(f)));
    }

    public <B> ListTValue<B> flatMapT(Function<? super T, ListTValue<B>> f) {
        return ListTValue.of(this.run.map((T stream) -> ReactiveSeq.fromList(stream).flatMap((T a) -> ((ListTValue)f.apply(a)).run.stream()).flatMap((T a) -> a.stream()).toList()));
    }

    public static <U, R> Function<ListTValue<U>, ListTValue<R>> lift(Function<? super U, ? extends R> fn) {
        return optTu -> optTu.map((T input) -> fn.apply((Object)input));
    }

    public static <U1, U2, R> BiFunction<ListTValue<U1>, ListTValue<U2>, ListTValue<R>> lift2(BiFunction<? super U1, ? super U2, ? extends R> fn) {
        return (optTu1, optTu2) -> optTu1.flatMapT(input1 -> optTu2.map((T input2) -> fn.apply((Object)input1, (Object)input2)));
    }

    public static <A> ListTValue<A> fromAnyM(AnyMValue<A> anyM) {
        return ListTValue.of(anyM.map((T xva$0) -> Arrays.asList(xva$0)));
    }

    public static <A> ListTValue<A> of(AnyMValue<? extends List<A>> monads) {
        return new ListTValue(monads);
    }

    public static <A> ListTValue<A> of(List<A> monads) {
        return ListT.fromOptional(Optional.of(monads));
    }

    public static <A> ListTValue<A> fromStream(AnyMValue<? extends Stream<A>> monads) {
        return ListTValue.of(monads.map((T s) -> s.collect(Collectors.toList())));
    }

    public static <A, V extends MonadicValue<? extends List<A>>> ListTValue<A> fromValue(V monadicValue) {
        return ListTValue.of(AnyM.ofValue(monadicValue));
    }

    public String toString() {
        return String.format("ListTValue[%s]", this.run);
    }

    @Override
    public Iterator<T> iterator() {
        return this.stream().iterator();
    }

    @Override
    public <U> ListTValue<U> unitIterator(Iterator<U> u) {
        return ListTValue.of(this.run.unit((Object)ListX.fromIterable(() -> u)));
    }

    @Override
    public <T> ListTValue<T> unit(T unit) {
        return ListTValue.of(this.run.unit((Object)ListX.of(new Object[]{unit})));
    }

    @Override
    public ReactiveSeq<T> stream() {
        return this.run.stream().flatMap((T i) -> i.stream());
    }

    @Override
    public <R> ListTValue<R> empty() {
        return ListTValue.of(this.run.empty());
    }

    public static <T> ListTValue<T> emptyOptional() {
        return ListT.fromOptional(Optional.empty());
    }

    public boolean isListPresent() {
        return !this.run.isEmpty();
    }

    public List<T> get() {
        return (List)this.run.get();
    }

    @Override
    public AnyM<? extends Foldable<T>> nestedFoldables() {
        return this.run;
    }

    @Override
    public AnyM<? extends CyclopsCollectable<T>> nestedCollectables() {
        return this.run;
    }

    @Override
    public <T> ListTValue<T> unitAnyM(AnyM<Traversable<T>> traversable) {
        return ListTValue.of((AnyMValue)traversable.map((T t) -> ListX.fromIterable(t)));
    }

    @Override
    public AnyM<? extends Traversable<T>> transformerStream() {
        return this.run;
    }
}

