/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.control.monads.transformers.seq;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.control.AnyM;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.monads.transformers.ListT;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.types.Foldable;
import com.aol.cyclops.types.Traversable;
import com.aol.cyclops.types.anyM.AnyMSeq;
import com.aol.cyclops.types.stream.CyclopsCollectable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple2;
import org.jooq.lambda.tuple.Tuple3;
import org.jooq.lambda.tuple.Tuple4;

public class ListTSeq<T>
implements ListT<T> {
    final AnyMSeq<ListX<T>> run;

    private ListTSeq(AnyMSeq<? extends List<T>> run) {
        this.run = run.map((T l) -> ListX.fromIterable(l));
    }

    @Override
    public AnyMSeq<ListX<T>> unwrap() {
        return this.run;
    }

    @Override
    public ListTSeq<T> peek(Consumer<? super T> peek) {
        return this.map((T a) -> {
            peek.accept(a);
            return a;
        });
    }

    @Override
    public ListTSeq<T> filter(Predicate<? super T> test) {
        return ListTSeq.of(this.run.map((T stream) -> ReactiveSeq.fromList(stream).filter(test).toList()));
    }

    @Override
    public <B> ListTSeq<B> map(Function<? super T, ? extends B> f) {
        return ListTSeq.of(this.run.map((T o) -> ReactiveSeq.fromList(o).map(f).toList()));
    }

    @Override
    public <B> ListTSeq<B> flatMap(Function<? super T, ? extends Iterable<? extends B>> f) {
        return new ListTSeq<T>(this.run.map((T o) -> ListX.fromIterable(o).flatMap(f)));
    }

    public <B> ListTSeq<B> flatMapT(Function<? super T, ListTSeq<B>> f) {
        return ListTSeq.of(this.run.map((T stream) -> ReactiveSeq.fromList(stream).flatMap((T a) -> ((ListTSeq)f.apply(a)).run.stream()).flatMap((T a) -> a.stream()).toList()));
    }

    public static <U, R> Function<ListTSeq<U>, ListTSeq<R>> lift(Function<? super U, ? extends R> fn) {
        return optTu -> optTu.map((T input) -> fn.apply((Object)input));
    }

    public static <U1, U2, R> BiFunction<ListTSeq<U1>, ListTSeq<U2>, ListTSeq<R>> lift2(BiFunction<? super U1, ? super U2, ? extends R> fn) {
        return (optTu1, optTu2) -> optTu1.flatMapT(input1 -> optTu2.map((T input2) -> fn.apply((Object)input1, (Object)input2)));
    }

    public static <A> ListTSeq<A> fromAnyM(AnyMSeq<A> anyM) {
        return ListTSeq.of(anyM.map((T xva$0) -> Arrays.asList(xva$0)));
    }

    public static <A> ListTSeq<A> of(AnyMSeq<? extends List<A>> monads) {
        return new ListTSeq(monads);
    }

    public static <A> ListTSeq<A> of(List<A> monads) {
        return ListT.fromIterable(ListX.of(new List[]{monads}));
    }

    public static <A> ListTSeq<A> fromStream(AnyMSeq<Stream<A>> monads) {
        return ListTSeq.of(monads.map((T s) -> s.collect(Collectors.toList())));
    }

    public String toString() {
        return String.format("ListTSeq[%s]", this.run);
    }

    @Override
    public <T> ListTSeq<T> unit(T unit) {
        return ListTSeq.of(this.run.unit((Object)ListX.of(new Object[]{unit})));
    }

    @Override
    public ReactiveSeq<T> stream() {
        return this.run.stream().flatMapIterable(e -> e);
    }

    @Override
    public Iterator<T> iterator() {
        return this.stream().iterator();
    }

    @Override
    public <R> ListTSeq<R> unitIterator(Iterator<R> it) {
        return ListTSeq.of(this.run.unitIterator(it).map((T i) -> ListX.of(new Object[]{i})));
    }

    @Override
    public <R> ListT<R> empty() {
        return ListTSeq.of(this.run.empty());
    }

    @Override
    public AnyM<? extends Foldable<T>> nestedFoldables() {
        return this.run;
    }

    @Override
    public AnyM<? extends CyclopsCollectable<T>> nestedCollectables() {
        return this.run;
    }

    @Override
    public <T> ListTSeq<T> unitAnyM(AnyM<Traversable<T>> traversable) {
        return ListTSeq.of((AnyMSeq)traversable.map((T t) -> ListX.fromIterable(t)));
    }

    public AnyMSeq<? extends Traversable<T>> transformerStream() {
        return this.run;
    }

    public static <T> ListTSeq<T> emptyList() {
        return ListT.fromIterable(ListX.empty());
    }

    @Override
    public boolean isSeqPresent() {
        return !this.run.isEmpty();
    }

    @Override
    public ListTSeq<T> combine(BiPredicate<? super T, ? super T> predicate, BinaryOperator<T> op) {
        return (ListTSeq)ListT.super.combine((BiPredicate)predicate, (BinaryOperator)op);
    }

    @Override
    public ListTSeq<T> cycle(int times) {
        return (ListTSeq)ListT.super.cycle(times);
    }

    @Override
    public ListTSeq<T> cycle(Monoid<T> m, int times) {
        return (ListTSeq)ListT.super.cycle((Monoid)m, times);
    }

    @Override
    public ListTSeq<T> cycleWhile(Predicate<? super T> predicate) {
        return (ListTSeq)ListT.super.cycleWhile((Predicate)predicate);
    }

    @Override
    public ListTSeq<T> cycleUntil(Predicate<? super T> predicate) {
        return (ListTSeq)ListT.super.cycleUntil((Predicate)predicate);
    }

    @Override
    public <U, R> ListTSeq<R> zip(Iterable<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return (ListTSeq)ListT.super.zip((Iterable)other, (BiFunction)zipper);
    }

    @Override
    public <U> ListTSeq<Tuple2<T, U>> zipStream(Stream<? extends U> other) {
        return (ListTSeq)ListT.super.zipStream((Stream)other);
    }

    @Override
    public <U> ListTSeq<Tuple2<T, U>> zip(Seq<? extends U> other) {
        return (ListTSeq)ListT.super.zip((Seq)other);
    }

    @Override
    public <S, U> ListTSeq<Tuple3<T, S, U>> zip3(Stream<? extends S> second, Stream<? extends U> third) {
        return (ListTSeq)ListT.super.zip3((Stream)second, (Stream)third);
    }

    @Override
    public <T2, T3, T4> ListTSeq<Tuple4<T, T2, T3, T4>> zip4(Stream<T2> second, Stream<T3> third, Stream<T4> fourth) {
        return (ListTSeq)ListT.super.zip4((Stream)second, (Stream)third, (Stream)fourth);
    }

    @Override
    public ListTSeq<Tuple2<T, Long>> zipWithIndex() {
        return (ListTSeq)ListT.super.zipWithIndex();
    }

    @Override
    public ListTSeq<ListX<T>> sliding(int windowSize) {
        return (ListTSeq)ListT.super.sliding(windowSize);
    }

    @Override
    public ListTSeq<ListX<T>> sliding(int windowSize, int increment) {
        return (ListTSeq)ListT.super.sliding(windowSize, increment);
    }

    @Override
    public <C extends Collection<? super T>> ListTSeq<C> grouped(int size, Supplier<C> supplier) {
        return (ListTSeq)ListT.super.grouped(size, (Supplier)supplier);
    }

    @Override
    public ListTSeq<ListX<T>> groupedUntil(Predicate<? super T> predicate) {
        return (ListTSeq)ListT.super.groupedUntil((Predicate)predicate);
    }

    @Override
    public ListTSeq<ListX<T>> groupedStatefullyWhile(BiPredicate<ListX<? super T>, ? super T> predicate) {
        return (ListTSeq)ListT.super.groupedStatefullyWhile((BiPredicate)predicate);
    }

    @Override
    public ListTSeq<ListX<T>> groupedWhile(Predicate<? super T> predicate) {
        return (ListTSeq)ListT.super.groupedWhile((Predicate)predicate);
    }

    @Override
    public <C extends Collection<? super T>> ListTSeq<C> groupedWhile(Predicate<? super T> predicate, Supplier<C> factory2) {
        return (ListTSeq)ListT.super.groupedWhile((Predicate)predicate, (Supplier)factory2);
    }

    @Override
    public <C extends Collection<? super T>> ListTSeq<C> groupedUntil(Predicate<? super T> predicate, Supplier<C> factory2) {
        return (ListTSeq)ListT.super.groupedUntil((Predicate)predicate, (Supplier)factory2);
    }

    @Override
    public ListTSeq<ListX<T>> grouped(int groupSize) {
        return (ListTSeq)ListT.super.grouped(groupSize);
    }

    @Override
    public <K, A, D> ListTSeq<Tuple2<K, D>> grouped(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return (ListTSeq)ListT.super.grouped((Function)classifier, (Collector)downstream);
    }

    @Override
    public <K> ListTSeq<Tuple2<K, Seq<T>>> grouped(Function<? super T, ? extends K> classifier) {
        return (ListTSeq)ListT.super.grouped((Function)classifier);
    }

    @Override
    public ListTSeq<T> distinct() {
        return (ListTSeq)ListT.super.distinct();
    }

    @Override
    public ListTSeq<T> scanLeft(Monoid<T> monoid) {
        return (ListTSeq)ListT.super.scanLeft((Monoid)monoid);
    }

    @Override
    public <U> ListTSeq<U> scanLeft(U seed, BiFunction<? super U, ? super T, ? extends U> function) {
        return (ListTSeq)ListT.super.scanLeft((Object)seed, (BiFunction)function);
    }

    @Override
    public ListTSeq<T> scanRight(Monoid<T> monoid) {
        return (ListTSeq)ListT.super.scanRight((Monoid)monoid);
    }

    @Override
    public <U> ListTSeq<U> scanRight(U identity, BiFunction<? super T, ? super U, ? extends U> combiner) {
        return (ListTSeq)ListT.super.scanRight((Object)identity, (BiFunction)combiner);
    }

    @Override
    public ListTSeq<T> sorted() {
        return (ListTSeq)ListT.super.sorted();
    }

    @Override
    public ListTSeq<T> sorted(Comparator<? super T> c) {
        return (ListTSeq)ListT.super.sorted((Comparator)c);
    }

    @Override
    public ListTSeq<T> takeWhile(Predicate<? super T> p) {
        return (ListTSeq)ListT.super.takeWhile((Predicate)p);
    }

    @Override
    public ListTSeq<T> dropWhile(Predicate<? super T> p) {
        return (ListTSeq)ListT.super.dropWhile((Predicate)p);
    }

    @Override
    public ListTSeq<T> takeUntil(Predicate<? super T> p) {
        return (ListTSeq)ListT.super.takeUntil((Predicate)p);
    }

    @Override
    public ListTSeq<T> dropUntil(Predicate<? super T> p) {
        return (ListTSeq)ListT.super.dropUntil((Predicate)p);
    }

    @Override
    public ListTSeq<T> dropRight(int num) {
        return (ListTSeq)ListT.super.dropRight(num);
    }

    @Override
    public ListTSeq<T> takeRight(int num) {
        return (ListTSeq)ListT.super.takeRight(num);
    }

    @Override
    public ListTSeq<T> skip(long num) {
        return (ListTSeq)ListT.super.skip(num);
    }

    @Override
    public ListTSeq<T> skipWhile(Predicate<? super T> p) {
        return (ListTSeq)ListT.super.skipWhile((Predicate)p);
    }

    @Override
    public ListTSeq<T> skipUntil(Predicate<? super T> p) {
        return (ListTSeq)ListT.super.skipUntil((Predicate)p);
    }

    @Override
    public ListTSeq<T> limit(long num) {
        return (ListTSeq)ListT.super.limit(num);
    }

    @Override
    public ListTSeq<T> limitWhile(Predicate<? super T> p) {
        return (ListTSeq)ListT.super.limitWhile((Predicate)p);
    }

    @Override
    public ListTSeq<T> limitUntil(Predicate<? super T> p) {
        return (ListTSeq)ListT.super.limitUntil((Predicate)p);
    }

    @Override
    public ListTSeq<T> intersperse(T value) {
        return (ListTSeq)ListT.super.intersperse((Object)value);
    }

    @Override
    public ListTSeq<T> reverse() {
        return (ListTSeq)ListT.super.reverse();
    }

    @Override
    public ListTSeq<T> shuffle() {
        return (ListTSeq)ListT.super.shuffle();
    }

    @Override
    public ListTSeq<T> skipLast(int num) {
        return (ListTSeq)ListT.super.skipLast(num);
    }

    @Override
    public ListTSeq<T> limitLast(int num) {
        return (ListTSeq)ListT.super.limitLast(num);
    }

    @Override
    public ListTSeq<T> onEmpty(T value) {
        return (ListTSeq)ListT.super.onEmpty((Object)value);
    }

    @Override
    public ListTSeq<T> onEmptyGet(Supplier<? extends T> supplier) {
        return (ListTSeq)ListT.super.onEmptyGet((Supplier)supplier);
    }

    @Override
    public <X extends Throwable> ListTSeq<T> onEmptyThrow(Supplier<? extends X> supplier) {
        return (ListTSeq)ListT.super.onEmptyThrow((Supplier)supplier);
    }

    @Override
    public ListTSeq<T> shuffle(Random random) {
        return (ListTSeq)ListT.super.shuffle(random);
    }

    @Override
    public ListTSeq<T> slice(long from, long to) {
        return (ListTSeq)ListT.super.slice(from, to);
    }

    @Override
    public <U extends Comparable<? super U>> ListTSeq<T> sorted(Function<? super T, ? extends U> function) {
        return (ListTSeq)ListT.super.sorted((Function)function);
    }
}

