/*
 * Decompiled with CFR 0.152.
 */
package com.aol.micro.server.jackson;

import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.micro.server.PluginLoader;
import com.aol.micro.server.jackson.JacksonMapperConfigurator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CoreJacksonConfigurator
implements JacksonMapperConfigurator {
    private final Optional<JsonInclude.Include> inc;

    @Autowired
    public CoreJacksonConfigurator(@Value(value="${jackson.serialization:NON_NULL}") JsonInclude.Include inc) {
        this.inc = Optional.ofNullable(inc);
    }

    @Override
    public void accept(ObjectMapper mapper) {
        JaxbAnnotationModule module = new JaxbAnnotationModule();
        this.inc.map(include -> mapper.setSerializationInclusion(include));
        mapper.registerModule((Module)module);
        ((ListX)PluginLoader.INSTANCE.plugins.get()).stream().filter(m -> m.jacksonModules() != null).flatMap(m -> m.jacksonModules().stream()).forEach(m -> mapper.registerModule(m));
        mapper.registerModule((Module)new Jdk8Module());
    }
}

