/*
 * Decompiled with CFR 0.152.
 */
package com.aol.micro.server.spring.datasource.hibernate;

import com.aol.cyclops2.util.ExceptionSoftener;
import com.aol.micro.server.spring.datasource.JdbcConfig;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate5.HibernateTransactionManager;
import org.springframework.orm.hibernate5.LocalSessionFactoryBean;

public class HibernateSessionBuilder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final JdbcConfig env;
    private final DataSource dataSource;
    private final List<String> packages;

    public SessionFactory sessionFactory() {
        LocalSessionFactoryBean sessionFactoryBean = new LocalSessionFactoryBean();
        sessionFactoryBean.setDataSource(this.dataSource);
        List<String> packagesToScan = this.packages;
        sessionFactoryBean.setPackagesToScan(packagesToScan.toArray(new String[packagesToScan.size()]));
        Properties p = new Properties();
        p.setProperty("hibernate.dialect", this.env.getDialect());
        if (this.env.getShowSql() != null) {
            p.setProperty("hibernate.show_sql", this.env.getShowSql());
        }
        if (this.env.getDdlAuto() != null) {
            p.setProperty("hibernate.hbm2ddl.auto", this.env.getDdlAuto());
        }
        if (this.env.getInitializationFile() != null) {
            p.setProperty("hibernate.hbm2ddl.import_files", this.env.getInitializationFile());
        }
        this.logger.info("Hibernate properties [  hibernate.dialect : {} ; hibernate.hbm2ddl.auto : {} ]", (Object)this.env.getDialect(), (Object)this.env.getDdlAuto());
        sessionFactoryBean.setHibernateProperties(p);
        try {
            sessionFactoryBean.afterPropertiesSet();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            ExceptionSoftener.throwSoftenedException((Throwable)e);
        }
        try {
            return sessionFactoryBean.getObject();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            ExceptionSoftener.throwSoftenedException((Throwable)e);
            return null;
        }
    }

    public HibernateTransactionManager transactionManager() {
        HibernateTransactionManager transactionManager = new HibernateTransactionManager();
        transactionManager.setSessionFactory(this.sessionFactory());
        return transactionManager;
    }

    public static HibernateSessionBuilderBuilder builder() {
        return new HibernateSessionBuilderBuilder();
    }

    @ConstructorProperties(value={"env", "dataSource", "packages"})
    public HibernateSessionBuilder(JdbcConfig env, DataSource dataSource, List<String> packages) {
        this.env = env;
        this.dataSource = dataSource;
        this.packages = packages;
    }

    public static class HibernateSessionBuilderBuilder {
        private JdbcConfig env;
        private DataSource dataSource;
        private List<String> packages;

        HibernateSessionBuilderBuilder() {
        }

        public HibernateSessionBuilderBuilder env(JdbcConfig env) {
            this.env = env;
            return this;
        }

        public HibernateSessionBuilderBuilder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public HibernateSessionBuilderBuilder packages(List<String> packages) {
            this.packages = packages;
            return this;
        }

        public HibernateSessionBuilder build() {
            return new HibernateSessionBuilder(this.env, this.dataSource, this.packages);
        }

        public String toString() {
            return "HibernateSessionBuilder.HibernateSessionBuilderBuilder(env=" + this.env + ", dataSource=" + this.dataSource + ", packages=" + this.packages + ")";
        }
    }
}

