/*
 * Decompiled with CFR 0.152.
 */
package com.aol.micro.server.spring.datasource.hibernate;

import com.aol.micro.server.config.ConfigAccessor;
import com.aol.micro.server.spring.datasource.JdbcConfig;
import com.aol.micro.server.spring.datasource.hibernate.HibernateSessionBuilder;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.orm.hibernate5.HibernateTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
public class HibernateConfig {
    @Resource(name="mainEnv")
    private JdbcConfig env;
    @Resource(name="mainDataSource")
    private DataSource dataSource;

    @Bean
    public HibernateTransactionManager transactionManager() {
        HibernateTransactionManager transactionManager = new HibernateTransactionManager();
        transactionManager.setSessionFactory(this.sessionFactory());
        return transactionManager;
    }

    @Bean
    public SessionFactory sessionFactory() {
        return HibernateSessionBuilder.builder().packages((List)new ConfigAccessor().get().getDataSources().get((Object)new ConfigAccessor().get().getDefaultDataSourceName())).env(this.env).dataSource(this.dataSource).build().sessionFactory();
    }
}

